package org.jboss.pnc.mapper;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.Artifact;
import org.jboss.pnc.dto.Artifact.Builder;
import org.jboss.pnc.dto.ArtifactRef;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.TargetRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-26T15:31:39+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.7 (Oracle Corporation)"
)
*/
@ApplicationScoped
public class AbstractArtifactMapperImpl extends AbstractArtifactMapper {

    @Inject
    private TargetRepositoryMapper targetRepositoryMapper;
    @Inject
    private BuildMapper buildMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public Artifact toDTO(org.jboss.pnc.model.Artifact dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder artifact = Artifact.builder();

        fillDeployAndPublicUrl( dbEntity, artifact );

        artifact.build( buildMapper.toDTO( dbEntity.getBuildRecord() ) );
        artifact.targetRepository( targetRepositoryMapper.toRef( dbEntity.getTargetRepository() ) );
        if ( dbEntity.getId() != null ) {
            artifact.id( String.valueOf( dbEntity.getId() ) );
        }
        artifact.identifier( dbEntity.getIdentifier() );
        artifact.artifactQuality( dbEntity.getArtifactQuality() );
        artifact.md5( dbEntity.getMd5() );
        artifact.sha1( dbEntity.getSha1() );
        artifact.sha256( dbEntity.getSha256() );
        artifact.filename( dbEntity.getFilename() );
        artifact.deployPath( dbEntity.getDeployPath() );
        if ( dbEntity.getImportDate() != null ) {
            artifact.importDate( dbEntity.getImportDate().toInstant() );
        }
        artifact.originUrl( dbEntity.getOriginUrl() );
        artifact.size( dbEntity.getSize() );
        artifact.creationUser( userMapper.toRef( dbEntity.getCreationUser() ) );
        artifact.modificationUser( userMapper.toRef( dbEntity.getModificationUser() ) );
        if ( dbEntity.getCreationTime() != null ) {
            artifact.creationTime( dbEntity.getCreationTime().toInstant() );
        }
        if ( dbEntity.getModificationTime() != null ) {
            artifact.modificationTime( dbEntity.getModificationTime().toInstant() );
        }
        artifact.qualityLevelReason( dbEntity.getQualityLevelReason() );

        return artifact.build();
    }

    @Override
    public ArtifactRef toRef(org.jboss.pnc.model.Artifact dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.ArtifactRef.Builder artifactRef = ArtifactRef.refBuilder();

        fillDeployAndPublicUrl( dbEntity, artifactRef );

        if ( dbEntity.getId() != null ) {
            artifactRef.id( String.valueOf( dbEntity.getId() ) );
        }
        artifactRef.identifier( dbEntity.getIdentifier() );
        artifactRef.artifactQuality( dbEntity.getArtifactQuality() );
        artifactRef.md5( dbEntity.getMd5() );
        artifactRef.sha1( dbEntity.getSha1() );
        artifactRef.sha256( dbEntity.getSha256() );
        artifactRef.filename( dbEntity.getFilename() );
        artifactRef.deployPath( dbEntity.getDeployPath() );
        if ( dbEntity.getImportDate() != null ) {
            artifactRef.importDate( dbEntity.getImportDate().toInstant() );
        }
        artifactRef.originUrl( dbEntity.getOriginUrl() );
        artifactRef.size( dbEntity.getSize() );
        if ( dbEntity.getCreationTime() != null ) {
            artifactRef.creationTime( dbEntity.getCreationTime().toInstant() );
        }
        if ( dbEntity.getModificationTime() != null ) {
            artifactRef.modificationTime( dbEntity.getModificationTime().toInstant() );
        }
        artifactRef.qualityLevelReason( dbEntity.getQualityLevelReason() );

        return artifactRef.build();
    }

    @Override
    public org.jboss.pnc.model.Artifact toEntity(Artifact dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        org.jboss.pnc.model.Artifact.Builder artifact = org.jboss.pnc.model.Artifact.builder();

        artifact.buildRecord( buildMapper.toEntity( dtoEntity.getBuild() ) );
        if ( dtoEntity.getId() != null ) {
            artifact.id( Integer.parseInt( dtoEntity.getId() ) );
        }
        artifact.identifier( dtoEntity.getIdentifier() );
        artifact.md5( dtoEntity.getMd5() );
        artifact.sha1( dtoEntity.getSha1() );
        artifact.sha256( dtoEntity.getSha256() );
        artifact.size( dtoEntity.getSize() );
        artifact.artifactQuality( dtoEntity.getArtifactQuality() );
        artifact.targetRepository( targetRepositoryMapper.toEntity( dtoEntity.getTargetRepository() ) );
        artifact.filename( dtoEntity.getFilename() );
        artifact.deployPath( dtoEntity.getDeployPath() );
        artifact.originUrl( dtoEntity.getOriginUrl() );
        if ( dtoEntity.getImportDate() != null ) {
            artifact.importDate( Date.from( dtoEntity.getImportDate() ) );
        }
        artifact.creationUser( userMapper.toIDEntity( dtoEntity.getCreationUser() ) );
        artifact.modificationUser( userMapper.toIDEntity( dtoEntity.getModificationUser() ) );
        if ( dtoEntity.getCreationTime() != null ) {
            artifact.creationTime( Date.from( dtoEntity.getCreationTime() ) );
        }
        if ( dtoEntity.getModificationTime() != null ) {
            artifact.modificationTime( Date.from( dtoEntity.getModificationTime() ) );
        }
        artifact.qualityLevelReason( dtoEntity.getQualityLevelReason() );

        return artifact.build();
    }
}
