package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.BuildConfigurationRef.Builder;
import org.jboss.pnc.mapper.api.BuildConfigurationMapper;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-26T15:31:39+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.7 (Oracle Corporation)"
)
*/
@ApplicationScoped
public class BuildConfigurationMapperImpl implements BuildConfigurationMapper {

    @Inject
    private ProjectMapper projectMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private EnvironmentMapper environmentMapper;
    @Inject
    private SCMRepositoryMapper sCMRepositoryMapper;
    @Inject
    private MapSetMapper mapSetMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public org.jboss.pnc.model.BuildConfiguration toEntity(BuildConfiguration dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        org.jboss.pnc.model.BuildConfiguration buildConfiguration = new org.jboss.pnc.model.BuildConfiguration();

        if ( dtoEntity.getModificationTime() != null ) {
            buildConfiguration.setLastModificationTime( Date.from( dtoEntity.getModificationTime() ) );
        }
        buildConfiguration.setLastModificationUser( userMapper.toIDEntity( dtoEntity.getModificationUser() ) );
        buildConfiguration.setBuildEnvironment( environmentMapper.toIDEntity( dtoEntity.getEnvironment() ) );
        buildConfiguration.setRepositoryConfiguration( sCMRepositoryMapper.toIDEntity( dtoEntity.getScmRepository() ) );
        Map<String, String> map = dtoEntity.getParameters();
        if ( map != null ) {
            buildConfiguration.setGenericParameters( new HashMap<String, String>( map ) );
        }
        buildConfiguration.setBuildConfigurationSets( mapSetMapper.mapGC( dtoEntity.getGroupConfigs() ) );
        if ( dtoEntity.getBrewPullActive() != null ) {
            buildConfiguration.setBrewPullActive( dtoEntity.getBrewPullActive() );
        }
        else {
            buildConfiguration.setBrewPullActive( false );
        }
        buildConfiguration.setName( dtoEntity.getName() );
        buildConfiguration.setBuildScript( dtoEntity.getBuildScript() );
        buildConfiguration.setScmRevision( dtoEntity.getScmRevision() );
        buildConfiguration.setDescription( dtoEntity.getDescription() );
        buildConfiguration.setProject( projectMapper.toIDEntity( dtoEntity.getProject() ) );
        buildConfiguration.setProductVersion( productVersionMapper.toIDEntity( dtoEntity.getProductVersion() ) );
        buildConfiguration.setDependencies( mapSetMapper.mapBC( dtoEntity.getDependencies() ) );
        if ( dtoEntity.getCreationTime() != null ) {
            buildConfiguration.setCreationTime( Date.from( dtoEntity.getCreationTime() ) );
        }
        buildConfiguration.setBuildType( dtoEntity.getBuildType() );
        buildConfiguration.setCreationUser( userMapper.toIDEntity( dtoEntity.getCreationUser() ) );
        buildConfiguration.setDefaultAlignmentParams( dtoEntity.getDefaultAlignmentParams() );

        buildConfiguration.setId( java.lang.Integer.valueOf(dtoEntity.getId()) );

        return buildConfiguration;
    }

    @Override
    public BuildConfigurationRef toRef(org.jboss.pnc.model.BuildConfiguration dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder buildConfigurationRef = BuildConfigurationRef.refBuilder();

        if ( dbEntity.getLastModificationTime() != null ) {
            buildConfigurationRef.modificationTime( dbEntity.getLastModificationTime().toInstant() );
        }
        buildConfigurationRef.name( dbEntity.getName() );
        buildConfigurationRef.description( dbEntity.getDescription() );
        buildConfigurationRef.buildScript( dbEntity.getBuildScript() );
        buildConfigurationRef.scmRevision( dbEntity.getScmRevision() );
        if ( dbEntity.getCreationTime() != null ) {
            buildConfigurationRef.creationTime( dbEntity.getCreationTime().toInstant() );
        }
        buildConfigurationRef.buildType( dbEntity.getBuildType() );
        buildConfigurationRef.defaultAlignmentParams( dbEntity.getDefaultAlignmentParams() );
        buildConfigurationRef.brewPullActive( dbEntity.isBrewPullActive() );

        buildConfigurationRef.id( dbEntity.getId().toString() );

        return buildConfigurationRef.build();
    }

    @Override
    public BuildConfiguration toDTO(org.jboss.pnc.model.BuildConfiguration dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.BuildConfiguration.Builder buildConfiguration = BuildConfiguration.builder();

        buildConfiguration.scmRepository( sCMRepositoryMapper.toRef( dbEntity.getRepositoryConfiguration() ) );
        buildConfiguration.environment( environmentMapper.toRef( dbEntity.getBuildEnvironment() ) );
        if ( dbEntity.getLastModificationTime() != null ) {
            buildConfiguration.modificationTime( dbEntity.getLastModificationTime().toInstant() );
        }
        buildConfiguration.modificationUser( userMapper.toRef( dbEntity.getLastModificationUser() ) );
        Map<String, String> map = dbEntity.getGenericParameters();
        if ( map != null ) {
            buildConfiguration.parameters( new HashMap<String, String>( map ) );
        }
        buildConfiguration.groupConfigs( mapSetMapper.mapGC( dbEntity.getBuildConfigurationSets() ) );
        buildConfiguration.dependencies( mapSetMapper.mapBC( dbEntity.getDependencies() ) );
        buildConfiguration.project( projectMapper.toRef( dbEntity.getProject() ) );
        buildConfiguration.productVersion( productVersionMapper.toRef( dbEntity.getProductVersion() ) );
        buildConfiguration.name( dbEntity.getName() );
        buildConfiguration.description( dbEntity.getDescription() );
        buildConfiguration.buildScript( dbEntity.getBuildScript() );
        buildConfiguration.scmRevision( dbEntity.getScmRevision() );
        if ( dbEntity.getCreationTime() != null ) {
            buildConfiguration.creationTime( dbEntity.getCreationTime().toInstant() );
        }
        buildConfiguration.buildType( dbEntity.getBuildType() );
        buildConfiguration.creationUser( userMapper.toRef( dbEntity.getCreationUser() ) );
        buildConfiguration.defaultAlignmentParams( dbEntity.getDefaultAlignmentParams() );
        buildConfiguration.brewPullActive( dbEntity.isBrewPullActive() );

        buildConfiguration.id( dbEntity.getId().toString() );

        return buildConfiguration.build();
    }
}
