package org.jboss.pnc.mapper;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.GroupConfigurationRef.Builder;
import org.jboss.pnc.mapper.api.GroupConfigurationMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.BuildConfigurationSet;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-26T15:31:39+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.7 (Oracle Corporation)"
)
*/
@ApplicationScoped
public class GroupConfigurationMapperImpl implements GroupConfigurationMapper {

    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private MapSetMapper mapSetMapper;

    @Override
    public BuildConfigurationSet toEntity(GroupConfiguration dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        BuildConfigurationSet buildConfigurationSet = new BuildConfigurationSet();

        buildConfigurationSet.setBuildConfigurations( mapSetMapper.mapBC( dtoEntity.getBuildConfigs() ) );
        if ( dtoEntity.getId() != null ) {
            buildConfigurationSet.setId( Integer.parseInt( dtoEntity.getId() ) );
        }
        buildConfigurationSet.setName( dtoEntity.getName() );
        buildConfigurationSet.setProductVersion( productVersionMapper.toIDEntity( dtoEntity.getProductVersion() ) );

        buildConfigurationSet.setActive( true );

        return buildConfigurationSet;
    }

    @Override
    public GroupConfigurationRef toRef(BuildConfigurationSet dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder groupConfigurationRef = GroupConfigurationRef.refBuilder();

        if ( dbEntity.getId() != null ) {
            groupConfigurationRef.id( String.valueOf( dbEntity.getId() ) );
        }
        groupConfigurationRef.name( dbEntity.getName() );

        return groupConfigurationRef.build();
    }

    @Override
    public GroupConfiguration toDTO(BuildConfigurationSet dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.GroupConfiguration.Builder groupConfiguration = GroupConfiguration.builder();

        groupConfiguration.buildConfigs( mapSetMapper.mapBC( dbEntity.getBuildConfigurations() ) );
        groupConfiguration.productVersion( productVersionMapper.toRef( dbEntity.getProductVersion() ) );
        if ( dbEntity.getId() != null ) {
            groupConfiguration.id( String.valueOf( dbEntity.getId() ) );
        }
        groupConfiguration.name( dbEntity.getName() );

        return groupConfiguration.build();
    }
}
