package org.jboss.pnc.mapper;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.Product.Builder;
import org.jboss.pnc.dto.ProductRef;
import org.jboss.pnc.mapper.api.ProductMapper;
import org.jboss.pnc.model.Product;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-26T15:31:39+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.7 (Oracle Corporation)"
)
*/
@ApplicationScoped
public class ProductMapperImpl implements ProductMapper {

    @Inject
    private MapSetMapper mapSetMapper;

    @Override
    public Product toEntity(org.jboss.pnc.dto.Product dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        Product product = new Product();

        if ( dtoEntity.getId() != null ) {
            product.setId( Integer.parseInt( dtoEntity.getId() ) );
        }
        product.setName( dtoEntity.getName() );
        product.setDescription( dtoEntity.getDescription() );
        product.setAbbreviation( dtoEntity.getAbbreviation() );
        product.setProductVersions( mapSetMapper.mapPV( dtoEntity.getProductVersions() ) );
        product.setProductManagers( dtoEntity.getProductManagers() );
        product.setProductPagesCode( dtoEntity.getProductPagesCode() );

        return product;
    }

    @Override
    public org.jboss.pnc.dto.Product toDTO(Product dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder product = org.jboss.pnc.dto.Product.builder();

        product.productVersions( mapSetMapper.mapPV( dbEntity.getProductVersions() ) );
        if ( dbEntity.getId() != null ) {
            product.id( String.valueOf( dbEntity.getId() ) );
        }
        product.name( dbEntity.getName() );
        product.description( dbEntity.getDescription() );
        product.abbreviation( dbEntity.getAbbreviation() );
        product.productManagers( dbEntity.getProductManagers() );
        product.productPagesCode( dbEntity.getProductPagesCode() );

        return product.build();
    }

    @Override
    public ProductRef toRef(Product dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.ProductRef.Builder productRef = ProductRef.refBuilder();

        if ( dbEntity.getId() != null ) {
            productRef.id( String.valueOf( dbEntity.getId() ) );
        }
        productRef.name( dbEntity.getName() );
        productRef.description( dbEntity.getDescription() );
        productRef.abbreviation( dbEntity.getAbbreviation() );
        productRef.productManagers( dbEntity.getProductManagers() );
        productRef.productPagesCode( dbEntity.getProductPagesCode() );

        return productRef.build();
    }
}
