package org.jboss.pnc.mapper;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.ProductRelease;
import org.jboss.pnc.dto.ProductRelease.Builder;
import org.jboss.pnc.dto.ProductReleaseRef;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProductReleaseMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductVersion;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-26T15:31:39+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.7 (Oracle Corporation)"
)
*/
@ApplicationScoped
public class ProductReleaseMapperImpl implements ProductReleaseMapper {

    @Inject
    private ProductMilestoneMapper productMilestoneMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;

    @Override
    public org.jboss.pnc.model.ProductRelease toEntity(ProductRelease dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        org.jboss.pnc.model.ProductRelease productRelease = new org.jboss.pnc.model.ProductRelease();

        if ( dtoEntity.getId() != null ) {
            productRelease.setId( Integer.parseInt( dtoEntity.getId() ) );
        }
        productRelease.setVersion( dtoEntity.getVersion() );
        productRelease.setSupportLevel( dtoEntity.getSupportLevel() );
        if ( dtoEntity.getReleaseDate() != null ) {
            productRelease.setReleaseDate( Date.from( dtoEntity.getReleaseDate() ) );
        }
        productRelease.setProductMilestone( productMilestoneMapper.toIDEntity( dtoEntity.getProductMilestone() ) );
        productRelease.setCommonPlatformEnumeration( dtoEntity.getCommonPlatformEnumeration() );
        productRelease.setProductPagesCode( dtoEntity.getProductPagesCode() );

        return productRelease;
    }

    @Override
    public ProductRelease toDTO(org.jboss.pnc.model.ProductRelease dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder productRelease = ProductRelease.builder();

        productRelease.productVersion( productVersionMapper.toRef( dbEntityProductMilestoneProductVersion( dbEntity ) ) );
        productRelease.productMilestone( productMilestoneMapper.toRef( dbEntity.getProductMilestone() ) );
        if ( dbEntity.getId() != null ) {
            productRelease.id( String.valueOf( dbEntity.getId() ) );
        }
        productRelease.version( dbEntity.getVersion() );
        productRelease.supportLevel( dbEntity.getSupportLevel() );
        if ( dbEntity.getReleaseDate() != null ) {
            productRelease.releaseDate( dbEntity.getReleaseDate().toInstant() );
        }
        productRelease.commonPlatformEnumeration( dbEntity.getCommonPlatformEnumeration() );
        productRelease.productPagesCode( dbEntity.getProductPagesCode() );

        return productRelease.build();
    }

    @Override
    public ProductReleaseRef toRef(org.jboss.pnc.model.ProductRelease dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.ProductReleaseRef.Builder productReleaseRef = ProductReleaseRef.refBuilder();

        if ( dbEntity.getId() != null ) {
            productReleaseRef.id( String.valueOf( dbEntity.getId() ) );
        }
        productReleaseRef.version( dbEntity.getVersion() );
        productReleaseRef.supportLevel( dbEntity.getSupportLevel() );
        if ( dbEntity.getReleaseDate() != null ) {
            productReleaseRef.releaseDate( dbEntity.getReleaseDate().toInstant() );
        }
        productReleaseRef.commonPlatformEnumeration( dbEntity.getCommonPlatformEnumeration() );
        productReleaseRef.productPagesCode( dbEntity.getProductPagesCode() );

        return productReleaseRef.build();
    }

    private ProductVersion dbEntityProductMilestoneProductVersion(org.jboss.pnc.model.ProductRelease productRelease) {
        if ( productRelease == null ) {
            return null;
        }
        ProductMilestone productMilestone = productRelease.getProductMilestone();
        if ( productMilestone == null ) {
            return null;
        }
        ProductVersion productVersion = productMilestone.getProductVersion();
        if ( productVersion == null ) {
            return null;
        }
        return productVersion;
    }
}
