package org.jboss.pnc.mapper;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.Project.Builder;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.model.Project;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-26T15:31:39+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.7 (Oracle Corporation)"
)
*/
@ApplicationScoped
public class ProjectMapperImpl implements ProjectMapper {

    @Inject
    private MapSetMapper mapSetMapper;

    @Override
    public org.jboss.pnc.dto.Project toDTO(Project dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder project = org.jboss.pnc.dto.Project.builder();

        project.buildConfigs( mapSetMapper.mapBC( dbEntity.getBuildConfigurations() ) );
        if ( dbEntity.getId() != null ) {
            project.id( String.valueOf( dbEntity.getId() ) );
        }
        project.name( dbEntity.getName() );
        project.description( dbEntity.getDescription() );
        project.issueTrackerUrl( dbEntity.getIssueTrackerUrl() );
        project.projectUrl( dbEntity.getProjectUrl() );
        project.engineeringTeam( dbEntity.getEngineeringTeam() );
        project.technicalLeader( dbEntity.getTechnicalLeader() );

        return project.build();
    }

    @Override
    public ProjectRef toRef(Project dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.ProjectRef.Builder projectRef = ProjectRef.refBuilder();

        if ( dbEntity.getId() != null ) {
            projectRef.id( String.valueOf( dbEntity.getId() ) );
        }
        projectRef.name( dbEntity.getName() );
        projectRef.description( dbEntity.getDescription() );
        projectRef.issueTrackerUrl( dbEntity.getIssueTrackerUrl() );
        projectRef.projectUrl( dbEntity.getProjectUrl() );
        projectRef.engineeringTeam( dbEntity.getEngineeringTeam() );
        projectRef.technicalLeader( dbEntity.getTechnicalLeader() );

        return projectRef.build();
    }

    @Override
    public Project toEntity(org.jboss.pnc.dto.Project dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        Project project = new Project();

        project.setBuildConfigurations( mapSetMapper.mapBC( dtoEntity.getBuildConfigs() ) );
        if ( dtoEntity.getId() != null ) {
            project.setId( Integer.parseInt( dtoEntity.getId() ) );
        }
        project.setName( dtoEntity.getName() );
        project.setDescription( dtoEntity.getDescription() );
        project.setIssueTrackerUrl( dtoEntity.getIssueTrackerUrl() );
        project.setProjectUrl( dtoEntity.getProjectUrl() );
        project.setEngineeringTeam( dtoEntity.getEngineeringTeam() );
        project.setTechnicalLeader( dtoEntity.getTechnicalLeader() );

        return project;
    }
}
