/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.net.MalformedURLException;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.util.UrlUtils;
import org.jboss.pnc.dto.Artifact;
import org.jboss.pnc.dto.ArtifactRef;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.mapper.api.ArtifactMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.IdEntity;
import org.jboss.pnc.mapper.api.MapperCentralConfig;
import org.jboss.pnc.mapper.api.Reference;
import org.jboss.pnc.mapper.api.TargetRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.TargetRepository;
import org.mapstruct.BeanMapping;
import org.mapstruct.BeforeMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mapper(config=MapperCentralConfig.class, uses={TargetRepositoryMapper.class, BuildMapper.IDMapper.class, Configuration.class, BuildMapper.class, UserMapper.class})
public abstract class AbstractArtifactMapper
implements ArtifactMapper {
    private static final Logger logger = LoggerFactory.getLogger(AbstractArtifactMapper.class);
    @Inject
    private Configuration config;

    @Override
    @Mappings(value={@Mapping(target="deployUrl", ignore=true), @Mapping(target="publicUrl", ignore=true), @Mapping(target="build", source="buildRecord"), @Mapping(target="targetRepository", qualifiedBy={Reference.class}), @Mapping(target="creationUser", qualifiedBy={Reference.class}), @Mapping(target="modificationUser", qualifiedBy={Reference.class})})
    @BeanMapping(ignoreUnmappedSourceProperties={"distributedInProductMilestones", "identifierSha256", "built", "imported", "trusted", "descriptiveString", "dependantBuildRecords"})
    public abstract org.jboss.pnc.dto.Artifact toDTO(Artifact var1);

    @Override
    @Mappings(value={@Mapping(target="deployUrl", ignore=true), @Mapping(target="publicUrl", ignore=true)})
    @BeanMapping(ignoreUnmappedSourceProperties={"targetRepository", "buildRecords", "dependantBuildRecords", "importDate", "distributedInProductMilestones", "identifierSha256", "built", "imported", "trusted", "descriptiveString", "creationUser", "modificationUser"})
    public abstract ArtifactRef toRef(Artifact var1);

    @Override
    @Mappings(value={@Mapping(target="creationUser", qualifiedBy={IdEntity.class}), @Mapping(target="modificationUser", qualifiedBy={IdEntity.class}), @Mapping(target="buildRecord", source="build", qualifiedBy={IdEntity.class}), @Mapping(target="dependantBuildRecords", ignore=true), @Mapping(target="dependantBuildRecord", ignore=true), @Mapping(target="distributedInProductMilestones", ignore=true)})
    @BeanMapping(ignoreUnmappedSourceProperties={"deployUrl", "publicUrl"})
    public abstract Artifact toEntity(org.jboss.pnc.dto.Artifact var1);

    @BeforeMapping
    protected void fillDeployAndPublicUrl(Artifact artifactDB, @MappingTarget Artifact.Builder artifactDTO) {
        this.fillDeployAndPublicUrl(artifactDB, arg_0 -> ((Artifact.Builder)artifactDTO).deployUrl(arg_0), arg_0 -> ((Artifact.Builder)artifactDTO).publicUrl(arg_0));
    }

    @BeforeMapping
    void fillDeployAndPublicUrl(Artifact artifactDB, @MappingTarget ArtifactRef.Builder artifactREF) {
        this.fillDeployAndPublicUrl(artifactDB, arg_0 -> ((ArtifactRef.Builder)artifactREF).deployUrl(arg_0), arg_0 -> ((ArtifactRef.Builder)artifactREF).publicUrl(arg_0));
    }

    private void fillDeployAndPublicUrl(Artifact artifactDB, Consumer<String> deployUrlSetter, Consumer<String> publicUrlSetter) {
        GlobalModuleGroup globalConfig = null;
        try {
            globalConfig = this.config.getGlobalConfig();
        }
        catch (ConfigurationParseException e) {
            logger.error("Cannot read configuration", (Throwable)e);
        }
        if (globalConfig == null) {
            return;
        }
        TargetRepository targetRepository = artifactDB.getTargetRepository();
        if (targetRepository == null) {
            logger.error("Artifact DB object does not have target repository set: {}", (Object)artifactDB);
            return;
        }
        RepositoryType repositoryType = targetRepository.getRepositoryType();
        if (repositoryType.equals((Object)RepositoryType.MAVEN) || repositoryType.equals((Object)RepositoryType.NPM)) {
            if (artifactDB.getDeployPath() == null || artifactDB.getDeployPath().equals("")) {
                deployUrlSetter.accept("");
                publicUrlSetter.accept("");
            } else {
                try {
                    deployUrlSetter.accept(UrlUtils.buildUrl((String)globalConfig.getIndyUrl(), (String[])new String[]{targetRepository.getRepositoryPath(), artifactDB.getDeployPath()}));
                    publicUrlSetter.accept(UrlUtils.buildUrl((String)globalConfig.getExternalIndyUrl(), (String[])new String[]{targetRepository.getRepositoryPath(), artifactDB.getDeployPath()}));
                }
                catch (MalformedURLException e) {
                    logger.error("Cannot construct internal artifactDB URL.", (Throwable)e);
                    deployUrlSetter.accept(null);
                    publicUrlSetter.accept(null);
                }
            }
        } else {
            deployUrlSetter.accept(artifactDB.getOriginUrl());
            publicUrlSetter.accept(artifactDB.getOriginUrl());
        }
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public static class IDMapper {
        public static String toId(Artifact artifact) {
            return artifact.getId().toString();
        }

        public static Artifact toId(String artifactId) {
            return Artifact.Builder.newBuilder().id(Integer.valueOf(artifactId)).build();
        }
    }
}

