/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.ArtifactRevision;
import org.jboss.pnc.dto.ArtifactRevisionRef;
import org.jboss.pnc.mapper.api.ArtifactRevisionMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.ArtifactAudited;
import org.jboss.pnc.model.IdRev;

@ApplicationScoped
public class ArtifactRevisionMapperImpl
implements ArtifactRevisionMapper {
    @Inject
    private UserMapper userMapper;

    @Override
    public ArtifactRevision toDTO(ArtifactAudited dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ArtifactRevision.Builder artifactRevision = ArtifactRevision.builder();
        artifactRevision.rev(dbEntity.getRev());
        artifactRevision.qualityLevelReason(dbEntity.getQualityLevelReason());
        if (dbEntity.getModificationTime() != null) {
            artifactRevision.modificationTime(dbEntity.getModificationTime().toInstant());
        }
        artifactRevision.artifactQuality(dbEntity.getArtifactQuality());
        artifactRevision.modificationUser(this.userMapper.toRef(dbEntity.getModificationUser()));
        artifactRevision.id(dbEntity.getId().toString());
        return artifactRevision.build();
    }

    @Override
    public ArtifactAudited toEntity(ArtifactRevision dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        ArtifactAudited artifactAudited = new ArtifactAudited();
        if (dtoEntity.getId() != null) {
            artifactAudited.setId(Integer.valueOf(Integer.parseInt(dtoEntity.getId())));
        }
        artifactAudited.setRev(dtoEntity.getRev());
        artifactAudited.setArtifactQuality(dtoEntity.getArtifactQuality());
        artifactAudited.setModificationUser(this.userMapper.toIDEntity(dtoEntity.getModificationUser()));
        if (dtoEntity.getModificationTime() != null) {
            artifactAudited.setModificationTime(Date.from(dtoEntity.getModificationTime()));
        }
        artifactAudited.setQualityLevelReason(dtoEntity.getQualityLevelReason());
        artifactAudited.setIdRev(new IdRev(Integer.valueOf(dtoEntity.getId()), dtoEntity.getRev()));
        return artifactAudited;
    }

    @Override
    public ArtifactRevisionRef toRef(ArtifactAudited dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ArtifactRevisionRef.Builder artifactRevisionRef = ArtifactRevisionRef.refBuilder();
        artifactRevisionRef.rev(dbEntity.getRev());
        artifactRevisionRef.qualityLevelReason(dbEntity.getQualityLevelReason());
        if (dbEntity.getModificationTime() != null) {
            artifactRevisionRef.modificationTime(dbEntity.getModificationTime().toInstant());
        }
        artifactRevisionRef.artifactQuality(dbEntity.getArtifactQuality());
        artifactRevisionRef.id(dbEntity.getId().toString());
        return artifactRevisionRef.build();
    }
}

