/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildConfigurationRevisionRef;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.mapstruct.BeforeMapping;
import org.mapstruct.MappingTarget;

@ApplicationScoped
public class BuildBCRevisionFetcher {
    @Inject
    private BuildConfigurationRevisionMapper bcRevisionMapper;
    @Inject
    private ProjectMapper projectMapper;
    @Inject
    private EnvironmentMapper environmentMapper;
    @Inject
    private SCMRepositoryMapper scmRepositoryMapper;
    @Inject
    private BuildConfigurationAuditedRepository bcAuditedRepository;

    @BeforeMapping
    public void mockBrewAttributes(BuildRecord build, @MappingTarget Build.Builder dtoBuilder) {
        Integer id = build.getBuildConfigurationId();
        Integer revision = build.getBuildConfigurationRev();
        BuildConfigurationAudited bca = build.getBuildConfigurationAudited();
        if (bca == null) {
            bca = this.bcAuditedRepository.queryById(new IdRev(id, revision));
        }
        BuildConfigurationRevisionRef bcRevision = this.bcRevisionMapper.toRef(bca);
        ProjectRef project = this.projectMapper.toRef(bca.getProject());
        Environment environment = this.environmentMapper.toRef(bca.getBuildEnvironment());
        SCMRepository scmRepository = this.scmRepositoryMapper.toRef(bca.getRepositoryConfiguration());
        dtoBuilder.buildConfigRevision(bcRevision);
        dtoBuilder.project(project);
        dtoBuilder.environment(environment);
        dtoBuilder.scmRepository(scmRepository);
    }
}

