/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.mapper.MapSetMapper;
import org.jboss.pnc.mapper.api.BuildConfigurationMapper;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.BuildConfiguration;

@ApplicationScoped
public class BuildConfigurationMapperImpl
implements BuildConfigurationMapper {
    @Inject
    private ProjectMapper projectMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private EnvironmentMapper environmentMapper;
    @Inject
    private SCMRepositoryMapper sCMRepositoryMapper;
    @Inject
    private MapSetMapper mapSetMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public BuildConfiguration toEntity(org.jboss.pnc.dto.BuildConfiguration dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        BuildConfiguration buildConfiguration = new BuildConfiguration();
        if (dtoEntity.getModificationTime() != null) {
            buildConfiguration.setLastModificationTime(Date.from(dtoEntity.getModificationTime()));
        }
        buildConfiguration.setLastModificationUser(this.userMapper.toIDEntity(dtoEntity.getModificationUser()));
        buildConfiguration.setBuildEnvironment(this.environmentMapper.toIDEntity(dtoEntity.getEnvironment()));
        buildConfiguration.setRepositoryConfiguration(this.sCMRepositoryMapper.toIDEntity(dtoEntity.getScmRepository()));
        Map map = dtoEntity.getParameters();
        if (map != null) {
            buildConfiguration.setGenericParameters(new HashMap(map));
        }
        buildConfiguration.setBuildConfigurationSets(this.mapSetMapper.mapGC(dtoEntity.getGroupConfigs()));
        if (dtoEntity.getBrewPullActive() != null) {
            buildConfiguration.setBrewPullActive(dtoEntity.getBrewPullActive().booleanValue());
        } else {
            buildConfiguration.setBrewPullActive(false);
        }
        buildConfiguration.setName(dtoEntity.getName());
        buildConfiguration.setBuildScript(dtoEntity.getBuildScript());
        buildConfiguration.setScmRevision(dtoEntity.getScmRevision());
        buildConfiguration.setDescription(dtoEntity.getDescription());
        buildConfiguration.setProject(this.projectMapper.toIDEntity(dtoEntity.getProject()));
        buildConfiguration.setProductVersion(this.productVersionMapper.toIDEntity(dtoEntity.getProductVersion()));
        buildConfiguration.setDependencies(this.mapSetMapper.mapBC(dtoEntity.getDependencies()));
        if (dtoEntity.getCreationTime() != null) {
            buildConfiguration.setCreationTime(Date.from(dtoEntity.getCreationTime()));
        }
        buildConfiguration.setBuildType(dtoEntity.getBuildType());
        buildConfiguration.setCreationUser(this.userMapper.toIDEntity(dtoEntity.getCreationUser()));
        buildConfiguration.setDefaultAlignmentParams(dtoEntity.getDefaultAlignmentParams());
        buildConfiguration.setId(Integer.valueOf(dtoEntity.getId()));
        return buildConfiguration;
    }

    @Override
    public BuildConfigurationRef toRef(BuildConfiguration dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        BuildConfigurationRef.Builder buildConfigurationRef = BuildConfigurationRef.refBuilder();
        if (dbEntity.getLastModificationTime() != null) {
            buildConfigurationRef.modificationTime(dbEntity.getLastModificationTime().toInstant());
        }
        buildConfigurationRef.name(dbEntity.getName());
        buildConfigurationRef.description(dbEntity.getDescription());
        buildConfigurationRef.buildScript(dbEntity.getBuildScript());
        buildConfigurationRef.scmRevision(dbEntity.getScmRevision());
        if (dbEntity.getCreationTime() != null) {
            buildConfigurationRef.creationTime(dbEntity.getCreationTime().toInstant());
        }
        buildConfigurationRef.buildType(dbEntity.getBuildType());
        buildConfigurationRef.defaultAlignmentParams(dbEntity.getDefaultAlignmentParams());
        buildConfigurationRef.brewPullActive(Boolean.valueOf(dbEntity.isBrewPullActive()));
        buildConfigurationRef.id(dbEntity.getId().toString());
        return buildConfigurationRef.build();
    }

    @Override
    public org.jboss.pnc.dto.BuildConfiguration toDTO(BuildConfiguration dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        BuildConfiguration.Builder buildConfiguration = org.jboss.pnc.dto.BuildConfiguration.builder();
        buildConfiguration.scmRepository(this.sCMRepositoryMapper.toRef(dbEntity.getRepositoryConfiguration()));
        buildConfiguration.environment(this.environmentMapper.toRef(dbEntity.getBuildEnvironment()));
        if (dbEntity.getLastModificationTime() != null) {
            buildConfiguration.modificationTime(dbEntity.getLastModificationTime().toInstant());
        }
        buildConfiguration.modificationUser(this.userMapper.toRef(dbEntity.getLastModificationUser()));
        Map map = dbEntity.getGenericParameters();
        if (map != null) {
            buildConfiguration.parameters(new HashMap(map));
        }
        buildConfiguration.groupConfigs(this.mapSetMapper.mapGC(dbEntity.getBuildConfigurationSets()));
        buildConfiguration.dependencies(this.mapSetMapper.mapBC(dbEntity.getDependencies()));
        buildConfiguration.project(this.projectMapper.toRef(dbEntity.getProject()));
        buildConfiguration.productVersion(this.productVersionMapper.toRef(dbEntity.getProductVersion()));
        buildConfiguration.name(dbEntity.getName());
        buildConfiguration.description(dbEntity.getDescription());
        buildConfiguration.buildScript(dbEntity.getBuildScript());
        buildConfiguration.scmRevision(dbEntity.getScmRevision());
        if (dbEntity.getCreationTime() != null) {
            buildConfiguration.creationTime(dbEntity.getCreationTime().toInstant());
        }
        buildConfiguration.buildType(dbEntity.getBuildType());
        buildConfiguration.creationUser(this.userMapper.toRef(dbEntity.getCreationUser()));
        buildConfiguration.defaultAlignmentParams(dbEntity.getDefaultAlignmentParams());
        buildConfiguration.brewPullActive(Boolean.valueOf(dbEntity.isBrewPullActive()));
        buildConfiguration.id(dbEntity.getId().toString());
        return buildConfiguration.build();
    }
}

