/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildRef;
import org.jboss.pnc.mapper.BrewNameWorkaround;
import org.jboss.pnc.mapper.BuildBCRevisionFetcher;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.Project;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.spi.BuildOptions;
import org.jboss.pnc.spi.coordinator.BuildSetTask;
import org.jboss.pnc.spi.coordinator.BuildTask;

@ApplicationScoped
public class BuildMapperImpl
implements BuildMapper {
    @Inject
    private UserMapper userMapper;
    @Inject
    private SCMRepositoryMapper sCMRepositoryMapper;
    @Inject
    private ProjectMapper projectMapper;
    @Inject
    private BuildConfigurationRevisionMapper buildConfigurationRevisionMapper;
    @Inject
    private EnvironmentMapper environmentMapper;
    @Inject
    private GroupBuildMapper groupBuildMapper;
    @Inject
    private BuildBCRevisionFetcher buildBCRevisionFetcher;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;

    @Override
    public Build toDTO(BuildRecord dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        Build.Builder build = Build.builder();
        BrewNameWorkaround.mockBrewAttributes(dbEntity, build);
        this.buildBCRevisionFetcher.mockBrewAttributes(dbEntity, build);
        build.scmUrl(dbEntity.getScmRepoURL());
        build.groupBuild(this.groupBuildMapper.toRef(dbEntity.getBuildConfigSetRecord()));
        build.progress(BuildMapper.buildProgress(dbEntity.getStatus()));
        build.user(this.userMapper.toRef(dbEntity.getUser()));
        if (dbEntity.getSubmitTime() != null) {
            build.submitTime(dbEntity.getSubmitTime().toInstant());
        }
        if (dbEntity.getStartTime() != null) {
            build.startTime(dbEntity.getStartTime().toInstant());
        }
        if (dbEntity.getEndTime() != null) {
            build.endTime(dbEntity.getEndTime().toInstant());
        }
        build.status(dbEntity.getStatus());
        build.buildContentId(dbEntity.getBuildContentId());
        build.temporaryBuild(Boolean.valueOf(dbEntity.isTemporaryBuild()));
        build.scmRevision(dbEntity.getScmRevision());
        build.scmTag(dbEntity.getScmTag());
        build.productMilestone(this.productMilestoneMapper.toRef(dbEntity.getProductMilestone()));
        build.buildOutputChecksum(dbEntity.getbuildOutputChecksum());
        build.noRebuildCause(this.toRef(dbEntity.getNoRebuildCause()));
        build.id(this.getIdMapper().toDto(dbEntity.getId()));
        return build.build();
    }

    @Override
    public BuildRef toRef(BuildRecord dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        BuildRef.Builder buildRef = BuildRef.refBuilder();
        buildRef.scmUrl(dbEntity.getScmRepoURL());
        buildRef.progress(BuildMapper.buildProgress(dbEntity.getStatus()));
        if (dbEntity.getSubmitTime() != null) {
            buildRef.submitTime(dbEntity.getSubmitTime().toInstant());
        }
        if (dbEntity.getStartTime() != null) {
            buildRef.startTime(dbEntity.getStartTime().toInstant());
        }
        if (dbEntity.getEndTime() != null) {
            buildRef.endTime(dbEntity.getEndTime().toInstant());
        }
        buildRef.status(dbEntity.getStatus());
        buildRef.buildContentId(dbEntity.getBuildContentId());
        buildRef.temporaryBuild(Boolean.valueOf(dbEntity.isTemporaryBuild()));
        buildRef.scmRevision(dbEntity.getScmRevision());
        buildRef.scmTag(dbEntity.getScmTag());
        buildRef.buildOutputChecksum(dbEntity.getbuildOutputChecksum());
        buildRef.id(this.getIdMapper().toDto(dbEntity.getId()));
        return buildRef.build();
    }

    @Override
    public BuildRecord toEntity(Build dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        BuildRecord buildRecord = new BuildRecord();
        buildRecord.setBuildEnvironment(this.environmentMapper.toIDEntity(dtoEntity.getEnvironment()));
        buildRecord.setScmRepoURL(dtoEntity.getScmUrl());
        buildRecord.setBuildConfigurationAudited(this.buildConfigurationRevisionMapper.toIDEntity(dtoEntity.getBuildConfigRevision()));
        buildRecord.setBuildConfigSetRecord(this.groupBuildMapper.toIDEntity(dtoEntity.getGroupBuild()));
        if (dtoEntity.getSubmitTime() != null) {
            buildRecord.setSubmitTime(Date.from(dtoEntity.getSubmitTime()));
        }
        if (dtoEntity.getStartTime() != null) {
            buildRecord.setStartTime(Date.from(dtoEntity.getStartTime()));
        }
        if (dtoEntity.getEndTime() != null) {
            buildRecord.setEndTime(Date.from(dtoEntity.getEndTime()));
        }
        buildRecord.setUser(this.userMapper.toIDEntity(dtoEntity.getUser()));
        buildRecord.setScmRevision(dtoEntity.getScmRevision());
        buildRecord.setScmTag(dtoEntity.getScmTag());
        buildRecord.setStatus(dtoEntity.getStatus());
        buildRecord.setBuildContentId(dtoEntity.getBuildContentId());
        if (dtoEntity.getTemporaryBuild() != null) {
            buildRecord.setTemporaryBuild(dtoEntity.getTemporaryBuild().booleanValue());
        }
        buildRecord.setNoRebuildCause(this.toIDEntity(dtoEntity.getNoRebuildCause()));
        buildRecord.setId(this.getIdMapper().toEntity(dtoEntity.getId()));
        return buildRecord;
    }

    @Override
    public Build fromBuildTask(BuildTask buildTask) {
        if (buildTask == null) {
            return null;
        }
        Build.Builder build = Build.builder();
        build.scmRepository(this.sCMRepositoryMapper.toRef(this.buildTaskBuildConfigurationAuditedRepositoryConfiguration(buildTask)));
        build.temporaryBuild(this.buildTaskBuildOptionsTemporaryBuild(buildTask));
        build.project(this.projectMapper.toRef(this.buildTaskBuildConfigurationAuditedProject(buildTask)));
        build.environment(this.environmentMapper.toRef(this.buildTaskBuildConfigurationAuditedBuildEnvironment(buildTask)));
        build.groupBuild(this.groupBuildMapper.toRef(BuildMapper.unwrap(this.buildTaskBuildSetTaskBuildConfigSetRecord(buildTask))));
        build.buildContentId(buildTask.getContentId());
        build.progress(BuildMapper.buildProgress(BuildMapper.StatusMapper.toBuildStatus(buildTask.getStatus())));
        build.buildConfigRevision(this.buildConfigurationRevisionMapper.toRef(buildTask.getBuildConfigurationAudited()));
        build.user(this.userMapper.toDTO(buildTask.getUser()));
        if (buildTask.getSubmitTime() != null) {
            build.submitTime(buildTask.getSubmitTime().toInstant());
        }
        if (buildTask.getStartTime() != null) {
            build.startTime(buildTask.getStartTime().toInstant());
        }
        if (buildTask.getEndTime() != null) {
            build.endTime(buildTask.getEndTime().toInstant());
        }
        build.status(BuildMapper.StatusMapper.toBuildStatus(buildTask.getStatus()));
        build.productMilestone(this.productMilestoneMapper.toRef(buildTask.getProductMilestone()));
        build.noRebuildCause(this.toRef(buildTask.getNoRebuildCause()));
        build.id(this.getIdMapper().toDto(buildTask.getId()));
        return build.build();
    }

    private RepositoryConfiguration buildTaskBuildConfigurationAuditedRepositoryConfiguration(BuildTask buildTask) {
        if (buildTask == null) {
            return null;
        }
        BuildConfigurationAudited buildConfigurationAudited = buildTask.getBuildConfigurationAudited();
        if (buildConfigurationAudited == null) {
            return null;
        }
        RepositoryConfiguration repositoryConfiguration = buildConfigurationAudited.getRepositoryConfiguration();
        if (repositoryConfiguration == null) {
            return null;
        }
        return repositoryConfiguration;
    }

    private Boolean buildTaskBuildOptionsTemporaryBuild(BuildTask buildTask) {
        if (buildTask == null) {
            return null;
        }
        BuildOptions buildOptions = buildTask.getBuildOptions();
        if (buildOptions == null) {
            return null;
        }
        boolean temporaryBuild = buildOptions.isTemporaryBuild();
        return temporaryBuild;
    }

    private Project buildTaskBuildConfigurationAuditedProject(BuildTask buildTask) {
        if (buildTask == null) {
            return null;
        }
        BuildConfigurationAudited buildConfigurationAudited = buildTask.getBuildConfigurationAudited();
        if (buildConfigurationAudited == null) {
            return null;
        }
        Project project = buildConfigurationAudited.getProject();
        if (project == null) {
            return null;
        }
        return project;
    }

    private BuildEnvironment buildTaskBuildConfigurationAuditedBuildEnvironment(BuildTask buildTask) {
        if (buildTask == null) {
            return null;
        }
        BuildConfigurationAudited buildConfigurationAudited = buildTask.getBuildConfigurationAudited();
        if (buildConfigurationAudited == null) {
            return null;
        }
        BuildEnvironment buildEnvironment = buildConfigurationAudited.getBuildEnvironment();
        if (buildEnvironment == null) {
            return null;
        }
        return buildEnvironment;
    }

    private Optional<BuildConfigSetRecord> buildTaskBuildSetTaskBuildConfigSetRecord(BuildTask buildTask) {
        if (buildTask == null) {
            return null;
        }
        BuildSetTask buildSetTask = buildTask.getBuildSetTask();
        if (buildSetTask == null) {
            return null;
        }
        Optional buildConfigSetRecord = buildSetTask.getBuildConfigSetRecord();
        if (buildConfigSetRecord == null) {
            return null;
        }
        return buildConfigSetRecord;
    }
}

