/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.ProductMilestone;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProductReleaseMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.ProductMilestone;

@ApplicationScoped
public class ProductMilestoneMapperImpl
implements ProductMilestoneMapper {
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private ProductReleaseMapper productReleaseMapper;

    @Override
    public ProductMilestone toEntity(org.jboss.pnc.dto.ProductMilestone dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        ProductMilestone productMilestone = new ProductMilestone();
        if (dtoEntity.getId() != null) {
            productMilestone.setId(Integer.valueOf(Integer.parseInt(dtoEntity.getId())));
        }
        productMilestone.setVersion(dtoEntity.getVersion());
        productMilestone.setProductVersion(this.productVersionMapper.toIDEntity(dtoEntity.getProductVersion()));
        if (dtoEntity.getStartingDate() != null) {
            productMilestone.setStartingDate(Date.from(dtoEntity.getStartingDate()));
        }
        if (dtoEntity.getPlannedEndDate() != null) {
            productMilestone.setPlannedEndDate(Date.from(dtoEntity.getPlannedEndDate()));
        }
        if (dtoEntity.getEndDate() != null) {
            productMilestone.setEndDate(Date.from(dtoEntity.getEndDate()));
        }
        productMilestone.setProductRelease(this.productReleaseMapper.toIDEntity(dtoEntity.getProductRelease()));
        return productMilestone;
    }

    @Override
    public org.jboss.pnc.dto.ProductMilestone toDTO(ProductMilestone dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductMilestone.Builder productMilestone = org.jboss.pnc.dto.ProductMilestone.builder();
        productMilestone.productVersion(this.productVersionMapper.toRef(dbEntity.getProductVersion()));
        productMilestone.productRelease(this.productReleaseMapper.toRef(dbEntity.getProductRelease()));
        if (dbEntity.getId() != null) {
            productMilestone.id(String.valueOf(dbEntity.getId()));
        }
        productMilestone.version(dbEntity.getVersion());
        if (dbEntity.getEndDate() != null) {
            productMilestone.endDate(dbEntity.getEndDate().toInstant());
        }
        if (dbEntity.getStartingDate() != null) {
            productMilestone.startingDate(dbEntity.getStartingDate().toInstant());
        }
        if (dbEntity.getPlannedEndDate() != null) {
            productMilestone.plannedEndDate(dbEntity.getPlannedEndDate().toInstant());
        }
        return productMilestone.build();
    }

    @Override
    public ProductMilestoneRef toRef(ProductMilestone dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductMilestoneRef.Builder productMilestoneRef = ProductMilestoneRef.refBuilder();
        if (dbEntity.getId() != null) {
            productMilestoneRef.id(String.valueOf(dbEntity.getId()));
        }
        productMilestoneRef.version(dbEntity.getVersion());
        if (dbEntity.getEndDate() != null) {
            productMilestoneRef.endDate(dbEntity.getEndDate().toInstant());
        }
        if (dbEntity.getStartingDate() != null) {
            productMilestoneRef.startingDate(dbEntity.getStartingDate().toInstant());
        }
        if (dbEntity.getPlannedEndDate() != null) {
            productMilestoneRef.plannedEndDate(dbEntity.getPlannedEndDate().toInstant());
        }
        return productMilestoneRef.build();
    }
}

