/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.ProductRelease;
import org.jboss.pnc.dto.ProductReleaseRef;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProductReleaseMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductRelease;
import org.jboss.pnc.model.ProductVersion;

@ApplicationScoped
public class ProductReleaseMapperImpl
implements ProductReleaseMapper {
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;

    @Override
    public ProductRelease toEntity(org.jboss.pnc.dto.ProductRelease dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        ProductRelease productRelease = new ProductRelease();
        if (dtoEntity.getId() != null) {
            productRelease.setId(Integer.valueOf(Integer.parseInt(dtoEntity.getId())));
        }
        productRelease.setVersion(dtoEntity.getVersion());
        productRelease.setSupportLevel(dtoEntity.getSupportLevel());
        if (dtoEntity.getReleaseDate() != null) {
            productRelease.setReleaseDate(Date.from(dtoEntity.getReleaseDate()));
        }
        productRelease.setProductMilestone(this.productMilestoneMapper.toIDEntity(dtoEntity.getProductMilestone()));
        productRelease.setCommonPlatformEnumeration(dtoEntity.getCommonPlatformEnumeration());
        productRelease.setProductPagesCode(dtoEntity.getProductPagesCode());
        return productRelease;
    }

    @Override
    public org.jboss.pnc.dto.ProductRelease toDTO(ProductRelease dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductRelease.Builder productRelease = org.jboss.pnc.dto.ProductRelease.builder();
        productRelease.productVersion(this.productVersionMapper.toRef(this.dbEntityProductMilestoneProductVersion(dbEntity)));
        productRelease.productMilestone(this.productMilestoneMapper.toRef(dbEntity.getProductMilestone()));
        if (dbEntity.getId() != null) {
            productRelease.id(String.valueOf(dbEntity.getId()));
        }
        productRelease.version(dbEntity.getVersion());
        productRelease.supportLevel(dbEntity.getSupportLevel());
        if (dbEntity.getReleaseDate() != null) {
            productRelease.releaseDate(dbEntity.getReleaseDate().toInstant());
        }
        productRelease.commonPlatformEnumeration(dbEntity.getCommonPlatformEnumeration());
        productRelease.productPagesCode(dbEntity.getProductPagesCode());
        return productRelease.build();
    }

    @Override
    public ProductReleaseRef toRef(ProductRelease dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductReleaseRef.Builder productReleaseRef = ProductReleaseRef.refBuilder();
        if (dbEntity.getId() != null) {
            productReleaseRef.id(String.valueOf(dbEntity.getId()));
        }
        productReleaseRef.version(dbEntity.getVersion());
        productReleaseRef.supportLevel(dbEntity.getSupportLevel());
        if (dbEntity.getReleaseDate() != null) {
            productReleaseRef.releaseDate(dbEntity.getReleaseDate().toInstant());
        }
        productReleaseRef.commonPlatformEnumeration(dbEntity.getCommonPlatformEnumeration());
        productReleaseRef.productPagesCode(dbEntity.getProductPagesCode());
        return productReleaseRef.build();
    }

    private ProductVersion dbEntityProductMilestoneProductVersion(ProductRelease productRelease) {
        if (productRelease == null) {
            return null;
        }
        ProductMilestone productMilestone = productRelease.getProductMilestone();
        if (productMilestone == null) {
            return null;
        }
        ProductVersion productVersion = productMilestone.getProductVersion();
        if (productVersion == null) {
            return null;
        }
        return productVersion;
    }
}

