/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.ProductVersion;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.mapper.MapSetMapper;
import org.jboss.pnc.mapper.api.ProductMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.ProductVersion;

@ApplicationScoped
public class ProductVersionMapperImpl
implements ProductVersionMapper {
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;
    @Inject
    private ProductMapper productMapper;
    @Inject
    private MapSetMapper mapSetMapper;

    @Override
    public ProductVersion toEntity(org.jboss.pnc.dto.ProductVersion dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        ProductVersion productVersion = new ProductVersion();
        productVersion.setBuildConfigurations(this.mapSetMapper.mapBC(dtoEntity.getBuildConfigs()));
        productVersion.setBuildConfigurationSets(this.mapSetMapper.mapGC(dtoEntity.getGroupConfigs()));
        if (dtoEntity.getId() != null) {
            productVersion.setId(Integer.valueOf(Integer.parseInt(dtoEntity.getId())));
        }
        productVersion.setVersion(dtoEntity.getVersion());
        productVersion.setProduct(this.productMapper.toIDEntity(dtoEntity.getProduct()));
        productVersion.setProductMilestones(this.mapSetMapper.mapPM(dtoEntity.getProductMilestones()));
        productVersion.setCurrentProductMilestone(this.productMilestoneMapper.toIDEntity(dtoEntity.getCurrentProductMilestone()));
        Map map = dtoEntity.getAttributes();
        if (map != null) {
            productVersion.setAttributes(new HashMap(map));
        }
        return productVersion;
    }

    @Override
    public ProductVersionRef toRef(ProductVersion dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductVersionRef.Builder productVersionRef = ProductVersionRef.refBuilder();
        if (dbEntity.getId() != null) {
            productVersionRef.id(String.valueOf(dbEntity.getId()));
        }
        productVersionRef.version(dbEntity.getVersion());
        Map map = dbEntity.getAttributes();
        if (map != null) {
            productVersionRef.attributes(new HashMap(map));
        }
        return productVersionRef.build();
    }

    @Override
    public org.jboss.pnc.dto.ProductVersion toDTO(ProductVersion dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductVersion.Builder productVersion = org.jboss.pnc.dto.ProductVersion.builder();
        productVersion.buildConfigs(this.mapSetMapper.mapBC(dbEntity.getBuildConfigurations()));
        productVersion.groupConfigs(this.mapSetMapper.mapGC(dbEntity.getBuildConfigurationSets()));
        productVersion.product(this.productMapper.toRef(dbEntity.getProduct()));
        productVersion.currentProductMilestone(this.productMilestoneMapper.toRef(dbEntity.getCurrentProductMilestone()));
        productVersion.productMilestones(this.mapSetMapper.mapPM(dbEntity.getProductMilestones()));
        productVersion.productReleases(this.mapSetMapper.mapPR(dbEntity.getProductReleases()));
        if (dbEntity.getId() != null) {
            productVersion.id(String.valueOf(dbEntity.getId()));
        }
        productVersion.version(dbEntity.getVersion());
        Map map4 = dbEntity.getAttributes();
        if (map4 != null) {
            productVersion.attributes(new HashMap(map4));
        }
        return productVersion.build();
    }
}

