package org.jboss.pnc.mapper;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.Artifact;
import org.jboss.pnc.dto.Artifact.Builder;
import org.jboss.pnc.dto.ArtifactRef;
import org.jboss.pnc.mapper.abstracts.AbstractArtifactMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.TargetRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.BuildRecord;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-23T11:59:00+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.11 (Red Hat, Inc.)"
)
*/
@ApplicationScoped
public class AbstractArtifactMapperImpl extends AbstractArtifactMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private TargetRepositoryMapper targetRepositoryMapper;
    @Inject
    private BuildMapper buildMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public Artifact toDTO(org.jboss.pnc.model.Artifact dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder artifact = Artifact.builder();

        fillDeployAndPublicUrl( dbEntity, artifact );

        artifact.build( buildMapper.toDTO( dbEntity.getBuildRecord() ) );
        artifact.targetRepository( targetRepositoryMapper.toRef( dbEntity.getTargetRepository() ) );
        artifact.creationUser( userMapper.toRef( dbEntity.getCreationUser() ) );
        artifact.modificationUser( userMapper.toRef( dbEntity.getModificationUser() ) );
        if ( dbEntity.getId() != null ) {
            artifact.id( String.valueOf( dbEntity.getId() ) );
        }
        artifact.identifier( dbEntity.getIdentifier() );
        artifact.purl( dbEntity.getPurl() );
        artifact.artifactQuality( dbEntity.getArtifactQuality() );
        artifact.buildCategory( dbEntity.getBuildCategory() );
        artifact.md5( dbEntity.getMd5() );
        artifact.sha1( dbEntity.getSha1() );
        artifact.sha256( dbEntity.getSha256() );
        artifact.filename( dbEntity.getFilename() );
        artifact.deployPath( dbEntity.getDeployPath() );
        if ( dbEntity.getImportDate() != null ) {
            artifact.importDate( dbEntity.getImportDate().toInstant() );
        }
        artifact.originUrl( dbEntity.getOriginUrl() );
        artifact.size( dbEntity.getSize() );
        if ( dbEntity.getCreationTime() != null ) {
            artifact.creationTime( dbEntity.getCreationTime().toInstant() );
        }
        if ( dbEntity.getModificationTime() != null ) {
            artifact.modificationTime( dbEntity.getModificationTime().toInstant() );
        }
        artifact.qualityLevelReason( dbEntity.getQualityLevelReason() );

        return artifact.build();
    }

    @Override
    public ArtifactRef toRef(org.jboss.pnc.model.Artifact dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.ArtifactRef.Builder artifactRef = ArtifactRef.refBuilder();

        fillDeployAndPublicUrl( dbEntity, artifactRef );

        if ( dbEntity.getId() != null ) {
            artifactRef.id( String.valueOf( dbEntity.getId() ) );
        }
        artifactRef.identifier( dbEntity.getIdentifier() );
        artifactRef.purl( dbEntity.getPurl() );
        artifactRef.artifactQuality( dbEntity.getArtifactQuality() );
        artifactRef.buildCategory( dbEntity.getBuildCategory() );
        artifactRef.md5( dbEntity.getMd5() );
        artifactRef.sha1( dbEntity.getSha1() );
        artifactRef.sha256( dbEntity.getSha256() );
        artifactRef.filename( dbEntity.getFilename() );
        artifactRef.deployPath( dbEntity.getDeployPath() );
        if ( dbEntity.getImportDate() != null ) {
            artifactRef.importDate( dbEntity.getImportDate().toInstant() );
        }
        artifactRef.originUrl( dbEntity.getOriginUrl() );
        artifactRef.size( dbEntity.getSize() );
        if ( dbEntity.getCreationTime() != null ) {
            artifactRef.creationTime( dbEntity.getCreationTime().toInstant() );
        }
        if ( dbEntity.getModificationTime() != null ) {
            artifactRef.modificationTime( dbEntity.getModificationTime().toInstant() );
        }
        artifactRef.qualityLevelReason( dbEntity.getQualityLevelReason() );

        return artifactRef.build();
    }

    @Override
    public org.jboss.pnc.model.Artifact toEntity(Artifact dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        org.jboss.pnc.model.Artifact.Builder artifact = org.jboss.pnc.model.Artifact.builder();

        artifact.creationUser( refToReferenceMapper.toEntityReference( dtoEntity.getCreationUser() ) );
        artifact.modificationUser( refToReferenceMapper.toEntityReference( dtoEntity.getModificationUser() ) );
        artifact.buildRecord( buildMapper.toEntity( dtoEntity.getBuild() ) );
        artifact.targetRepository( refToReferenceMapper.toEntityReference( dtoEntity.getTargetRepository() ) );
        if ( dtoEntity.getId() != null ) {
            artifact.id( Integer.parseInt( dtoEntity.getId() ) );
        }
        artifact.identifier( dtoEntity.getIdentifier() );
        artifact.purl( dtoEntity.getPurl() );
        artifact.md5( dtoEntity.getMd5() );
        artifact.sha1( dtoEntity.getSha1() );
        artifact.sha256( dtoEntity.getSha256() );
        artifact.size( dtoEntity.getSize() );
        artifact.artifactQuality( dtoEntity.getArtifactQuality() );
        artifact.buildCategory( dtoEntity.getBuildCategory() );
        artifact.filename( dtoEntity.getFilename() );
        artifact.deployPath( dtoEntity.getDeployPath() );
        artifact.originUrl( dtoEntity.getOriginUrl() );
        if ( dtoEntity.getImportDate() != null ) {
            artifact.importDate( Date.from( dtoEntity.getImportDate() ) );
        }
        if ( dtoEntity.getCreationTime() != null ) {
            artifact.creationTime( Date.from( dtoEntity.getCreationTime() ) );
        }
        if ( dtoEntity.getModificationTime() != null ) {
            artifact.modificationTime( Date.from( dtoEntity.getModificationTime() ) );
        }
        artifact.qualityLevelReason( dtoEntity.getQualityLevelReason() );

        return artifact.build();
    }

    @Override
    public org.jboss.pnc.model.Artifact toEntityWithTransientTargetRepository(Artifact dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        org.jboss.pnc.model.Artifact.Builder artifact = org.jboss.pnc.model.Artifact.builder();

        artifact.targetRepository( targetRepositoryMapper.toEntity( dtoEntity.getTargetRepository() ) );
        artifact.creationUser( refToReferenceMapper.toEntityReference( dtoEntity.getCreationUser() ) );
        artifact.modificationUser( refToReferenceMapper.toEntityReference( dtoEntity.getModificationUser() ) );
        artifact.buildRecord( buildMapper.toEntity( dtoEntity.getBuild() ) );
        if ( dtoEntity.getId() != null ) {
            artifact.id( Integer.parseInt( dtoEntity.getId() ) );
        }
        artifact.identifier( dtoEntity.getIdentifier() );
        artifact.purl( dtoEntity.getPurl() );
        artifact.md5( dtoEntity.getMd5() );
        artifact.sha1( dtoEntity.getSha1() );
        artifact.sha256( dtoEntity.getSha256() );
        artifact.size( dtoEntity.getSize() );
        artifact.artifactQuality( dtoEntity.getArtifactQuality() );
        artifact.buildCategory( dtoEntity.getBuildCategory() );
        artifact.filename( dtoEntity.getFilename() );
        artifact.deployPath( dtoEntity.getDeployPath() );
        artifact.originUrl( dtoEntity.getOriginUrl() );
        if ( dtoEntity.getImportDate() != null ) {
            artifact.importDate( Date.from( dtoEntity.getImportDate() ) );
        }
        if ( dtoEntity.getCreationTime() != null ) {
            artifact.creationTime( Date.from( dtoEntity.getCreationTime() ) );
        }
        if ( dtoEntity.getModificationTime() != null ) {
            artifact.modificationTime( Date.from( dtoEntity.getModificationTime() ) );
        }
        artifact.qualityLevelReason( dtoEntity.getQualityLevelReason() );

        return artifact.build();
    }

    @Override
    public void updateEntity(Artifact dtoEntity, org.jboss.pnc.model.Artifact target) {
        if ( dtoEntity == null ) {
            return;
        }

        if ( dtoEntity.getBuild() != null ) {
            if ( target.getBuildRecord() == null ) {
                target.setBuildRecord( new BuildRecord() );
            }
            buildMapper.updateEntity( dtoEntity.getBuild(), target.getBuildRecord() );
        }
        else {
            target.setBuildRecord( null );
        }
        target.setTargetRepository( refToReferenceMapper.toEntityReference( dtoEntity.getTargetRepository() ) );
        target.setIdentifier( dtoEntity.getIdentifier() );
        target.setPurl( dtoEntity.getPurl() );
        target.setMd5( dtoEntity.getMd5() );
        target.setSha1( dtoEntity.getSha1() );
        target.setSha256( dtoEntity.getSha256() );
        target.setArtifactQuality( dtoEntity.getArtifactQuality() );
        target.setBuildCategory( dtoEntity.getBuildCategory() );
        target.setFilename( dtoEntity.getFilename() );
        target.setDeployPath( dtoEntity.getDeployPath() );
        target.setOriginUrl( dtoEntity.getOriginUrl() );
        if ( dtoEntity.getImportDate() != null ) {
            target.setImportDate( Date.from( dtoEntity.getImportDate() ) );
        }
        else {
            target.setImportDate( null );
        }
        target.setSize( dtoEntity.getSize() );
        target.setQualityLevelReason( dtoEntity.getQualityLevelReason() );
    }
}
