package org.jboss.pnc.mapper;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.ArtifactRevision;
import org.jboss.pnc.dto.ArtifactRevision.Builder;
import org.jboss.pnc.dto.ArtifactRevisionRef;
import org.jboss.pnc.mapper.api.ArtifactRevisionMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.ArtifactAudited;
import org.jboss.pnc.model.IdRev;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-23T11:59:00+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.11 (Red Hat, Inc.)"
)
*/
@ApplicationScoped
public class ArtifactRevisionMapperImpl implements ArtifactRevisionMapper {

    @Inject
    private UserMapper userMapper;
    @Inject
    private RefToReferenceMapper refToReferenceMapper;

    @Override
    public ArtifactRevision toDTO(ArtifactAudited dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder artifactRevision = ArtifactRevision.builder();

        artifactRevision.modificationUser( userMapper.toRef( dbEntity.getModificationUser() ) );
        artifactRevision.rev( dbEntity.getRev() );
        artifactRevision.qualityLevelReason( dbEntity.getQualityLevelReason() );
        if ( dbEntity.getModificationTime() != null ) {
            artifactRevision.modificationTime( dbEntity.getModificationTime().toInstant() );
        }
        artifactRevision.artifactQuality( dbEntity.getArtifactQuality() );
        artifactRevision.buildCategory( dbEntity.getBuildCategory() );

        artifactRevision.id( dbEntity.getId().toString() );

        return artifactRevision.build();
    }

    @Override
    public ArtifactAudited toEntity(ArtifactRevision dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        ArtifactAudited artifactAudited = new ArtifactAudited();

        artifactAudited.setModificationUser( refToReferenceMapper.toEntityReference( dtoEntity.getModificationUser() ) );
        if ( dtoEntity.getId() != null ) {
            artifactAudited.setId( Integer.parseInt( dtoEntity.getId() ) );
        }
        artifactAudited.setRev( dtoEntity.getRev() );
        artifactAudited.setArtifactQuality( dtoEntity.getArtifactQuality() );
        artifactAudited.setBuildCategory( dtoEntity.getBuildCategory() );
        if ( dtoEntity.getModificationTime() != null ) {
            artifactAudited.setModificationTime( Date.from( dtoEntity.getModificationTime() ) );
        }
        artifactAudited.setQualityLevelReason( dtoEntity.getQualityLevelReason() );

        artifactAudited.setIdRev( new IdRev( Integer.valueOf(dtoEntity.getId()), dtoEntity.getRev() ) );

        return artifactAudited;
    }

    @Override
    public ArtifactRevisionRef toRef(ArtifactAudited dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.ArtifactRevisionRef.Builder artifactRevisionRef = ArtifactRevisionRef.refBuilder();

        artifactRevisionRef.rev( dbEntity.getRev() );
        artifactRevisionRef.qualityLevelReason( dbEntity.getQualityLevelReason() );
        if ( dbEntity.getModificationTime() != null ) {
            artifactRevisionRef.modificationTime( dbEntity.getModificationTime().toInstant() );
        }
        artifactRevisionRef.artifactQuality( dbEntity.getArtifactQuality() );
        artifactRevisionRef.buildCategory( dbEntity.getBuildCategory() );

        artifactRevisionRef.id( dbEntity.getId().toString() );

        return artifactRevisionRef.build();
    }
}
