package org.jboss.pnc.mapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildPushResultRef;
import org.jboss.pnc.dto.ProductMilestoneCloseResult;
import org.jboss.pnc.dto.ProductMilestoneCloseResult.Builder;
import org.jboss.pnc.dto.ProductMilestoneCloseResultRef;
import org.jboss.pnc.mapper.api.BuildPushResultMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneCloseResultMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.BuildRecordPushResult;
import org.jboss.pnc.model.ProductMilestoneRelease;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-23T11:58:59+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.11 (Red Hat, Inc.)"
)
*/
@ApplicationScoped
public class ProductMilestoneCloseResultMapperImpl implements ProductMilestoneCloseResultMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;
    @Inject
    private BuildPushResultMapper buildPushResultMapper;

    @Override
    public ProductMilestoneRelease toEntity(ProductMilestoneCloseResult dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        ProductMilestoneRelease productMilestoneRelease = new ProductMilestoneRelease();

        productMilestoneRelease.setBuildRecordPushResults( buildPushResultRefListToBuildRecordPushResultSet( dtoEntity.getBuildPushResults() ) );
        if ( dtoEntity.getId() != null ) {
            productMilestoneRelease.setId( Long.parseLong( dtoEntity.getId() ) );
        }
        productMilestoneRelease.setMilestone( refToReferenceMapper.toEntityReference( dtoEntity.getMilestone() ) );
        productMilestoneRelease.setStatus( dtoEntity.getStatus() );
        if ( dtoEntity.getStartingDate() != null ) {
            productMilestoneRelease.setStartingDate( Date.from( dtoEntity.getStartingDate() ) );
        }
        if ( dtoEntity.getEndDate() != null ) {
            productMilestoneRelease.setEndDate( Date.from( dtoEntity.getEndDate() ) );
        }

        return productMilestoneRelease;
    }

    @Override
    public ProductMilestoneCloseResult toDTO(ProductMilestoneRelease dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder productMilestoneCloseResult = ProductMilestoneCloseResult.builder();

        productMilestoneCloseResult.milestone( productMilestoneMapper.toRef( dbEntity.getMilestone() ) );
        productMilestoneCloseResult.buildPushResults( buildRecordPushResultSetToBuildPushResultRefList( dbEntity.getBuildRecordPushResults() ) );
        if ( dbEntity.getId() != null ) {
            productMilestoneCloseResult.id( String.valueOf( dbEntity.getId() ) );
        }
        if ( dbEntity.getStartingDate() != null ) {
            productMilestoneCloseResult.startingDate( dbEntity.getStartingDate().toInstant() );
        }
        if ( dbEntity.getEndDate() != null ) {
            productMilestoneCloseResult.endDate( dbEntity.getEndDate().toInstant() );
        }
        productMilestoneCloseResult.status( dbEntity.getStatus() );

        return productMilestoneCloseResult.build();
    }

    @Override
    public ProductMilestoneCloseResultRef toRef(ProductMilestoneRelease dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.ProductMilestoneCloseResultRef.Builder productMilestoneCloseResultRef = ProductMilestoneCloseResultRef.refBuilder();

        if ( dbEntity.getId() != null ) {
            productMilestoneCloseResultRef.id( String.valueOf( dbEntity.getId() ) );
        }
        productMilestoneCloseResultRef.status( dbEntity.getStatus() );
        if ( dbEntity.getStartingDate() != null ) {
            productMilestoneCloseResultRef.startingDate( dbEntity.getStartingDate().toInstant() );
        }
        if ( dbEntity.getEndDate() != null ) {
            productMilestoneCloseResultRef.endDate( dbEntity.getEndDate().toInstant() );
        }

        return productMilestoneCloseResultRef.build();
    }

    protected Set<BuildRecordPushResult> buildPushResultRefListToBuildRecordPushResultSet(List<BuildPushResultRef> list) {
        if ( list == null ) {
            return null;
        }

        Set<BuildRecordPushResult> set = new HashSet<BuildRecordPushResult>( Math.max( (int) ( list.size() / .75f ) + 1, 16 ) );
        for ( BuildPushResultRef buildPushResultRef : list ) {
            set.add( refToReferenceMapper.toEntityReference( buildPushResultRef ) );
        }

        return set;
    }

    protected List<BuildPushResultRef> buildRecordPushResultSetToBuildPushResultRefList(Set<BuildRecordPushResult> set) {
        if ( set == null ) {
            return null;
        }

        List<BuildPushResultRef> list = new ArrayList<BuildPushResultRef>( set.size() );
        for ( BuildRecordPushResult buildRecordPushResult : set ) {
            list.add( buildPushResultMapper.toRef( buildRecordPushResult ) );
        }

        return list;
    }
}
