/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.ProductReleaseRef;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.api.BuildConfigurationMapper;
import org.jboss.pnc.mapper.api.EntityMapper;
import org.jboss.pnc.mapper.api.GroupConfigurationMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProductReleaseMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductRelease;
import org.jboss.pnc.model.ProductVersion;

@ApplicationScoped
public class MapSetMapper {
    @Inject
    private BuildConfigurationMapper buildConfigurationMapper;
    @Inject
    private GroupConfigurationMapper groupConfigurationMapper;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;
    @Inject
    private ProductReleaseMapper productReleaseMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private RefToReferenceMapper referenceMapper;

    public Set<BuildConfigurationSet> mapGC(Map<String, GroupConfigurationRef> value) {
        return this.map(value, this.groupConfigurationMapper, BuildConfigurationSet.class);
    }

    public Map<String, GroupConfigurationRef> mapGC(Collection<BuildConfigurationSet> value) {
        return this.map(value, this.groupConfigurationMapper);
    }

    public Set<BuildConfiguration> mapBC(Map<String, BuildConfigurationRef> value) {
        return this.map(value, this.buildConfigurationMapper, BuildConfiguration.class);
    }

    public Map<String, BuildConfigurationRef> mapBC(Collection<BuildConfiguration> value) {
        return this.map(value, this.buildConfigurationMapper);
    }

    public Set<ProductVersion> mapPV(Map<String, ProductVersionRef> value) {
        return this.map(value, this.productVersionMapper, ProductVersion.class);
    }

    public Map<String, ProductVersionRef> mapPV(Collection<ProductVersion> value) {
        return this.map(value, this.productVersionMapper);
    }

    public Set<ProductMilestone> mapPM(Map<String, ProductMilestoneRef> value) {
        return this.map(value, this.productMilestoneMapper, ProductMilestone.class);
    }

    public Map<String, ProductMilestoneRef> mapPM(Collection<ProductMilestone> value) {
        return this.map(value, this.productMilestoneMapper);
    }

    public Set<ProductRelease> mapPR(Map<String, ProductReleaseRef> value) {
        return this.map(value, this.productReleaseMapper, ProductRelease.class);
    }

    public Map<String, ProductReleaseRef> mapPR(Collection<ProductRelease> value) {
        return this.map(value, this.productReleaseMapper);
    }

    private <ID extends Serializable, DTO extends DTOEntity, DB extends GenericEntity<ID>> Set<DB> map(Map<String, DTO> value, EntityMapper<ID, DB, ?, DTO> mapper, Class<DB> targetClass) {
        if (value == null) {
            return null;
        }
        return value.values().stream().map(ref -> this.referenceMapper.map(ref, mapper.getIdMapper(), targetClass)).collect(Collectors.toSet());
    }

    private <DTO extends DTOEntity, DB extends GenericEntity<?>> Map<String, DTO> map(Collection<DB> value, EntityMapper<?, DB, ?, DTO> mapper) {
        if (value == null) {
            return null;
        }
        return value.stream().map(mapper::toRef).collect(Collectors.toMap(DTOEntity::getId, Function.identity()));
    }
}

