package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.Build.Builder;
import org.jboss.pnc.dto.BuildConfigurationRevisionRef;
import org.jboss.pnc.dto.BuildRef;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.Project;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.spi.BuildOptions;
import org.jboss.pnc.spi.coordinator.BuildSetTask;
import org.jboss.pnc.spi.coordinator.BuildTask;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2022-03-14T20:00:01+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.13 (Red Hat, Inc.)"
)
*/
@ApplicationScoped
public class BuildMapperImpl implements BuildMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private UserMapper userMapper;
    @Inject
    private SCMRepositoryMapper sCMRepositoryMapper;
    @Inject
    private ProjectMapper projectMapper;
    @Inject
    private BuildConfigurationRevisionMapper buildConfigurationRevisionMapper;
    @Inject
    private EnvironmentMapper environmentMapper;
    @Inject
    private GroupBuildMapper groupBuildMapper;
    @Inject
    private BuildBCRevisionFetcher buildBCRevisionFetcher;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;

    @Override
    public Build toDTO(BuildRecord dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder build = Build.builder();

        BrewNameWorkaround.mockBrewAttributes( dbEntity, build );
        buildBCRevisionFetcher.mapFromAuditedBuildConfig( dbEntity, build );

        build.productMilestone( productMilestoneMapper.toRef( dbEntity.getProductMilestone() ) );
        build.groupBuild( groupBuildMapper.toRef( dbEntity.getBuildConfigSetRecord() ) );
        build.user( userMapper.toRef( dbEntity.getUser() ) );
        build.noRebuildCause( toRef( dbEntity.getNoRebuildCause() ) );
        build.scmUrl( dbEntity.getScmRepoURL() );
        build.progress( BuildMapper.buildProgress( dbEntity.getStatus() ) );
        if ( dbEntity.getSubmitTime() != null ) {
            build.submitTime( dbEntity.getSubmitTime().toInstant() );
        }
        if ( dbEntity.getStartTime() != null ) {
            build.startTime( dbEntity.getStartTime().toInstant() );
        }
        if ( dbEntity.getEndTime() != null ) {
            build.endTime( dbEntity.getEndTime().toInstant() );
        }
        build.status( dbEntity.getStatus() );
        build.buildContentId( dbEntity.getBuildContentId() );
        build.temporaryBuild( dbEntity.isTemporaryBuild() );
        build.alignmentPreference( dbEntity.getAlignmentPreference() );
        build.scmRevision( dbEntity.getScmRevision() );
        build.scmTag( dbEntity.getScmTag() );
        build.buildOutputChecksum( dbEntity.getbuildOutputChecksum() );
        if ( dbEntity.getLastUpdateTime() != null ) {
            build.lastUpdateTime( dbEntity.getLastUpdateTime().toInstant() );
        }

        build.id( getIdMapper().toDto(dbEntity.getId()) );

        return build.build();
    }

    @Override
    public BuildRef toRef(BuildRecord dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.BuildRef.Builder buildRef = BuildRef.refBuilder();

        buildRef.scmUrl( dbEntity.getScmRepoURL() );
        buildRef.progress( BuildMapper.buildProgress( dbEntity.getStatus() ) );
        if ( dbEntity.getSubmitTime() != null ) {
            buildRef.submitTime( dbEntity.getSubmitTime().toInstant() );
        }
        if ( dbEntity.getStartTime() != null ) {
            buildRef.startTime( dbEntity.getStartTime().toInstant() );
        }
        if ( dbEntity.getEndTime() != null ) {
            buildRef.endTime( dbEntity.getEndTime().toInstant() );
        }
        buildRef.status( dbEntity.getStatus() );
        buildRef.buildContentId( dbEntity.getBuildContentId() );
        buildRef.temporaryBuild( dbEntity.isTemporaryBuild() );
        buildRef.alignmentPreference( dbEntity.getAlignmentPreference() );
        buildRef.scmRevision( dbEntity.getScmRevision() );
        buildRef.scmTag( dbEntity.getScmTag() );
        buildRef.buildOutputChecksum( dbEntity.getbuildOutputChecksum() );
        if ( dbEntity.getLastUpdateTime() != null ) {
            buildRef.lastUpdateTime( dbEntity.getLastUpdateTime().toInstant() );
        }

        buildRef.id( getIdMapper().toDto(dbEntity.getId()) );

        return buildRef.build();
    }

    @Override
    public BuildRecord toEntity(Build dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        BuildRecord buildRecord = new BuildRecord();

        buildRecord.setBuildEnvironment( refToReferenceMapper.toEntityReference( dtoEntity.getEnvironment() ) );
        buildRecord.setBuildConfigSetRecord( refToReferenceMapper.toEntityReference( dtoEntity.getGroupBuild() ) );
        buildRecord.setScmRepoURL( dtoEntity.getScmUrl() );
        buildRecord.setUser( refToReferenceMapper.toEntityReference( dtoEntity.getUser() ) );
        String id = dtoEntityBuildConfigRevisionId( dtoEntity );
        if ( id != null ) {
            buildRecord.setBuildConfigurationId( Integer.parseInt( id ) );
        }
        buildRecord.setBuildConfigurationRev( dtoEntityBuildConfigRevisionRev( dtoEntity ) );
        buildRecord.setNoRebuildCause( refToReferenceMapper.toEntityReference( dtoEntity.getNoRebuildCause() ) );
        if ( dtoEntity.getSubmitTime() != null ) {
            buildRecord.setSubmitTime( Date.from( dtoEntity.getSubmitTime() ) );
        }
        if ( dtoEntity.getStartTime() != null ) {
            buildRecord.setStartTime( Date.from( dtoEntity.getStartTime() ) );
        }
        if ( dtoEntity.getEndTime() != null ) {
            buildRecord.setEndTime( Date.from( dtoEntity.getEndTime() ) );
        }
        buildRecord.setScmRevision( dtoEntity.getScmRevision() );
        buildRecord.setScmTag( dtoEntity.getScmTag() );
        buildRecord.setStatus( dtoEntity.getStatus() );
        buildRecord.setBuildContentId( dtoEntity.getBuildContentId() );
        if ( dtoEntity.getTemporaryBuild() != null ) {
            buildRecord.setTemporaryBuild( dtoEntity.getTemporaryBuild() );
        }
        if ( dtoEntity.getLastUpdateTime() != null ) {
            buildRecord.setLastUpdateTime( Date.from( dtoEntity.getLastUpdateTime() ) );
        }

        buildRecord.setId( getIdMapper().toEntity(dtoEntity.getId()) );

        return buildRecord;
    }

    @Override
    public void updateEntity(Build dtoEntity, BuildRecord target) {
        if ( dtoEntity == null ) {
            return;
        }

        target.setStatus( dtoEntity.getStatus() );
    }

    @Override
    public Build fromBuildTask(BuildTask buildTask) {
        if ( buildTask == null ) {
            return null;
        }

        Builder build = Build.builder();

        build.project( projectMapper.toRef( buildTaskBuildConfigurationAuditedProject( buildTask ) ) );
        build.scmRepository( sCMRepositoryMapper.toRef( buildTaskBuildConfigurationAuditedRepositoryConfiguration( buildTask ) ) );
        build.environment( environmentMapper.toRef( buildTaskBuildConfigurationAuditedBuildEnvironment( buildTask ) ) );
        build.buildConfigRevision( buildConfigurationRevisionMapper.toRef( buildTask.getBuildConfigurationAudited() ) );
        build.groupBuild( groupBuildMapper.toDTO( BuildMapper.unwrap( buildTaskBuildSetTaskBuildConfigSetRecord( buildTask ) ) ) );
        build.productMilestone( productMilestoneMapper.toRef( buildTask.getProductMilestone() ) );
        build.noRebuildCause( toRef( buildTask.getNoRebuildCause() ) );
        build.buildContentId( buildTask.getContentId() );
        build.temporaryBuild( buildTaskBuildOptionsTemporaryBuild( buildTask ) );
        build.alignmentPreference( buildTaskBuildOptionsAlignmentPreference( buildTask ) );
        build.progress( BuildMapper.buildProgress( StatusMapper.toBuildStatus( buildTask.getStatus() ) ) );
        build.user( userMapper.toDTO( buildTask.getUser() ) );
        if ( buildTask.getSubmitTime() != null ) {
            build.submitTime( buildTask.getSubmitTime().toInstant() );
        }
        if ( buildTask.getStartTime() != null ) {
            build.startTime( buildTask.getStartTime().toInstant() );
        }
        if ( buildTask.getEndTime() != null ) {
            build.endTime( buildTask.getEndTime().toInstant() );
        }
        build.status( StatusMapper.toBuildStatus( buildTask.getStatus() ) );

        build.id( buildTask.getId() );

        return build.build();
    }

    private String dtoEntityBuildConfigRevisionId(Build build) {
        if ( build == null ) {
            return null;
        }
        BuildConfigurationRevisionRef buildConfigRevision = build.getBuildConfigRevision();
        if ( buildConfigRevision == null ) {
            return null;
        }
        String id = buildConfigRevision.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }

    private Integer dtoEntityBuildConfigRevisionRev(Build build) {
        if ( build == null ) {
            return null;
        }
        BuildConfigurationRevisionRef buildConfigRevision = build.getBuildConfigRevision();
        if ( buildConfigRevision == null ) {
            return null;
        }
        Integer rev = buildConfigRevision.getRev();
        if ( rev == null ) {
            return null;
        }
        return rev;
    }

    private Project buildTaskBuildConfigurationAuditedProject(BuildTask buildTask) {
        if ( buildTask == null ) {
            return null;
        }
        BuildConfigurationAudited buildConfigurationAudited = buildTask.getBuildConfigurationAudited();
        if ( buildConfigurationAudited == null ) {
            return null;
        }
        Project project = buildConfigurationAudited.getProject();
        if ( project == null ) {
            return null;
        }
        return project;
    }

    private RepositoryConfiguration buildTaskBuildConfigurationAuditedRepositoryConfiguration(BuildTask buildTask) {
        if ( buildTask == null ) {
            return null;
        }
        BuildConfigurationAudited buildConfigurationAudited = buildTask.getBuildConfigurationAudited();
        if ( buildConfigurationAudited == null ) {
            return null;
        }
        RepositoryConfiguration repositoryConfiguration = buildConfigurationAudited.getRepositoryConfiguration();
        if ( repositoryConfiguration == null ) {
            return null;
        }
        return repositoryConfiguration;
    }

    private BuildEnvironment buildTaskBuildConfigurationAuditedBuildEnvironment(BuildTask buildTask) {
        if ( buildTask == null ) {
            return null;
        }
        BuildConfigurationAudited buildConfigurationAudited = buildTask.getBuildConfigurationAudited();
        if ( buildConfigurationAudited == null ) {
            return null;
        }
        BuildEnvironment buildEnvironment = buildConfigurationAudited.getBuildEnvironment();
        if ( buildEnvironment == null ) {
            return null;
        }
        return buildEnvironment;
    }

    private Optional<BuildConfigSetRecord> buildTaskBuildSetTaskBuildConfigSetRecord(BuildTask buildTask) {
        if ( buildTask == null ) {
            return null;
        }
        BuildSetTask buildSetTask = buildTask.getBuildSetTask();
        if ( buildSetTask == null ) {
            return null;
        }
        Optional<BuildConfigSetRecord> buildConfigSetRecord = buildSetTask.getBuildConfigSetRecord();
        if ( buildConfigSetRecord == null ) {
            return null;
        }
        return buildConfigSetRecord;
    }

    private Boolean buildTaskBuildOptionsTemporaryBuild(BuildTask buildTask) {
        if ( buildTask == null ) {
            return null;
        }
        BuildOptions buildOptions = buildTask.getBuildOptions();
        if ( buildOptions == null ) {
            return null;
        }
        boolean temporaryBuild = buildOptions.isTemporaryBuild();
        return temporaryBuild;
    }

    private AlignmentPreference buildTaskBuildOptionsAlignmentPreference(BuildTask buildTask) {
        if ( buildTask == null ) {
            return null;
        }
        BuildOptions buildOptions = buildTask.getBuildOptions();
        if ( buildOptions == null ) {
            return null;
        }
        AlignmentPreference alignmentPreference = buildOptions.getAlignmentPreference();
        if ( alignmentPreference == null ) {
            return null;
        }
        return alignmentPreference;
    }
}
