package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.DeliverableAnalyzerOperation.DeliverableAnalyzerOperationBuilder;
import org.jboss.pnc.dto.OperationRef;
import org.jboss.pnc.dto.OperationRef.OperationRefBuilder;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerOperationMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.DeliverableAnalyzerOperation;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2022-03-14T20:00:02+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.13 (Red Hat, Inc.)"
)
*/
@ApplicationScoped
public class DeliverableAnalyzerOperationMapperImpl implements DeliverableAnalyzerOperationMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private UserMapper userMapper;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;

    @Override
    public org.jboss.pnc.dto.DeliverableAnalyzerOperation toDTO(DeliverableAnalyzerOperation dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        DeliverableAnalyzerOperationBuilder<?, ?> deliverableAnalyzerOperation = org.jboss.pnc.dto.DeliverableAnalyzerOperation.delAnalyzerBuilder();

        deliverableAnalyzerOperation.productMilestone( productMilestoneMapper.toRef( dbEntity.getProductMilestone() ) );
        deliverableAnalyzerOperation.user( userMapper.toRef( dbEntity.getUser() ) );
        Map<String, String> map = dbEntity.getOperationParameters();
        if ( map != null ) {
            deliverableAnalyzerOperation.parameters( new HashMap<String, String>( map ) );
        }
        if ( dbEntity.getSubmitTime() != null ) {
            deliverableAnalyzerOperation.submitTime( dbEntity.getSubmitTime().toInstant() );
        }
        if ( dbEntity.getStartTime() != null ) {
            deliverableAnalyzerOperation.startTime( dbEntity.getStartTime().toInstant() );
        }
        if ( dbEntity.getEndTime() != null ) {
            deliverableAnalyzerOperation.endTime( dbEntity.getEndTime().toInstant() );
        }
        deliverableAnalyzerOperation.progressStatus( dbEntity.getProgressStatus() );
        deliverableAnalyzerOperation.result( dbEntity.getResult() );

        deliverableAnalyzerOperation.id( getIdMapper().toDto(dbEntity.getId()) );

        return deliverableAnalyzerOperation.build();
    }

    @Override
    public OperationRef toRef(DeliverableAnalyzerOperation dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        OperationRefBuilder<?, ?> operationRef = OperationRef.refBuilder();

        if ( dbEntity.getSubmitTime() != null ) {
            operationRef.submitTime( dbEntity.getSubmitTime().toInstant() );
        }
        if ( dbEntity.getStartTime() != null ) {
            operationRef.startTime( dbEntity.getStartTime().toInstant() );
        }
        if ( dbEntity.getEndTime() != null ) {
            operationRef.endTime( dbEntity.getEndTime().toInstant() );
        }
        operationRef.progressStatus( dbEntity.getProgressStatus() );
        operationRef.result( dbEntity.getResult() );

        operationRef.id( getIdMapper().toDto(dbEntity.getId()) );

        return operationRef.build();
    }

    @Override
    public DeliverableAnalyzerOperation toEntity(org.jboss.pnc.dto.DeliverableAnalyzerOperation dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        DeliverableAnalyzerOperation deliverableAnalyzerOperation = new DeliverableAnalyzerOperation();

        deliverableAnalyzerOperation.setUser( refToReferenceMapper.toEntityReference( dtoEntity.getUser() ) );
        Map<String, String> map = dtoEntity.getParameters();
        if ( map != null ) {
            deliverableAnalyzerOperation.setOperationParameters( new HashMap<String, String>( map ) );
        }
        if ( dtoEntity.getSubmitTime() != null ) {
            deliverableAnalyzerOperation.setSubmitTime( Date.from( dtoEntity.getSubmitTime() ) );
        }
        if ( dtoEntity.getStartTime() != null ) {
            deliverableAnalyzerOperation.setStartTime( Date.from( dtoEntity.getStartTime() ) );
        }
        if ( dtoEntity.getEndTime() != null ) {
            deliverableAnalyzerOperation.setEndTime( Date.from( dtoEntity.getEndTime() ) );
        }
        deliverableAnalyzerOperation.setProgressStatus( dtoEntity.getProgressStatus() );
        deliverableAnalyzerOperation.setResult( dtoEntity.getResult() );

        deliverableAnalyzerOperation.setId( getIdMapper().toEntity(dtoEntity.getId()) );

        return deliverableAnalyzerOperation;
    }

    @Override
    public void updateEntity(org.jboss.pnc.dto.DeliverableAnalyzerOperation dtoEntity, DeliverableAnalyzerOperation target) {
        if ( dtoEntity == null ) {
            return;
        }

        if ( dtoEntity.getSubmitTime() != null ) {
            target.setSubmitTime( Date.from( dtoEntity.getSubmitTime() ) );
        }
        else {
            target.setSubmitTime( null );
        }
        if ( dtoEntity.getEndTime() != null ) {
            target.setEndTime( Date.from( dtoEntity.getEndTime() ) );
        }
        else {
            target.setEndTime( null );
        }
        target.setProgressStatus( dtoEntity.getProgressStatus() );
        target.setResult( dtoEntity.getResult() );
    }
}
