package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.Operation.OperationBuilder;
import org.jboss.pnc.dto.OperationRef;
import org.jboss.pnc.dto.OperationRef.OperationRefBuilder;
import org.jboss.pnc.mapper.api.OperationMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.Operation;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2022-03-14T20:00:01+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.13 (Red Hat, Inc.)"
)
*/
@ApplicationScoped
public class OperationMapperImpl implements OperationMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public org.jboss.pnc.dto.Operation toDTO(Operation dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        OperationBuilder<?, ?> operation = org.jboss.pnc.dto.Operation.operationBuilder();

        operation.user( userMapper.toRef( dbEntity.getUser() ) );
        Map<String, String> map = dbEntity.getOperationParameters();
        if ( map != null ) {
            operation.parameters( new HashMap<String, String>( map ) );
        }
        if ( dbEntity.getSubmitTime() != null ) {
            operation.submitTime( dbEntity.getSubmitTime().toInstant() );
        }
        if ( dbEntity.getStartTime() != null ) {
            operation.startTime( dbEntity.getStartTime().toInstant() );
        }
        if ( dbEntity.getEndTime() != null ) {
            operation.endTime( dbEntity.getEndTime().toInstant() );
        }
        operation.progressStatus( dbEntity.getProgressStatus() );
        operation.result( dbEntity.getResult() );

        operation.id( getIdMapper().toDto(dbEntity.getId()) );

        return operation.build();
    }

    @Override
    public OperationRef toRef(Operation dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        OperationRefBuilder<?, ?> operationRef = OperationRef.refBuilder();

        if ( dbEntity.getSubmitTime() != null ) {
            operationRef.submitTime( dbEntity.getSubmitTime().toInstant() );
        }
        if ( dbEntity.getStartTime() != null ) {
            operationRef.startTime( dbEntity.getStartTime().toInstant() );
        }
        if ( dbEntity.getEndTime() != null ) {
            operationRef.endTime( dbEntity.getEndTime().toInstant() );
        }
        operationRef.progressStatus( dbEntity.getProgressStatus() );
        operationRef.result( dbEntity.getResult() );

        operationRef.id( getIdMapper().toDto(dbEntity.getId()) );

        return operationRef.build();
    }

    @Override
    public Operation toEntity(org.jboss.pnc.dto.Operation dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        Operation operation = new Operation();

        operation.setUser( refToReferenceMapper.toEntityReference( dtoEntity.getUser() ) );
        Map<String, String> map = dtoEntity.getParameters();
        if ( map != null ) {
            operation.setOperationParameters( new HashMap<String, String>( map ) );
        }
        if ( dtoEntity.getSubmitTime() != null ) {
            operation.setSubmitTime( Date.from( dtoEntity.getSubmitTime() ) );
        }
        if ( dtoEntity.getStartTime() != null ) {
            operation.setStartTime( Date.from( dtoEntity.getStartTime() ) );
        }
        if ( dtoEntity.getEndTime() != null ) {
            operation.setEndTime( Date.from( dtoEntity.getEndTime() ) );
        }
        operation.setProgressStatus( dtoEntity.getProgressStatus() );
        operation.setResult( dtoEntity.getResult() );

        operation.setId( getIdMapper().toEntity(dtoEntity.getId()) );

        return operation;
    }

    @Override
    public void updateEntity(org.jboss.pnc.dto.Operation dtoEntity, Operation target) {
        if ( dtoEntity == null ) {
            return;
        }

        if ( target.getOperationParameters() != null ) {
            Map<String, String> map = dtoEntity.getParameters();
            if ( map != null ) {
                target.getOperationParameters().clear();
                target.getOperationParameters().putAll( map );
            }
            else {
                target.setOperationParameters( null );
            }
        }
        else {
            Map<String, String> map = dtoEntity.getParameters();
            if ( map != null ) {
                target.setOperationParameters( new HashMap<String, String>( map ) );
            }
        }
        if ( dtoEntity.getSubmitTime() != null ) {
            target.setSubmitTime( Date.from( dtoEntity.getSubmitTime() ) );
        }
        else {
            target.setSubmitTime( null );
        }
        if ( dtoEntity.getStartTime() != null ) {
            target.setStartTime( Date.from( dtoEntity.getStartTime() ) );
        }
        else {
            target.setStartTime( null );
        }
        if ( dtoEntity.getEndTime() != null ) {
            target.setEndTime( Date.from( dtoEntity.getEndTime() ) );
        }
        else {
            target.setEndTime( null );
        }
        target.setUser( userMapper.toEntity( dtoEntity.getUser() ) );
        target.setProgressStatus( dtoEntity.getProgressStatus() );
        target.setResult( dtoEntity.getResult() );
    }
}
