package org.jboss.pnc.mapper;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.ProductVersionRef.Builder;
import org.jboss.pnc.mapper.abstracts.AbstractProductVersionMapper;
import org.jboss.pnc.mapper.api.ProductMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.ProductVersion;

/*
@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2022-03-14T20:00:02+0000",
    comments = "version: 1.4.2.Final, compiler: javac, environment: Java 11.0.13 (Red Hat, Inc.)"
)
*/
@ApplicationScoped
public class ProductVersionMapperImpl extends AbstractProductVersionMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;
    @Inject
    private ProductMapper productMapper;
    @Inject
    private MapSetMapper mapSetMapper;

    @Override
    public ProductVersion toEntity(org.jboss.pnc.dto.ProductVersion dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        ProductVersion productVersion = new ProductVersion();

        productVersion.setBuildConfigurationSets( mapSetMapper.mapGC( dtoEntity.getGroupConfigs() ) );
        productVersion.setBuildConfigurations( mapSetMapper.mapBC( dtoEntity.getBuildConfigs() ) );
        if ( dtoEntity.getId() != null ) {
            productVersion.setId( Integer.parseInt( dtoEntity.getId() ) );
        }
        productVersion.setVersion( dtoEntity.getVersion() );
        productVersion.setProduct( refToReferenceMapper.toEntityReference( dtoEntity.getProduct() ) );
        productVersion.setProductMilestones( mapSetMapper.mapPM( dtoEntity.getProductMilestones() ) );
        productVersion.setCurrentProductMilestone( refToReferenceMapper.toEntityReference( dtoEntity.getCurrentProductMilestone() ) );
        Map<String, String> map = dtoEntity.getAttributes();
        if ( map != null ) {
            productVersion.setAttributes( new HashMap<String, String>( map ) );
        }

        return productVersion;
    }

    @Override
    public void updateEntity(org.jboss.pnc.dto.ProductVersion dtoEntity, ProductVersion target) {
        if ( dtoEntity == null ) {
            return;
        }

        target.setVersion( dtoEntity.getVersion() );
        target.setCurrentProductMilestone( refToReferenceMapper.toEntityReference( dtoEntity.getCurrentProductMilestone() ) );
        if ( target.getAttributes() != null ) {
            Map<String, String> map = dtoEntity.getAttributes();
            if ( map != null ) {
                target.getAttributes().clear();
                target.getAttributes().putAll( map );
            }
            else {
                target.setAttributes( null );
            }
        }
        else {
            Map<String, String> map = dtoEntity.getAttributes();
            if ( map != null ) {
                target.setAttributes( new HashMap<String, String>( map ) );
            }
        }

        target.setBuildConfigurationSets( cm.updateGroupConfigs(dtoEntity, target) );
        target.setBuildConfigurations( cm.updateBuildConfigs(dtoEntity, target) );
    }

    @Override
    public ProductVersionRef toRef(ProductVersion dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        Builder productVersionRef = ProductVersionRef.refBuilder();

        if ( dbEntity.getId() != null ) {
            productVersionRef.id( String.valueOf( dbEntity.getId() ) );
        }
        productVersionRef.version( dbEntity.getVersion() );
        Map<String, String> map = dbEntity.getAttributes();
        if ( map != null ) {
            productVersionRef.attributes( new HashMap<String, String>( map ) );
        }

        return productVersionRef.build();
    }

    @Override
    public org.jboss.pnc.dto.ProductVersion toDTO(ProductVersion dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.ProductVersion.Builder productVersion = org.jboss.pnc.dto.ProductVersion.builder();

        productVersion.groupConfigs( mapSetMapper.mapGC( dbEntity.getBuildConfigurationSets() ) );
        productVersion.product( productMapper.toRef( dbEntity.getProduct() ) );
        productVersion.currentProductMilestone( productMilestoneMapper.toRef( dbEntity.getCurrentProductMilestone() ) );
        productVersion.buildConfigs( mapSetMapper.mapBC( dbEntity.getBuildConfigurations() ) );
        productVersion.productMilestones( mapSetMapper.mapPM( dbEntity.getProductMilestones() ) );
        productVersion.productReleases( mapSetMapper.mapPR( dbEntity.getProductReleases() ) );
        if ( dbEntity.getId() != null ) {
            productVersion.id( String.valueOf( dbEntity.getId() ) );
        }
        productVersion.version( dbEntity.getVersion() );
        Map<String, String> map4 = dbEntity.getAttributes();
        if ( map4 != null ) {
            productVersion.attributes( new HashMap<String, String>( map4 ) );
        }

        return productVersion.build();
    }
}
