/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.Operation;
import org.jboss.pnc.dto.OperationRef;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.api.OperationMapper;
import org.jboss.pnc.mapper.api.UserMapper;

@ApplicationScoped
public class OperationMapperImpl
implements OperationMapper {
    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public Operation toDTO(org.jboss.pnc.model.Operation dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        Operation.OperationBuilder operation = Operation.operationBuilder();
        operation.user(this.userMapper.toRef(dbEntity.getUser()));
        Map map = dbEntity.getOperationParameters();
        if (map != null) {
            operation.parameters(new HashMap(map));
        }
        if (dbEntity.getSubmitTime() != null) {
            operation.submitTime(dbEntity.getSubmitTime().toInstant());
        }
        if (dbEntity.getStartTime() != null) {
            operation.startTime(dbEntity.getStartTime().toInstant());
        }
        if (dbEntity.getEndTime() != null) {
            operation.endTime(dbEntity.getEndTime().toInstant());
        }
        operation.progressStatus(dbEntity.getProgressStatus());
        operation.result(dbEntity.getResult());
        operation.id(this.getIdMapper().toDto(dbEntity.getId()));
        return operation.build();
    }

    @Override
    public OperationRef toRef(org.jboss.pnc.model.Operation dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        OperationRef.OperationRefBuilder operationRef = OperationRef.refBuilder();
        if (dbEntity.getSubmitTime() != null) {
            operationRef.submitTime(dbEntity.getSubmitTime().toInstant());
        }
        if (dbEntity.getStartTime() != null) {
            operationRef.startTime(dbEntity.getStartTime().toInstant());
        }
        if (dbEntity.getEndTime() != null) {
            operationRef.endTime(dbEntity.getEndTime().toInstant());
        }
        operationRef.progressStatus(dbEntity.getProgressStatus());
        operationRef.result(dbEntity.getResult());
        operationRef.id(this.getIdMapper().toDto(dbEntity.getId()));
        return operationRef.build();
    }

    @Override
    public org.jboss.pnc.model.Operation toEntity(Operation dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        org.jboss.pnc.model.Operation operation = new org.jboss.pnc.model.Operation();
        operation.setUser(this.refToReferenceMapper.toEntityReference(dtoEntity.getUser()));
        Map map = dtoEntity.getParameters();
        if (map != null) {
            operation.setOperationParameters(new HashMap(map));
        }
        if (dtoEntity.getSubmitTime() != null) {
            operation.setSubmitTime(Date.from(dtoEntity.getSubmitTime()));
        }
        if (dtoEntity.getStartTime() != null) {
            operation.setStartTime(Date.from(dtoEntity.getStartTime()));
        }
        if (dtoEntity.getEndTime() != null) {
            operation.setEndTime(Date.from(dtoEntity.getEndTime()));
        }
        operation.setProgressStatus(dtoEntity.getProgressStatus());
        operation.setResult(dtoEntity.getResult());
        operation.setId(this.getIdMapper().toEntity(dtoEntity.getId()));
        return operation;
    }

    @Override
    public void updateEntity(Operation dtoEntity, org.jboss.pnc.model.Operation target) {
        if (dtoEntity == null) {
            return;
        }
        if (target.getOperationParameters() != null) {
            Map map = dtoEntity.getParameters();
            if (map != null) {
                target.getOperationParameters().clear();
                target.getOperationParameters().putAll(map);
            } else {
                target.setOperationParameters(null);
            }
        } else {
            Map map = dtoEntity.getParameters();
            if (map != null) {
                target.setOperationParameters(new HashMap(map));
            }
        }
        if (dtoEntity.getSubmitTime() != null) {
            target.setSubmitTime(Date.from(dtoEntity.getSubmitTime()));
        } else {
            target.setSubmitTime(null);
        }
        if (dtoEntity.getStartTime() != null) {
            target.setStartTime(Date.from(dtoEntity.getStartTime()));
        } else {
            target.setStartTime(null);
        }
        if (dtoEntity.getEndTime() != null) {
            target.setEndTime(Date.from(dtoEntity.getEndTime()));
        } else {
            target.setEndTime(null);
        }
        target.setUser(this.userMapper.toEntity(dtoEntity.getUser()));
        target.setProgressStatus(dtoEntity.getProgressStatus());
        target.setResult(dtoEntity.getResult());
    }
}

