/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildPushResultRef;
import org.jboss.pnc.dto.ProductMilestoneCloseResult;
import org.jboss.pnc.dto.ProductMilestoneCloseResultRef;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.api.BuildPushResultMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneCloseResultMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.BuildRecordPushResult;
import org.jboss.pnc.model.ProductMilestoneRelease;

@ApplicationScoped
public class ProductMilestoneCloseResultMapperImpl
implements ProductMilestoneCloseResultMapper {
    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;
    @Inject
    private BuildPushResultMapper buildPushResultMapper;

    @Override
    public ProductMilestoneRelease toEntity(ProductMilestoneCloseResult dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        ProductMilestoneRelease productMilestoneRelease = new ProductMilestoneRelease();
        productMilestoneRelease.setBuildRecordPushResults(this.buildPushResultRefListToBuildRecordPushResultSet(dtoEntity.getBuildPushResults()));
        if (dtoEntity.getId() != null) {
            productMilestoneRelease.setId(Long.valueOf(Long.parseLong(dtoEntity.getId())));
        }
        productMilestoneRelease.setMilestone(this.refToReferenceMapper.toEntityReference(dtoEntity.getMilestone()));
        productMilestoneRelease.setStatus(dtoEntity.getStatus());
        if (dtoEntity.getStartingDate() != null) {
            productMilestoneRelease.setStartingDate(Date.from(dtoEntity.getStartingDate()));
        }
        if (dtoEntity.getEndDate() != null) {
            productMilestoneRelease.setEndDate(Date.from(dtoEntity.getEndDate()));
        }
        return productMilestoneRelease;
    }

    @Override
    public ProductMilestoneCloseResult toDTO(ProductMilestoneRelease dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductMilestoneCloseResult.Builder productMilestoneCloseResult = ProductMilestoneCloseResult.builder();
        productMilestoneCloseResult.milestone(this.productMilestoneMapper.toRef(dbEntity.getMilestone()));
        productMilestoneCloseResult.buildPushResults(this.buildRecordPushResultSetToBuildPushResultRefList(dbEntity.getBuildRecordPushResults()));
        if (dbEntity.getId() != null) {
            productMilestoneCloseResult.id(String.valueOf(dbEntity.getId()));
        }
        if (dbEntity.getStartingDate() != null) {
            productMilestoneCloseResult.startingDate(dbEntity.getStartingDate().toInstant());
        }
        if (dbEntity.getEndDate() != null) {
            productMilestoneCloseResult.endDate(dbEntity.getEndDate().toInstant());
        }
        productMilestoneCloseResult.status(dbEntity.getStatus());
        return productMilestoneCloseResult.build();
    }

    @Override
    public ProductMilestoneCloseResultRef toRef(ProductMilestoneRelease dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductMilestoneCloseResultRef.Builder productMilestoneCloseResultRef = ProductMilestoneCloseResultRef.refBuilder();
        if (dbEntity.getId() != null) {
            productMilestoneCloseResultRef.id(String.valueOf(dbEntity.getId()));
        }
        productMilestoneCloseResultRef.status(dbEntity.getStatus());
        if (dbEntity.getStartingDate() != null) {
            productMilestoneCloseResultRef.startingDate(dbEntity.getStartingDate().toInstant());
        }
        if (dbEntity.getEndDate() != null) {
            productMilestoneCloseResultRef.endDate(dbEntity.getEndDate().toInstant());
        }
        return productMilestoneCloseResultRef.build();
    }

    protected Set<BuildRecordPushResult> buildPushResultRefListToBuildRecordPushResultSet(List<BuildPushResultRef> list) {
        if (list == null) {
            return null;
        }
        HashSet<BuildRecordPushResult> set = new HashSet<BuildRecordPushResult>(Math.max((int)((float)list.size() / 0.75f) + 1, 16));
        for (BuildPushResultRef buildPushResultRef : list) {
            set.add(this.refToReferenceMapper.toEntityReference(buildPushResultRef));
        }
        return set;
    }

    protected List<BuildPushResultRef> buildRecordPushResultSetToBuildPushResultRefList(Set<BuildRecordPushResult> set) {
        if (set == null) {
            return null;
        }
        ArrayList<BuildPushResultRef> list = new ArrayList<BuildPushResultRef>(set.size());
        for (BuildRecordPushResult buildRecordPushResult : set) {
            list.add(this.buildPushResultMapper.toRef(buildRecordPushResult));
        }
        return list;
    }
}

