/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.mapper.MapSetMapper;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.abstracts.AbstractBuildConfigurationMapper;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.BuildConfiguration;

@ApplicationScoped
public class BuildConfigurationMapperImpl
extends AbstractBuildConfigurationMapper {
    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProjectMapper projectMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private EnvironmentMapper environmentMapper;
    @Inject
    private SCMRepositoryMapper sCMRepositoryMapper;
    @Inject
    private MapSetMapper mapSetMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public BuildConfiguration toEntity(org.jboss.pnc.dto.BuildConfiguration dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        BuildConfiguration buildConfiguration = new BuildConfiguration();
        if (dtoEntity.getModificationTime() != null) {
            buildConfiguration.setLastModificationTime(Date.from(dtoEntity.getModificationTime()));
        }
        buildConfiguration.setBuildEnvironment(this.refToReferenceMapper.toEntityReference(dtoEntity.getEnvironment()));
        buildConfiguration.setBuildConfigurationSets(this.mapSetMapper.mapGC(dtoEntity.getGroupConfigs()));
        buildConfiguration.setRepositoryConfiguration(this.refToReferenceMapper.toEntityReference(dtoEntity.getScmRepository()));
        Map map = dtoEntity.getParameters();
        if (map != null) {
            buildConfiguration.setGenericParameters(new HashMap(map));
        }
        buildConfiguration.setCreationUser(this.refToReferenceMapper.toEntityReference(dtoEntity.getCreationUser()));
        buildConfiguration.setLastModificationUser(this.refToReferenceMapper.toEntityReference(dtoEntity.getModificationUser()));
        if (dtoEntity.getBrewPullActive() != null) {
            buildConfiguration.setBrewPullActive(dtoEntity.getBrewPullActive().booleanValue());
        } else {
            buildConfiguration.setBrewPullActive(false);
        }
        buildConfiguration.setName(dtoEntity.getName());
        buildConfiguration.setBuildScript(dtoEntity.getBuildScript());
        buildConfiguration.setScmRevision(dtoEntity.getScmRevision());
        buildConfiguration.setDescription(dtoEntity.getDescription());
        buildConfiguration.setProject(this.refToReferenceMapper.toEntityReference(dtoEntity.getProject()));
        buildConfiguration.setProductVersion(this.refToReferenceMapper.toEntityReference(dtoEntity.getProductVersion()));
        buildConfiguration.setDependencies(this.mapSetMapper.mapBC(dtoEntity.getDependencies()));
        if (dtoEntity.getCreationTime() != null) {
            buildConfiguration.setCreationTime(Date.from(dtoEntity.getCreationTime()));
        }
        buildConfiguration.setBuildType(dtoEntity.getBuildType());
        buildConfiguration.setDefaultAlignmentParams(dtoEntity.getDefaultAlignmentParams());
        buildConfiguration.setId(Integer.valueOf(dtoEntity.getId()));
        return buildConfiguration;
    }

    @Override
    public void updateEntity(org.jboss.pnc.dto.BuildConfiguration dtoEntity, BuildConfiguration target) {
        if (dtoEntity == null) {
            return;
        }
        target.setBuildEnvironment(this.refToReferenceMapper.toEntityReference(dtoEntity.getEnvironment()));
        target.setRepositoryConfiguration(this.refToReferenceMapper.toEntityReference(dtoEntity.getScmRepository()));
        if (target.getGenericParameters() != null) {
            Map map = dtoEntity.getParameters();
            if (map != null) {
                target.getGenericParameters().clear();
                target.getGenericParameters().putAll(map);
            } else {
                target.setGenericParameters(null);
            }
        } else {
            Map map = dtoEntity.getParameters();
            if (map != null) {
                target.setGenericParameters(new HashMap(map));
            }
        }
        if (dtoEntity.getBrewPullActive() != null) {
            target.setBrewPullActive(dtoEntity.getBrewPullActive().booleanValue());
        } else {
            target.setBrewPullActive(false);
        }
        target.setName(dtoEntity.getName());
        target.setBuildScript(dtoEntity.getBuildScript());
        target.setScmRevision(dtoEntity.getScmRevision());
        target.setDescription(dtoEntity.getDescription());
        target.setProductVersion(this.refToReferenceMapper.toEntityReference(dtoEntity.getProductVersion()));
        target.setBuildType(dtoEntity.getBuildType());
        target.setDependencies(this.cm.updateDependencies(dtoEntity, target));
        target.setBuildConfigurationSets(this.cm.updateGroupConfigs(dtoEntity, target));
    }

    @Override
    public BuildConfigurationRef toRef(BuildConfiguration dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        BuildConfigurationRef.Builder buildConfigurationRef = BuildConfigurationRef.refBuilder();
        if (dbEntity.getLastModificationTime() != null) {
            buildConfigurationRef.modificationTime(dbEntity.getLastModificationTime().toInstant());
        }
        buildConfigurationRef.name(dbEntity.getName());
        buildConfigurationRef.description(dbEntity.getDescription());
        buildConfigurationRef.buildScript(dbEntity.getBuildScript());
        buildConfigurationRef.scmRevision(dbEntity.getScmRevision());
        if (dbEntity.getCreationTime() != null) {
            buildConfigurationRef.creationTime(dbEntity.getCreationTime().toInstant());
        }
        buildConfigurationRef.buildType(dbEntity.getBuildType());
        buildConfigurationRef.defaultAlignmentParams(dbEntity.getDefaultAlignmentParams());
        buildConfigurationRef.brewPullActive(Boolean.valueOf(dbEntity.isBrewPullActive()));
        buildConfigurationRef.id(dbEntity.getId().toString());
        return buildConfigurationRef.build();
    }

    @Override
    public org.jboss.pnc.dto.BuildConfiguration toDTO(BuildConfiguration dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        BuildConfiguration.Builder buildConfiguration = org.jboss.pnc.dto.BuildConfiguration.builder();
        if (dbEntity.getLastModificationTime() != null) {
            buildConfiguration.modificationTime(dbEntity.getLastModificationTime().toInstant());
        }
        buildConfiguration.environment(this.environmentMapper.toRef(dbEntity.getBuildEnvironment()));
        buildConfiguration.groupConfigs(this.mapSetMapper.mapGC(dbEntity.getBuildConfigurationSets()));
        buildConfiguration.dependencies(this.mapSetMapper.mapBC(dbEntity.getDependencies()));
        buildConfiguration.scmRepository(this.sCMRepositoryMapper.toRef(dbEntity.getRepositoryConfiguration()));
        buildConfiguration.project(this.projectMapper.toRef(dbEntity.getProject()));
        buildConfiguration.productVersion(this.productVersionMapper.toRef(dbEntity.getProductVersion()));
        Map map2 = dbEntity.getGenericParameters();
        if (map2 != null) {
            buildConfiguration.parameters(new HashMap(map2));
        }
        buildConfiguration.creationUser(this.userMapper.toRef(dbEntity.getCreationUser()));
        buildConfiguration.modificationUser(this.userMapper.toRef(dbEntity.getLastModificationUser()));
        buildConfiguration.name(dbEntity.getName());
        buildConfiguration.description(dbEntity.getDescription());
        buildConfiguration.buildScript(dbEntity.getBuildScript());
        buildConfiguration.scmRevision(dbEntity.getScmRevision());
        if (dbEntity.getCreationTime() != null) {
            buildConfiguration.creationTime(dbEntity.getCreationTime().toInstant());
        }
        buildConfiguration.buildType(dbEntity.getBuildType());
        buildConfiguration.defaultAlignmentParams(dbEntity.getDefaultAlignmentParams());
        buildConfiguration.brewPullActive(Boolean.valueOf(dbEntity.isBrewPullActive()));
        buildConfiguration.id(dbEntity.getId().toString());
        return buildConfiguration.build();
    }
}

