/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.mapper.MapSetMapper;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.ProductVersion;

@ApplicationScoped
public class CollectionMerger {
    @Inject
    private MapSetMapper mapSetMapper;

    public <C> void merge(Collection<C> oldContent, Collection<C> newContent, Consumer<C> adder, Consumer<C> remover) {
        if (newContent == null) {
            newContent = Collections.emptyList();
        }
        HashSet<C> toRemove = new HashSet<C>(oldContent);
        toRemove.removeAll(newContent);
        toRemove.forEach(remover);
        HashSet<C> toAdd = new HashSet<C>(newContent);
        toAdd.removeAll(oldContent);
        toAdd.forEach(adder);
    }

    public Set<BuildConfiguration> updateDependencies(org.jboss.pnc.dto.BuildConfiguration dto, BuildConfiguration target) {
        Set oldBCs = target.getDependencies();
        Set<BuildConfiguration> newBCs = this.mapSetMapper.mapBC(dto.getDependencies());
        this.merge(oldBCs, newBCs, arg_0 -> ((BuildConfiguration)target).addDependency(arg_0), arg_0 -> ((BuildConfiguration)target).removeDependency(arg_0));
        return target.getDependencies();
    }

    public Set<BuildConfigurationSet> updateGroupConfigs(org.jboss.pnc.dto.BuildConfiguration dto, BuildConfiguration target) {
        Set oldGCs = target.getBuildConfigurationSets();
        Set<BuildConfigurationSet> newGCs = this.mapSetMapper.mapGC(dto.getGroupConfigs());
        this.merge(oldGCs, newGCs, arg_0 -> ((BuildConfiguration)target).addBuildConfigurationSet(arg_0), arg_0 -> ((BuildConfiguration)target).removeBuildConfigurationSet(arg_0));
        return target.getBuildConfigurationSets();
    }

    public Set<BuildConfiguration> updateBuildConfigs(GroupConfiguration dto, BuildConfigurationSet target) {
        Set oldBCs = target.getBuildConfigurations();
        Set<BuildConfiguration> newBCs = this.mapSetMapper.mapBC(dto.getBuildConfigs());
        this.merge(oldBCs, newBCs, arg_0 -> ((BuildConfigurationSet)target).addBuildConfiguration(arg_0), arg_0 -> ((BuildConfigurationSet)target).removeBuildConfiguration(arg_0));
        return target.getBuildConfigurations();
    }

    public Set<BuildConfiguration> updateBuildConfigs(org.jboss.pnc.dto.ProductVersion dto, ProductVersion target) {
        Set oldBCs = target.getBuildConfigurations();
        Set<BuildConfiguration> newBCs = this.mapSetMapper.mapBC(dto.getBuildConfigs());
        this.merge(oldBCs, newBCs, arg_0 -> ((ProductVersion)target).addBuildConfiguration(arg_0), arg_0 -> ((ProductVersion)target).removeBuildConfiguration(arg_0));
        return target.getBuildConfigurations();
    }

    public Set<BuildConfigurationSet> updateGroupConfigs(org.jboss.pnc.dto.ProductVersion dto, ProductVersion target) {
        Set oldGCs = target.getBuildConfigurationSets();
        Set<BuildConfigurationSet> newGCs = this.mapSetMapper.mapGC(dto.getGroupConfigs());
        this.merge(oldGCs, newGCs, arg_0 -> ((ProductVersion)target).addBuildConfigurationSet(arg_0), arg_0 -> ((ProductVersion)target).removeBuildConfigurationSet(arg_0));
        return target.getBuildConfigurationSets();
    }
}

