/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.mapper.MapSetMapper;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.abstracts.AbstractGroupConfigurationMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.BuildConfigurationSet;

@ApplicationScoped
public class GroupConfigurationMapperImpl
extends AbstractGroupConfigurationMapper {
    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private MapSetMapper mapSetMapper;

    @Override
    public BuildConfigurationSet toEntity(GroupConfiguration dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        BuildConfigurationSet buildConfigurationSet = new BuildConfigurationSet();
        buildConfigurationSet.setBuildConfigurations(this.mapSetMapper.mapBC(dtoEntity.getBuildConfigs()));
        if (dtoEntity.getId() != null) {
            buildConfigurationSet.setId(Integer.valueOf(Integer.parseInt(dtoEntity.getId())));
        }
        buildConfigurationSet.setName(dtoEntity.getName());
        buildConfigurationSet.setProductVersion(this.refToReferenceMapper.toEntityReference(dtoEntity.getProductVersion()));
        buildConfigurationSet.setActive(Boolean.valueOf(true));
        return buildConfigurationSet;
    }

    @Override
    public void updateEntity(GroupConfiguration dtoEntity, BuildConfigurationSet target) {
        if (dtoEntity == null) {
            return;
        }
        target.setName(dtoEntity.getName());
        target.setProductVersion(this.refToReferenceMapper.toEntityReference(dtoEntity.getProductVersion()));
        target.setBuildConfigurations(this.cm.updateBuildConfigs(dtoEntity, target));
    }

    @Override
    public GroupConfigurationRef toRef(BuildConfigurationSet dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        GroupConfigurationRef.Builder groupConfigurationRef = GroupConfigurationRef.refBuilder();
        if (dbEntity.getId() != null) {
            groupConfigurationRef.id(String.valueOf(dbEntity.getId()));
        }
        groupConfigurationRef.name(dbEntity.getName());
        return groupConfigurationRef.build();
    }

    @Override
    public GroupConfiguration toDTO(BuildConfigurationSet dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        GroupConfiguration.Builder groupConfiguration = GroupConfiguration.builder();
        groupConfiguration.productVersion(this.productVersionMapper.toRef(dbEntity.getProductVersion()));
        groupConfiguration.buildConfigs(this.mapSetMapper.mapBC(dbEntity.getBuildConfigurations()));
        if (dbEntity.getId() != null) {
            groupConfiguration.id(String.valueOf(dbEntity.getId()));
        }
        groupConfiguration.name(dbEntity.getName());
        return groupConfiguration.build();
    }
}

