/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper.api;

import java.util.Optional;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildConfigurationRevisionRef;
import org.jboss.pnc.dto.BuildRef;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.enums.BuildCoordinationStatus;
import org.jboss.pnc.enums.BuildProgress;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.mapper.Base32LongIdMapper;
import org.jboss.pnc.mapper.BrewNameWorkaround;
import org.jboss.pnc.mapper.BuildBCRevisionFetcher;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.mapper.api.IdEntity;
import org.jboss.pnc.mapper.api.IdMapper;
import org.jboss.pnc.mapper.api.MapperCentralConfig;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.mapper.api.Reference;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UpdatableEntityMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;

@Mapper(config=MapperCentralConfig.class, uses={RefToReferenceMapper.class, UserMapper.class, StatusMapper.class, SCMRepositoryMapper.class, ProjectMapper.class, BuildConfigurationRevisionMapper.class, EnvironmentMapper.class, BrewNameWorkaround.class, GroupBuildMapper.class, BuildBCRevisionFetcher.class, ProductMilestoneMapper.class})
public interface BuildMapper
extends UpdatableEntityMapper<Base32LongID, BuildRecord, Build, BuildRef> {
    public static final Base32LongIdMapper idMapper = new Base32LongIdMapper();

    @Override
    @Mappings(value={@Mapping(target="id", expression="java( getIdMapper().toDto(dbEntity.getId()) )"), @Mapping(target="environment", ignore=true), @Mapping(target="productMilestone", resultType=ProductMilestoneRef.class), @Mapping(target="buildConfigRevision", ignore=true), @Mapping(target="project", ignore=true), @Mapping(target="scmRepository", ignore=true), @Mapping(target="groupBuild", source="buildConfigSetRecord", qualifiedBy={Reference.class}), @Mapping(target="user", qualifiedBy={Reference.class}), @Mapping(target="noRebuildCause", resultType=BuildRef.class), @Mapping(target="scmUrl", source="scmRepoURL"), @Mapping(target="attributes", ignore=true), @Mapping(target="progress", source="status")})
    @BeanMapping(ignoreUnmappedSourceProperties={"buildLog", "buildLogMd5", "buildLogSha256", "buildLogSize", "sshCommand", "sshPassword", "executionRootName", "executionRootVersion", "builtArtifacts", "dependencies", "repourLog", "repourLogMd5", "repourLogSha256", "repourLogSize", "buildRecordPushResults", "buildConfigurationId", "buildConfigurationRev", "buildConfigurationAuditedIdRev", "buildEnvironment", "buildConfigurationAudited", "buildOutputChecksum", "dependentBuildRecordIds", "dependencyBuildRecordIds", "attributesMap"})
    public Build toDTO(BuildRecord var1);

    @Override
    @Mappings(value={@Mapping(target="id", expression="java( getIdMapper().toDto(dbEntity.getId()) )"), @Mapping(target="scmUrl", source="scmRepoURL"), @Mapping(target="progress", source="status")})
    @BeanMapping(ignoreUnmappedSourceProperties={"scmRevision", "scmTag", "buildLog", "buildLogMd5", "buildLogSha256", "buildLogSize", "sshCommand", "sshPassword", "executionRootName", "executionRootVersion", "builtArtifacts", "dependencies", "productMilestone", "buildConfigSetRecord", "repourLog", "repourLogMd5", "repourLogSha256", "repourLogSize", "buildRecordPushResults", "buildConfigurationId", "buildConfigurationRev", "buildEnvironment", "buildConfigurationAudited", "dependentBuildRecordIds", "dependencyBuildRecordIds", "user", "attributes", "attributesMap", "buildConfigurationAuditedIdRev", "buildOutputChecksum", "noRebuildRequired"})
    public BuildRef toRef(BuildRecord var1);

    @Override
    @Mappings(value={@Mapping(target="id", expression="java( getIdMapper().toEntity(dtoEntity.getId()) )"), @Mapping(target="buildEnvironment", source="environment", qualifiedBy={IdEntity.class}), @Mapping(target="dependentBuildRecordIds", ignore=true), @Mapping(target="dependencyBuildRecordIds", ignore=true), @Mapping(target="buildConfigurationAudited", ignore=true), @Mapping(target="buildConfigSetRecord", source="groupBuild"), @Mapping(target="scmRepoURL", source="scmUrl"), @Mapping(target="user", qualifiedBy={IdEntity.class}), @Mapping(target="repourLog", ignore=true), @Mapping(target="buildLog", ignore=true), @Mapping(target="builtArtifacts", ignore=true), @Mapping(target="dependencies", ignore=true), @Mapping(target="buildConfigurationId", source="buildConfigRevision.id"), @Mapping(target="buildConfigurationRev", source="buildConfigRevision.rev"), @Mapping(target="productMilestone", ignore=true), @Mapping(target="buildLogMd5", ignore=true), @Mapping(target="buildLogSha256", ignore=true), @Mapping(target="buildLogSize", ignore=true), @Mapping(target="sshCommand", ignore=true), @Mapping(target="sshPassword", ignore=true), @Mapping(target="executionRootName", ignore=true), @Mapping(target="executionRootVersion", ignore=true), @Mapping(target="repourLogMd5", ignore=true), @Mapping(target="repourLogSha256", ignore=true), @Mapping(target="repourLogSize", ignore=true), @Mapping(target="buildOutputChecksum", ignore=true), @Mapping(target="buildRecordPushResults", ignore=true), @Mapping(target="attributes", ignore=true), @Mapping(target="attributesMap", ignore=true), @Mapping(target="noRebuildCause", qualifiedBy={IdEntity.class})})
    @BeanMapping(ignoreUnmappedSourceProperties={"project", "scmRepository", "progress"})
    public BuildRecord toEntity(Build var1);

    @Override
    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="attributes", ignore=true), @Mapping(target="attributesMap", ignore=true), @Mapping(target="buildConfigurationAudited", ignore=true), @Mapping(target="buildRecordPushResults", ignore=true), @Mapping(target="buildConfigurationId", ignore=true), @Mapping(target="buildConfigurationRev", ignore=true), @Mapping(target="buildContentId", ignore=true), @Mapping(target="temporaryBuild", ignore=true), @Mapping(target="alignmentPreference", ignore=true), @Mapping(target="submitTime", ignore=true), @Mapping(target="startTime", ignore=true), @Mapping(target="endTime", ignore=true), @Mapping(target="lastUpdateTime", ignore=true), @Mapping(target="user", ignore=true), @Mapping(target="scmRepoURL", ignore=true), @Mapping(target="scmRevision", ignore=true), @Mapping(target="scmTag", ignore=true), @Mapping(target="buildOutputChecksum", ignore=true), @Mapping(target="sshCommand", ignore=true), @Mapping(target="sshPassword", ignore=true), @Mapping(target="builtArtifacts", ignore=true), @Mapping(target="dependencies", ignore=true), @Mapping(target="buildEnvironment", ignore=true), @Mapping(target="productMilestone", ignore=true), @Mapping(target="buildConfigSetRecord", ignore=true), @Mapping(target="noRebuildCause", ignore=true), @Mapping(target="buildLog", ignore=true), @Mapping(target="buildLogMd5", ignore=true), @Mapping(target="buildLogSha256", ignore=true), @Mapping(target="buildLogSize", ignore=true), @Mapping(target="repourLog", ignore=true), @Mapping(target="repourLogMd5", ignore=true), @Mapping(target="repourLogSha256", ignore=true), @Mapping(target="repourLogSize", ignore=true), @Mapping(target="dependentBuildRecordIds", ignore=true), @Mapping(target="dependencyBuildRecordIds", ignore=true), @Mapping(target="executionRootName", ignore=true), @Mapping(target="executionRootVersion", ignore=true)})
    public void updateEntity(Build var1, @MappingTarget BuildRecord var2);

    @Mappings(value={@Mapping(target="id", expression="java( buildTask.getId() )"), @Mapping(target="project", source="buildConfigurationAudited.project", resultType=ProjectRef.class), @Mapping(target="scmRepository", source="buildConfigurationAudited.repositoryConfiguration", qualifiedBy={Reference.class}), @Mapping(target="environment", source="buildConfigurationAudited.buildEnvironment", qualifiedBy={Reference.class}), @Mapping(target="buildConfigRevision", source="buildConfigurationAudited", resultType=BuildConfigurationRevisionRef.class), @Mapping(target="groupBuild", source="buildSetTask.buildConfigSetRecord"), @Mapping(target="productMilestone", resultType=ProductMilestoneRef.class), @Mapping(target="noRebuildCause", resultType=BuildRef.class), @Mapping(target="buildContentId", source="contentId"), @Mapping(target="temporaryBuild", source="buildOptions.temporaryBuild"), @Mapping(target="alignmentPreference", source="buildOptions.alignmentPreference"), @Mapping(target="scmUrl", ignore=true), @Mapping(target="scmRevision", ignore=true), @Mapping(target="scmTag", ignore=true), @Mapping(target="attributes", ignore=true), @Mapping(target="lastUpdateTime", ignore=true), @Mapping(target="progress", source="status"), @Mapping(target="buildOutputChecksum", ignore=true)})
    @BeanMapping(ignoreUnmappedSourceProperties={"statusDescription", "buildSetTask", "buildConfigSetRecordId", "buildOptions", "dependants", "dependencies", "requestContext"})
    public Build fromBuildTask(BuildTask var1);

    public static <T> T unwrap(Optional<T> optional) {
        return optional != null && optional.isPresent() ? (T)optional.get() : null;
    }

    public static BuildProgress buildProgress(BuildStatus status) {
        return status == null ? null : status.progress();
    }

    @Override
    default public IdMapper<Base32LongID, String> getIdMapper() {
        return idMapper;
    }

    public static class IDMapper {
        public static BuildRecord toIdEntity(String id) {
            BuildRecord buildRecord = new BuildRecord();
            buildRecord.setId(idMapper.toEntity(id));
            return buildRecord;
        }

        public static String toDtoId(BuildRecord buildRecord) {
            return idMapper.toDto(buildRecord.getId());
        }
    }

    public static class StatusMapper {
        public static BuildCoordinationStatus toBuildCoordinationStatus(BuildStatus status) {
            return BuildCoordinationStatus.fromBuildStatus((BuildStatus)status);
        }

        public static BuildStatus toBuildStatus(BuildCoordinationStatus status) {
            return BuildStatus.fromBuildCoordinationStatus((BuildCoordinationStatus)status);
        }
    }
}

