package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Generated;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.mapper.abstracts.AbstractBuildConfigurationMapper;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2023-06-20T03:39:00+0000",
    comments = "version: 1.5.3.Final, compiler: javac, environment: Java 11.0.18-ea (Red Hat, Inc.)"
)
@ApplicationScoped
public class BuildConfigurationMapperImpl extends AbstractBuildConfigurationMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProjectMapper projectMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private EnvironmentMapper environmentMapper;
    @Inject
    private SCMRepositoryMapper sCMRepositoryMapper;
    @Inject
    private MapSetMapper mapSetMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public org.jboss.pnc.model.BuildConfiguration toEntity(BuildConfiguration dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        org.jboss.pnc.model.BuildConfiguration buildConfiguration = new org.jboss.pnc.model.BuildConfiguration();

        if ( dtoEntity.getModificationTime() != null ) {
            buildConfiguration.setLastModificationTime( Date.from( dtoEntity.getModificationTime() ) );
        }
        buildConfiguration.setBuildEnvironment( refToReferenceMapper.toEntityReference( dtoEntity.getEnvironment() ) );
        buildConfiguration.setBuildConfigurationSets( mapSetMapper.mapGC( dtoEntity.getGroupConfigs() ) );
        buildConfiguration.setRepositoryConfiguration( refToReferenceMapper.toEntityReference( dtoEntity.getScmRepository() ) );
        Map<String, String> map = dtoEntity.getParameters();
        if ( map != null ) {
            buildConfiguration.setGenericParameters( new LinkedHashMap<String, String>( map ) );
        }
        buildConfiguration.setCreationUser( refToReferenceMapper.toEntityReference( dtoEntity.getCreationUser() ) );
        buildConfiguration.setAlignStrategies( mapSetMapper.mapAC( dtoEntity.getAlignmentStrategies() ) );
        buildConfiguration.setLastModificationUser( refToReferenceMapper.toEntityReference( dtoEntity.getModificationUser() ) );
        if ( dtoEntity.getBrewPullActive() != null ) {
            buildConfiguration.setBrewPullActive( dtoEntity.getBrewPullActive() );
        }
        else {
            buildConfiguration.setBrewPullActive( false );
        }
        buildConfiguration.setName( dtoEntity.getName() );
        buildConfiguration.setBuildScript( dtoEntity.getBuildScript() );
        buildConfiguration.setScmRevision( dtoEntity.getScmRevision() );
        buildConfiguration.setDescription( dtoEntity.getDescription() );
        buildConfiguration.setProject( refToReferenceMapper.toEntityReference( dtoEntity.getProject() ) );
        buildConfiguration.setProductVersion( refToReferenceMapper.toEntityReference( dtoEntity.getProductVersion() ) );
        buildConfiguration.setDependencies( mapSetMapper.mapBC( dtoEntity.getDependencies() ) );
        if ( dtoEntity.getCreationTime() != null ) {
            buildConfiguration.setCreationTime( Date.from( dtoEntity.getCreationTime() ) );
        }
        buildConfiguration.setBuildType( dtoEntity.getBuildType() );
        buildConfiguration.setDefaultAlignmentParams( dtoEntity.getDefaultAlignmentParams() );

        buildConfiguration.setId( java.lang.Integer.valueOf(dtoEntity.getId()) );

        return buildConfiguration;
    }

    @Override
    public void updateEntity(BuildConfiguration dtoEntity, org.jboss.pnc.model.BuildConfiguration target) {
        if ( dtoEntity == null ) {
            return;
        }

        target.setBuildEnvironment( refToReferenceMapper.toEntityReference( dtoEntity.getEnvironment() ) );
        target.setRepositoryConfiguration( refToReferenceMapper.toEntityReference( dtoEntity.getScmRepository() ) );
        if ( target.getGenericParameters() != null ) {
            Map<String, String> map = dtoEntity.getParameters();
            if ( map != null ) {
                target.getGenericParameters().clear();
                target.getGenericParameters().putAll( map );
            }
            else {
                target.setGenericParameters( null );
            }
        }
        else {
            Map<String, String> map = dtoEntity.getParameters();
            if ( map != null ) {
                target.setGenericParameters( new LinkedHashMap<String, String>( map ) );
            }
        }
        if ( dtoEntity.getBrewPullActive() != null ) {
            target.setBrewPullActive( dtoEntity.getBrewPullActive() );
        }
        else {
            target.setBrewPullActive( false );
        }
        target.setName( dtoEntity.getName() );
        target.setBuildScript( dtoEntity.getBuildScript() );
        target.setScmRevision( dtoEntity.getScmRevision() );
        target.setDescription( dtoEntity.getDescription() );
        target.setProductVersion( refToReferenceMapper.toEntityReference( dtoEntity.getProductVersion() ) );
        target.setBuildType( dtoEntity.getBuildType() );

        target.setAlignStrategies( mapSetMapper.updateAlignStrats(dtoEntity.getAlignmentStrategies(), target.getAlignStrategies()) );
        target.setDependencies( cm.updateDependencies(dtoEntity, target) );
        target.setBuildConfigurationSets( cm.updateGroupConfigs(dtoEntity, target) );
    }

    @Override
    public BuildConfigurationRef toRef(org.jboss.pnc.model.BuildConfiguration dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        BuildConfigurationRef.Builder buildConfigurationRef = BuildConfigurationRef.refBuilder();

        if ( dbEntity.getLastModificationTime() != null ) {
            buildConfigurationRef.modificationTime( dbEntity.getLastModificationTime().toInstant() );
        }
        buildConfigurationRef.name( dbEntity.getName() );
        buildConfigurationRef.description( dbEntity.getDescription() );
        buildConfigurationRef.buildScript( dbEntity.getBuildScript() );
        buildConfigurationRef.scmRevision( dbEntity.getScmRevision() );
        if ( dbEntity.getCreationTime() != null ) {
            buildConfigurationRef.creationTime( dbEntity.getCreationTime().toInstant() );
        }
        buildConfigurationRef.buildType( dbEntity.getBuildType() );
        buildConfigurationRef.defaultAlignmentParams( dbEntity.getDefaultAlignmentParams() );
        buildConfigurationRef.brewPullActive( dbEntity.isBrewPullActive() );

        buildConfigurationRef.id( dbEntity.getId().toString() );

        return buildConfigurationRef.build();
    }

    @Override
    public BuildConfiguration toDTO(org.jboss.pnc.model.BuildConfiguration dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        BuildConfiguration.Builder buildConfiguration = BuildConfiguration.builder();

        if ( dbEntity.getLastModificationTime() != null ) {
            buildConfiguration.modificationTime( dbEntity.getLastModificationTime().toInstant() );
        }
        buildConfiguration.environment( environmentMapper.toRef( dbEntity.getBuildEnvironment() ) );
        buildConfiguration.groupConfigs( mapSetMapper.mapGC( dbEntity.getBuildConfigurationSets() ) );
        buildConfiguration.dependencies( mapSetMapper.mapBC( dbEntity.getDependencies() ) );
        buildConfiguration.scmRepository( sCMRepositoryMapper.toRef( dbEntity.getRepositoryConfiguration() ) );
        buildConfiguration.project( projectMapper.toRef( dbEntity.getProject() ) );
        buildConfiguration.productVersion( productVersionMapper.toRef( dbEntity.getProductVersion() ) );
        Map<String, String> map2 = dbEntity.getGenericParameters();
        if ( map2 != null ) {
            buildConfiguration.parameters( new LinkedHashMap<String, String>( map2 ) );
        }
        buildConfiguration.creationUser( userMapper.toRef( dbEntity.getCreationUser() ) );
        buildConfiguration.alignmentStrategies( mapSetMapper.mapAC( dbEntity.getAlignStrategies() ) );
        buildConfiguration.modificationUser( userMapper.toRef( dbEntity.getLastModificationUser() ) );
        buildConfiguration.name( dbEntity.getName() );
        buildConfiguration.description( dbEntity.getDescription() );
        buildConfiguration.buildScript( dbEntity.getBuildScript() );
        buildConfiguration.scmRevision( dbEntity.getScmRevision() );
        if ( dbEntity.getCreationTime() != null ) {
            buildConfiguration.creationTime( dbEntity.getCreationTime().toInstant() );
        }
        buildConfiguration.buildType( dbEntity.getBuildType() );
        buildConfiguration.defaultAlignmentParams( dbEntity.getDefaultAlignmentParams() );
        buildConfiguration.brewPullActive( dbEntity.isBrewPullActive() );

        buildConfiguration.id( dbEntity.getId().toString() );

        return buildConfiguration.build();
    }
}
