package org.jboss.pnc.mapper;

import javax.annotation.processing.Generated;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildPushResult;
import org.jboss.pnc.dto.BuildPushResultRef;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.BuildPushResultMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneCloseResultMapper;
import org.jboss.pnc.model.BuildRecordPushResult;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2023-06-20T03:38:59+0000",
    comments = "version: 1.5.3.Final, compiler: javac, environment: Java 11.0.18-ea (Red Hat, Inc.)"
)
@ApplicationScoped
public class BuildPushResultMapperImpl implements BuildPushResultMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductMilestoneCloseResultMapper productMilestoneCloseResultMapper;

    @Override
    public BuildPushResult toDTO(BuildRecordPushResult db) {
        if ( db == null ) {
            return null;
        }

        BuildPushResult.Builder buildPushResult = BuildPushResult.builder();

        buildPushResult.buildId( BuildMapper.IDMapper.toDtoId( db.getBuildRecord() ) );
        buildPushResult.productMilestoneCloseResult( productMilestoneCloseResultMapper.toRef( db.getProductMilestoneRelease() ) );
        if ( db.getId() != null ) {
            buildPushResult.id( String.valueOf( db.getId() ) );
        }
        buildPushResult.status( db.getStatus() );
        buildPushResult.brewBuildId( db.getBrewBuildId() );
        buildPushResult.brewBuildUrl( db.getBrewBuildUrl() );

        buildPushResult.logContext( logContext(db) );

        return buildPushResult.build();
    }

    @Override
    public BuildPushResultRef toRef(BuildRecordPushResult db) {
        if ( db == null ) {
            return null;
        }

        BuildPushResultRef.Builder buildPushResultRef = BuildPushResultRef.refBuilder();

        buildPushResultRef.buildId( BuildMapper.IDMapper.toDtoId( db.getBuildRecord() ) );
        if ( db.getId() != null ) {
            buildPushResultRef.id( String.valueOf( db.getId() ) );
        }
        buildPushResultRef.status( db.getStatus() );
        buildPushResultRef.brewBuildId( db.getBrewBuildId() );
        buildPushResultRef.brewBuildUrl( db.getBrewBuildUrl() );

        buildPushResultRef.logContext( logContext(db) );

        return buildPushResultRef.build();
    }

    @Override
    public BuildRecordPushResult toEntity(BuildPushResult dto) {
        if ( dto == null ) {
            return null;
        }

        BuildRecordPushResult.Builder buildRecordPushResult = BuildRecordPushResult.newBuilder();

        buildRecordPushResult.buildRecord( BuildMapper.IDMapper.toIdEntity( dto.getBuildId() ) );
        buildRecordPushResult.productMilestoneRelease( refToReferenceMapper.toEntityReference( dto.getProductMilestoneCloseResult() ) );
        if ( dto.getId() != null ) {
            buildRecordPushResult.id( Long.parseLong( dto.getId() ) );
        }
        buildRecordPushResult.status( dto.getStatus() );
        buildRecordPushResult.brewBuildId( dto.getBrewBuildId() );
        buildRecordPushResult.brewBuildUrl( dto.getBrewBuildUrl() );

        return buildRecordPushResult.build();
    }
}
