package org.jboss.pnc.mapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Generated;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.enums.BuildCoordinationStatus;
import org.jboss.pnc.mapper.api.BuildTaskMappers;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.User;
import org.jboss.pnc.model.utils.ContentIdentityManager;
import org.jboss.pnc.rex.dto.TaskDTO;
import org.jboss.pnc.rex.model.requests.MinimizedTask;
import org.jboss.pnc.spi.BuildOptions;
import org.jboss.pnc.spi.coordinator.BuildMeta;
import org.jboss.pnc.spi.coordinator.BuildSetTask;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.coordinator.BuildTaskRef;
import org.jboss.pnc.spi.coordinator.DefaultBuildTaskRef;
import org.jboss.pnc.spi.coordinator.RemoteBuildTask;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2023-06-20T03:39:00+0000",
    comments = "version: 1.5.3.Final, compiler: javac, environment: Java 11.0.18-ea (Red Hat, Inc.)"
)
@ApplicationScoped
public class BuildTaskMappersImpl implements BuildTaskMappers {

    @Inject
    private UserFetcher userFetcher;
    @Inject
    private IDToReferenceMapper iDToReferenceMapper;

    @Override
    public DefaultBuildTaskRef toBuildTaskRef(TaskDTO task, BuildMeta meta) {
        if ( task == null && meta == null ) {
            return null;
        }

        DefaultBuildTaskRef.DefaultBuildTaskRefBuilder defaultBuildTaskRef = DefaultBuildTaskRef.builder();

        if ( task != null ) {
            defaultBuildTaskRef.id( task.getName() );
            defaultBuildTaskRef.idRev( BuildTaskMappers.fromConstraint( task.getConstraint() ) );
            if ( task.getCorrelationID() != null ) {
                defaultBuildTaskRef.buildConfigSetRecordId( Long.parseLong( task.getCorrelationID() ) );
            }
            Set<String> set = task.getDependants();
            if ( set != null ) {
                defaultBuildTaskRef.taskDependants( new LinkedHashSet<String>( set ) );
            }
            Set<String> set1 = task.getDependencies();
            if ( set1 != null ) {
                defaultBuildTaskRef.taskDependencies( new LinkedHashSet<String>( set1 ) );
            }
        }
        if ( meta != null ) {
            if ( meta.getProductMilestoneId() != null ) {
                defaultBuildTaskRef.productMilestone( iDToReferenceMapper.toProductMilestoneReference( String.valueOf( meta.getProductMilestoneId() ) ) );
            }
            if ( meta.getSubmitTime() != null ) {
                defaultBuildTaskRef.submitTime( meta.getSubmitTime().toInstant() );
            }
            defaultBuildTaskRef.user( userFetcher.toUserReference( meta.getUsername() ) );
            defaultBuildTaskRef.noRebuildCause( iDToReferenceMapper.toBuildRecordReference( meta.getNoRebuildCauseId() ) );
            List<String> list = meta.getDependants();
            if ( list != null ) {
                defaultBuildTaskRef.dependants( new LinkedHashSet<String>( list ) );
            }
            List<String> list1 = meta.getDependencies();
            if ( list1 != null ) {
                defaultBuildTaskRef.dependencies( new LinkedHashSet<String>( list1 ) );
            }
            defaultBuildTaskRef.contentId( meta.getContentId() );
            defaultBuildTaskRef.temporaryBuild( meta.isTemporaryBuild() );
            defaultBuildTaskRef.alignmentPreference( meta.getAlignmentPreference() );
        }
        defaultBuildTaskRef.status( BuildTaskMappers.toBuildStatus(task.getState(), task.getStopFlag()) );

        return defaultBuildTaskRef.build();
    }

    @Override
    public DefaultBuildTaskRef toBuildTaskRef(MinimizedTask task, BuildMeta meta) {
        if ( task == null && meta == null ) {
            return null;
        }

        DefaultBuildTaskRef.DefaultBuildTaskRefBuilder defaultBuildTaskRef = DefaultBuildTaskRef.builder();

        if ( task != null ) {
            defaultBuildTaskRef.id( task.getName() );
            defaultBuildTaskRef.idRev( BuildTaskMappers.fromConstraint( task.getConstraint() ) );
            if ( task.getCorrelationID() != null ) {
                defaultBuildTaskRef.buildConfigSetRecordId( Long.parseLong( task.getCorrelationID() ) );
            }
            Set<String> set = task.getDependants();
            if ( set != null ) {
                defaultBuildTaskRef.taskDependants( new LinkedHashSet<String>( set ) );
            }
            Set<String> set1 = task.getDependencies();
            if ( set1 != null ) {
                defaultBuildTaskRef.taskDependencies( new LinkedHashSet<String>( set1 ) );
            }
        }
        if ( meta != null ) {
            if ( meta.getProductMilestoneId() != null ) {
                defaultBuildTaskRef.productMilestone( iDToReferenceMapper.toProductMilestoneReference( String.valueOf( meta.getProductMilestoneId() ) ) );
            }
            if ( meta.getSubmitTime() != null ) {
                defaultBuildTaskRef.submitTime( meta.getSubmitTime().toInstant() );
            }
            defaultBuildTaskRef.user( userFetcher.toUserReference( meta.getUsername() ) );
            defaultBuildTaskRef.noRebuildCause( iDToReferenceMapper.toBuildRecordReference( meta.getNoRebuildCauseId() ) );
            List<String> list = meta.getDependants();
            if ( list != null ) {
                defaultBuildTaskRef.dependants( new LinkedHashSet<String>( list ) );
            }
            List<String> list1 = meta.getDependencies();
            if ( list1 != null ) {
                defaultBuildTaskRef.dependencies( new LinkedHashSet<String>( list1 ) );
            }
            defaultBuildTaskRef.contentId( meta.getContentId() );
            defaultBuildTaskRef.temporaryBuild( meta.isTemporaryBuild() );
            defaultBuildTaskRef.alignmentPreference( meta.getAlignmentPreference() );
        }
        defaultBuildTaskRef.status( BuildTaskMappers.toBuildStatus(task.getState(), task.getStopFlag()) );

        return defaultBuildTaskRef.build();
    }

    @Override
    public BuildTask toBuildTask(BuildTaskRef remoteTaskRef) {
        if ( remoteTaskRef == null ) {
            return null;
        }

        BuildOptions buildOptions = null;
        BuildConfigurationAudited buildConfigurationAudited = null;
        Long buildConfigSetRecordId = null;
        User user = null;
        Date submitTime = null;
        String id = null;
        ProductMilestone productMilestone = null;
        String contentId = null;

        buildOptions = buildTaskRefToBuildOptions( remoteTaskRef );
        buildConfigurationAudited = iDToReferenceMapper.toBCAReference( remoteTaskRef.getIdRev() );
        buildConfigSetRecordId = remoteTaskRef.getBuildConfigSetRecordId();
        user = remoteTaskRef.getUser();
        if ( remoteTaskRef.getSubmitTime() != null ) {
            submitTime = Date.from( remoteTaskRef.getSubmitTime() );
        }
        id = remoteTaskRef.getId();
        productMilestone = remoteTaskRef.getProductMilestone();
        contentId = remoteTaskRef.getContentId();

        BuildSetTask buildSetTask = null;
        String requestContext = null;

        BuildTask buildTask = new BuildTask( buildConfigurationAudited, buildOptions, user, submitTime, buildSetTask, id, buildConfigSetRecordId, productMilestone, contentId, requestContext );

        if ( remoteTaskRef.getStartTime() != null ) {
            buildTask.setStartTime( Date.from( remoteTaskRef.getStartTime() ) );
        }
        if ( remoteTaskRef.getEndTime() != null ) {
            buildTask.setEndTime( Date.from( remoteTaskRef.getEndTime() ) );
        }
        buildTask.setStatus( remoteTaskRef.getStatus() );
        buildTask.setNoRebuildCause( remoteTaskRef.getNoRebuildCause() );
        if ( buildTask.getDependants() != null ) {
            Set<BuildTask> set = stringSetToBuildTaskSet( remoteTaskRef.getDependants() );
            if ( set != null ) {
                buildTask.getDependants().addAll( set );
            }
        }
        if ( buildTask.getDependencies() != null ) {
            Set<BuildTask> set1 = stringSetToBuildTaskSet( remoteTaskRef.getDependencies() );
            if ( set1 != null ) {
                buildTask.getDependencies().addAll( set1 );
            }
        }

        return buildTask;
    }

    @Override
    public DefaultBuildTaskRef toNRRBuildTaskRef(RemoteBuildTask request, Long setRecordId) {
        if ( request == null && setRecordId == null ) {
            return null;
        }

        DefaultBuildTaskRef.DefaultBuildTaskRefBuilder defaultBuildTaskRef = DefaultBuildTaskRef.builder();

        if ( request != null ) {
            defaultBuildTaskRef.id( request.getId() );
            defaultBuildTaskRef.temporaryBuild( requestBuildOptionsTemporaryBuild( request ) );
            defaultBuildTaskRef.alignmentPreference( requestBuildOptionsAlignmentPreference( request ) );
            Integer id = requestCurrentProductMilestoneId( request );
            if ( id != null ) {
                defaultBuildTaskRef.productMilestone( iDToReferenceMapper.toProductMilestoneReference( String.valueOf( id ) ) );
            }
            defaultBuildTaskRef.user( userFetcher.toUserReference( request.getUsername() ) );
            List<String> list = request.getDependants();
            if ( list != null ) {
                defaultBuildTaskRef.dependants( new LinkedHashSet<String>( list ) );
            }
            List<String> list1 = request.getDependencies();
            if ( list1 != null ) {
                defaultBuildTaskRef.dependencies( new LinkedHashSet<String>( list1 ) );
            }
            defaultBuildTaskRef.submitTime( request.getSubmitTime() );
            defaultBuildTaskRef.noRebuildCause( BuildTaskMappers.unwrap( request.getNoRebuildCause() ) );
        }
        defaultBuildTaskRef.buildConfigSetRecordId( setRecordId );
        defaultBuildTaskRef.idRev( new IdRev( Integer.valueOf(request.getBuildConfigurationAudited().getId()), request.getBuildConfigurationAudited().getRev() ) );
        defaultBuildTaskRef.status( BuildCoordinationStatus.REJECTED_ALREADY_BUILT );
        defaultBuildTaskRef.contentId( ContentIdentityManager.getBuildContentId(request.getId()) );

        return defaultBuildTaskRef.build();
    }

    @Override
    public BuildMeta toBuildMeta(RemoteBuildTask request) {
        if ( request == null ) {
            return null;
        }

        BuildMeta.BuildMetaBuilder buildMeta = BuildMeta.builder();

        buildMeta.temporaryBuild( requestBuildOptionsTemporaryBuild( request ) );
        buildMeta.alignmentPreference( requestBuildOptionsAlignmentPreference( request ) );
        buildMeta.productMilestoneId( requestCurrentProductMilestoneId( request ) );
        buildMeta.id( request.getId() );
        if ( request.getSubmitTime() != null ) {
            buildMeta.submitTime( Date.from( request.getSubmitTime() ) );
        }
        buildMeta.username( request.getUsername() );
        List<String> list = request.getDependants();
        if ( list != null ) {
            buildMeta.dependants( new ArrayList<String>( list ) );
        }
        List<String> list1 = request.getDependencies();
        if ( list1 != null ) {
            buildMeta.dependencies( new ArrayList<String>( list1 ) );
        }

        buildMeta.idRev( new IdRev( Integer.valueOf(request.getBuildConfigurationAudited().getId()), request.getBuildConfigurationAudited().getRev() ) );
        buildMeta.contentId( ContentIdentityManager.getBuildContentId(request.getId()) );
        buildMeta.noRebuildCauseId( request.getNoRebuildCause().map(r -> r.getId().getId()).orElse(null) );

        return buildMeta.build();
    }

    protected BuildOptions buildTaskRefToBuildOptions(BuildTaskRef buildTaskRef) {
        if ( buildTaskRef == null ) {
            return null;
        }

        BuildOptions buildOptions = new BuildOptions();

        buildOptions.setTemporaryBuild( buildTaskRef.isTemporaryBuild() );
        buildOptions.setAlignmentPreference( buildTaskRef.getAlignmentPreference() );

        return buildOptions;
    }

    protected Set<BuildTask> stringSetToBuildTaskSet(Set<String> set) {
        if ( set == null ) {
            return null;
        }

        Set<BuildTask> set1 = new LinkedHashSet<BuildTask>( Math.max( (int) ( set.size() / .75f ) + 1, 16 ) );
        for ( String string : set ) {
            set1.add( BuildTaskMappers.fromStringId( string ) );
        }

        return set1;
    }

    private boolean requestBuildOptionsTemporaryBuild(RemoteBuildTask remoteBuildTask) {
        if ( remoteBuildTask == null ) {
            return false;
        }
        BuildOptions buildOptions = remoteBuildTask.getBuildOptions();
        if ( buildOptions == null ) {
            return false;
        }
        boolean temporaryBuild = buildOptions.isTemporaryBuild();
        return temporaryBuild;
    }

    private AlignmentPreference requestBuildOptionsAlignmentPreference(RemoteBuildTask remoteBuildTask) {
        if ( remoteBuildTask == null ) {
            return null;
        }
        BuildOptions buildOptions = remoteBuildTask.getBuildOptions();
        if ( buildOptions == null ) {
            return null;
        }
        AlignmentPreference alignmentPreference = buildOptions.getAlignmentPreference();
        if ( alignmentPreference == null ) {
            return null;
        }
        return alignmentPreference;
    }

    private Integer requestCurrentProductMilestoneId(RemoteBuildTask remoteBuildTask) {
        if ( remoteBuildTask == null ) {
            return null;
        }
        ProductMilestone currentProductMilestone = remoteBuildTask.getCurrentProductMilestone();
        if ( currentProductMilestone == null ) {
            return null;
        }
        Integer id = currentProductMilestone.getId();
        if ( id == null ) {
            return null;
        }
        return id;
    }
}
