package org.jboss.pnc.mapper;

import java.util.Date;
import javax.annotation.processing.Generated;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.GroupBuildRef;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.mapper.api.GroupConfigurationMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.BuildConfigSetRecord;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2023-06-20T03:39:00+0000",
    comments = "version: 1.5.3.Final, compiler: javac, environment: Java 11.0.18-ea (Red Hat, Inc.)"
)
@ApplicationScoped
public class GroupBuildMapperImpl implements GroupBuildMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private GroupConfigurationMapper groupConfigurationMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public BuildConfigSetRecord toEntity(GroupBuild dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        BuildConfigSetRecord buildConfigSetRecord = new BuildConfigSetRecord();

        buildConfigSetRecord.setBuildConfigurationSet( refToReferenceMapper.toEntityReference( dtoEntity.getGroupConfig() ) );
        buildConfigSetRecord.setUser( refToReferenceMapper.toEntityReference( dtoEntity.getUser() ) );
        if ( dtoEntity.getId() != null ) {
            buildConfigSetRecord.setId( Long.parseLong( dtoEntity.getId() ) );
        }
        if ( dtoEntity.getStartTime() != null ) {
            buildConfigSetRecord.setStartTime( Date.from( dtoEntity.getStartTime() ) );
        }
        if ( dtoEntity.getEndTime() != null ) {
            buildConfigSetRecord.setEndTime( Date.from( dtoEntity.getEndTime() ) );
        }
        buildConfigSetRecord.setStatus( dtoEntity.getStatus() );
        buildConfigSetRecord.setProductVersion( refToReferenceMapper.toEntityReference( dtoEntity.getProductVersion() ) );
        if ( dtoEntity.getTemporaryBuild() != null ) {
            buildConfigSetRecord.setTemporaryBuild( dtoEntity.getTemporaryBuild() );
        }
        buildConfigSetRecord.setAlignmentPreference( dtoEntity.getAlignmentPreference() );

        return buildConfigSetRecord;
    }

    @Override
    public GroupBuild toDTO(BuildConfigSetRecord dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        GroupBuild.Builder groupBuild = GroupBuild.builder();

        groupBuild.groupConfig( groupConfigurationMapper.toRef( dbEntity.getBuildConfigurationSet() ) );
        groupBuild.user( userMapper.toRef( dbEntity.getUser() ) );
        groupBuild.productVersion( productVersionMapper.toRef( dbEntity.getProductVersion() ) );
        if ( dbEntity.getId() != null ) {
            groupBuild.id( String.valueOf( dbEntity.getId() ) );
        }
        if ( dbEntity.getStartTime() != null ) {
            groupBuild.startTime( dbEntity.getStartTime().toInstant() );
        }
        if ( dbEntity.getEndTime() != null ) {
            groupBuild.endTime( dbEntity.getEndTime().toInstant() );
        }
        groupBuild.status( dbEntity.getStatus() );
        groupBuild.temporaryBuild( dbEntity.isTemporaryBuild() );
        groupBuild.alignmentPreference( dbEntity.getAlignmentPreference() );

        return groupBuild.build();
    }

    @Override
    public GroupBuildRef toRef(BuildConfigSetRecord dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        GroupBuildRef.Builder groupBuildRef = GroupBuildRef.refBuilder();

        if ( dbEntity.getId() != null ) {
            groupBuildRef.id( String.valueOf( dbEntity.getId() ) );
        }
        if ( dbEntity.getStartTime() != null ) {
            groupBuildRef.startTime( dbEntity.getStartTime().toInstant() );
        }
        if ( dbEntity.getEndTime() != null ) {
            groupBuildRef.endTime( dbEntity.getEndTime().toInstant() );
        }
        groupBuildRef.status( dbEntity.getStatus() );
        groupBuildRef.temporaryBuild( dbEntity.isTemporaryBuild() );
        groupBuildRef.alignmentPreference( dbEntity.getAlignmentPreference() );

        return groupBuildRef.build();
    }
}
