package org.jboss.pnc.mapper;

import java.util.Date;
import javax.annotation.processing.Generated;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProductReleaseMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.ProductMilestone;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2023-06-20T03:39:00+0000",
    comments = "version: 1.5.3.Final, compiler: javac, environment: Java 11.0.18-ea (Red Hat, Inc.)"
)
@ApplicationScoped
public class ProductMilestoneMapperImpl implements ProductMilestoneMapper {

    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private ProductReleaseMapper productReleaseMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public ProductMilestone toEntity(org.jboss.pnc.dto.ProductMilestone dtoEntity) {
        if ( dtoEntity == null ) {
            return null;
        }

        ProductMilestone productMilestone = new ProductMilestone();

        if ( dtoEntity.getId() != null ) {
            productMilestone.setId( Integer.parseInt( dtoEntity.getId() ) );
        }
        productMilestone.setVersion( dtoEntity.getVersion() );
        productMilestone.setProductVersion( refToReferenceMapper.toEntityReference( dtoEntity.getProductVersion() ) );
        if ( dtoEntity.getStartingDate() != null ) {
            productMilestone.setStartingDate( Date.from( dtoEntity.getStartingDate() ) );
        }
        if ( dtoEntity.getPlannedEndDate() != null ) {
            productMilestone.setPlannedEndDate( Date.from( dtoEntity.getPlannedEndDate() ) );
        }
        if ( dtoEntity.getEndDate() != null ) {
            productMilestone.setEndDate( Date.from( dtoEntity.getEndDate() ) );
        }
        productMilestone.setProductRelease( refToReferenceMapper.toEntityReference( dtoEntity.getProductRelease() ) );

        productMilestone.setDeliveredArtifactsImporter( userMapper.toEntity(dtoEntity.getDeliveredArtifactsImporter() == null ? dtoEntity.getDistributedArtifactsImporter() : dtoEntity.getDeliveredArtifactsImporter()) );

        return productMilestone;
    }

    @Override
    public void updateEntity(org.jboss.pnc.dto.ProductMilestone dtoEntity, ProductMilestone target) {
        if ( dtoEntity == null ) {
            return;
        }

        target.setVersion( dtoEntity.getVersion() );
        if ( dtoEntity.getStartingDate() != null ) {
            target.setStartingDate( Date.from( dtoEntity.getStartingDate() ) );
        }
        else {
            target.setStartingDate( null );
        }
        if ( dtoEntity.getPlannedEndDate() != null ) {
            target.setPlannedEndDate( Date.from( dtoEntity.getPlannedEndDate() ) );
        }
        else {
            target.setPlannedEndDate( null );
        }
    }

    @Override
    public org.jboss.pnc.dto.ProductMilestone toDTO(ProductMilestone dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        org.jboss.pnc.dto.ProductMilestone.Builder productMilestone = org.jboss.pnc.dto.ProductMilestone.builder();

        productMilestone.productVersion( productVersionMapper.toRef( dbEntity.getProductVersion() ) );
        productMilestone.productRelease( productReleaseMapper.toRef( dbEntity.getProductRelease() ) );
        productMilestone.distributedArtifactsImporter( userMapper.toDTO( dbEntity.getDeliveredArtifactsImporter() ) );
        productMilestone.deliveredArtifactsImporter( userMapper.toDTO( dbEntity.getDeliveredArtifactsImporter() ) );
        if ( dbEntity.getId() != null ) {
            productMilestone.id( String.valueOf( dbEntity.getId() ) );
        }
        productMilestone.version( dbEntity.getVersion() );
        if ( dbEntity.getEndDate() != null ) {
            productMilestone.endDate( dbEntity.getEndDate().toInstant() );
        }
        if ( dbEntity.getStartingDate() != null ) {
            productMilestone.startingDate( dbEntity.getStartingDate().toInstant() );
        }
        if ( dbEntity.getPlannedEndDate() != null ) {
            productMilestone.plannedEndDate( dbEntity.getPlannedEndDate().toInstant() );
        }

        return productMilestone.build();
    }

    @Override
    public ProductMilestoneRef toRef(ProductMilestone dbEntity) {
        if ( dbEntity == null ) {
            return null;
        }

        ProductMilestoneRef.Builder productMilestoneRef = ProductMilestoneRef.refBuilder();

        if ( dbEntity.getId() != null ) {
            productMilestoneRef.id( String.valueOf( dbEntity.getId() ) );
        }
        productMilestoneRef.version( dbEntity.getVersion() );
        if ( dbEntity.getEndDate() != null ) {
            productMilestoneRef.endDate( dbEntity.getEndDate().toInstant() );
        }
        if ( dbEntity.getStartingDate() != null ) {
            productMilestoneRef.startingDate( dbEntity.getStartingDate().toInstant() );
        }
        if ( dbEntity.getPlannedEndDate() != null ) {
            productMilestoneRef.plannedEndDate( dbEntity.getPlannedEndDate().toInstant() );
        }

        return productMilestoneRef.build();
    }
}
