/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildConfigurationRevision;
import org.jboss.pnc.dto.BuildConfigurationRevisionRef;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.IdRev;

@ApplicationScoped
public class BuildConfigurationRevisionMapperImpl
implements BuildConfigurationRevisionMapper {
    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProjectMapper projectMapper;
    @Inject
    private EnvironmentMapper environmentMapper;
    @Inject
    private SCMRepositoryMapper sCMRepositoryMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public BuildConfigurationRevision toDTO(BuildConfigurationAudited dbEntity) {
        Map map;
        if (dbEntity == null) {
            return null;
        }
        BuildConfigurationRevision.Builder buildConfigurationRevision = BuildConfigurationRevision.builder();
        buildConfigurationRevision.scmRepository(this.sCMRepositoryMapper.toRef(dbEntity.getRepositoryConfiguration()));
        buildConfigurationRevision.environment(this.environmentMapper.toRef(dbEntity.getBuildEnvironment()));
        buildConfigurationRevision.project(this.projectMapper.toRef(dbEntity.getProject()));
        if (dbEntity.getLastModificationTime() != null) {
            buildConfigurationRevision.modificationTime(dbEntity.getLastModificationTime().toInstant());
        }
        if ((map = dbEntity.getGenericParameters()) != null) {
            buildConfigurationRevision.parameters(new LinkedHashMap(map));
        }
        buildConfigurationRevision.creationUser(this.userMapper.toRef(dbEntity.getCreationUser()));
        buildConfigurationRevision.modificationUser(this.userMapper.toRef(dbEntity.getLastModificationUser()));
        buildConfigurationRevision.rev(dbEntity.getRev());
        buildConfigurationRevision.name(dbEntity.getName());
        buildConfigurationRevision.buildScript(dbEntity.getBuildScript());
        buildConfigurationRevision.scmRevision(dbEntity.getScmRevision());
        if (dbEntity.getCreationTime() != null) {
            buildConfigurationRevision.creationTime(dbEntity.getCreationTime().toInstant());
        }
        buildConfigurationRevision.buildType(dbEntity.getBuildType());
        buildConfigurationRevision.defaultAlignmentParams(dbEntity.getDefaultAlignmentParams());
        buildConfigurationRevision.brewPullActive(dbEntity.isBrewPullActive());
        buildConfigurationRevision.id(dbEntity.getId().toString());
        return buildConfigurationRevision.build();
    }

    @Override
    public BuildConfigurationAudited toEntity(BuildConfigurationRevision dtoEntity) {
        Map map;
        if (dtoEntity == null) {
            return null;
        }
        BuildConfigurationAudited buildConfigurationAudited = new BuildConfigurationAudited();
        buildConfigurationAudited.setRepositoryConfiguration(this.refToReferenceMapper.toEntityReference(dtoEntity.getScmRepository()));
        buildConfigurationAudited.setBuildEnvironment(this.refToReferenceMapper.toEntityReference(dtoEntity.getEnvironment()));
        if (dtoEntity.getModificationTime() != null) {
            buildConfigurationAudited.setLastModificationTime(Date.from(dtoEntity.getModificationTime()));
        }
        if ((map = dtoEntity.getParameters()) != null) {
            buildConfigurationAudited.setGenericParameters(new LinkedHashMap(map));
        }
        buildConfigurationAudited.setCreationUser(this.refToReferenceMapper.toEntityReference(dtoEntity.getCreationUser()));
        buildConfigurationAudited.setLastModificationUser(this.refToReferenceMapper.toEntityReference(dtoEntity.getModificationUser()));
        if (dtoEntity.getId() != null) {
            buildConfigurationAudited.setId(Integer.valueOf(Integer.parseInt(dtoEntity.getId())));
        }
        buildConfigurationAudited.setRev(dtoEntity.getRev());
        buildConfigurationAudited.setName(dtoEntity.getName());
        buildConfigurationAudited.setBuildScript(dtoEntity.getBuildScript());
        buildConfigurationAudited.setScmRevision(dtoEntity.getScmRevision());
        buildConfigurationAudited.setProject(this.refToReferenceMapper.toEntityReference(dtoEntity.getProject()));
        buildConfigurationAudited.setBuildType(dtoEntity.getBuildType());
        if (dtoEntity.getCreationTime() != null) {
            buildConfigurationAudited.setCreationTime(Date.from(dtoEntity.getCreationTime()));
        }
        buildConfigurationAudited.setDefaultAlignmentParams(dtoEntity.getDefaultAlignmentParams());
        buildConfigurationAudited.setBrewPullActive(dtoEntity.isBrewPullActive());
        buildConfigurationAudited.setIdRev(new IdRev(Integer.valueOf(dtoEntity.getId()), dtoEntity.getRev()));
        return buildConfigurationAudited;
    }

    @Override
    public BuildConfigurationRevisionRef toRef(BuildConfigurationAudited dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        BuildConfigurationRevisionRef.Builder buildConfigurationRevisionRef = BuildConfigurationRevisionRef.refBuilder();
        if (dbEntity.getLastModificationTime() != null) {
            buildConfigurationRevisionRef.modificationTime(dbEntity.getLastModificationTime().toInstant());
        }
        buildConfigurationRevisionRef.rev(dbEntity.getRev());
        buildConfigurationRevisionRef.name(dbEntity.getName());
        buildConfigurationRevisionRef.buildScript(dbEntity.getBuildScript());
        buildConfigurationRevisionRef.scmRevision(dbEntity.getScmRevision());
        if (dbEntity.getCreationTime() != null) {
            buildConfigurationRevisionRef.creationTime(dbEntity.getCreationTime().toInstant());
        }
        buildConfigurationRevisionRef.buildType(dbEntity.getBuildType());
        buildConfigurationRevisionRef.defaultAlignmentParams(dbEntity.getDefaultAlignmentParams());
        buildConfigurationRevisionRef.brewPullActive(dbEntity.isBrewPullActive());
        buildConfigurationRevisionRef.id(dbEntity.getId().toString());
        return buildConfigurationRevisionRef.build();
    }
}

