/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.BuildPushResult;
import org.jboss.pnc.dto.BuildPushResultRef;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.BuildPushResultMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneCloseResultMapper;
import org.jboss.pnc.model.BuildRecordPushResult;

@ApplicationScoped
public class BuildPushResultMapperImpl
implements BuildPushResultMapper {
    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductMilestoneCloseResultMapper productMilestoneCloseResultMapper;

    @Override
    public BuildPushResult toDTO(BuildRecordPushResult db) {
        if (db == null) {
            return null;
        }
        BuildPushResult.Builder buildPushResult = BuildPushResult.builder();
        buildPushResult.buildId(BuildMapper.IDMapper.toDtoId(db.getBuildRecord()));
        buildPushResult.productMilestoneCloseResult(this.productMilestoneCloseResultMapper.toRef(db.getProductMilestoneRelease()));
        if (db.getId() != null) {
            buildPushResult.id(String.valueOf(db.getId()));
        }
        buildPushResult.status(db.getStatus());
        buildPushResult.brewBuildId(db.getBrewBuildId());
        buildPushResult.brewBuildUrl(db.getBrewBuildUrl());
        buildPushResult.logContext(this.logContext(db));
        return buildPushResult.build();
    }

    @Override
    public BuildPushResultRef toRef(BuildRecordPushResult db) {
        if (db == null) {
            return null;
        }
        BuildPushResultRef.Builder buildPushResultRef = BuildPushResultRef.refBuilder();
        buildPushResultRef.buildId(BuildMapper.IDMapper.toDtoId(db.getBuildRecord()));
        if (db.getId() != null) {
            buildPushResultRef.id(String.valueOf(db.getId()));
        }
        buildPushResultRef.status(db.getStatus());
        buildPushResultRef.brewBuildId(db.getBrewBuildId());
        buildPushResultRef.brewBuildUrl(db.getBrewBuildUrl());
        buildPushResultRef.logContext(this.logContext(db));
        return buildPushResultRef.build();
    }

    @Override
    public BuildRecordPushResult toEntity(BuildPushResult dto) {
        if (dto == null) {
            return null;
        }
        BuildRecordPushResult.Builder buildRecordPushResult = BuildRecordPushResult.newBuilder();
        buildRecordPushResult.buildRecord(BuildMapper.IDMapper.toIdEntity(dto.getBuildId()));
        buildRecordPushResult.productMilestoneRelease(this.refToReferenceMapper.toEntityReference(dto.getProductMilestoneCloseResult()));
        if (dto.getId() != null) {
            buildRecordPushResult.id(Long.valueOf(Long.parseLong(dto.getId())));
        }
        buildRecordPushResult.status(dto.getStatus());
        buildRecordPushResult.brewBuildId(dto.getBrewBuildId());
        buildRecordPushResult.brewBuildUrl(dto.getBrewBuildUrl());
        return buildRecordPushResult.build();
    }
}

