/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.api.enums.AlignmentPreference;
import org.jboss.pnc.enums.BuildCoordinationStatus;
import org.jboss.pnc.mapper.IDToReferenceMapper;
import org.jboss.pnc.mapper.UserFetcher;
import org.jboss.pnc.mapper.api.BuildTaskMappers;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.User;
import org.jboss.pnc.model.utils.ContentIdentityManager;
import org.jboss.pnc.rex.dto.TaskDTO;
import org.jboss.pnc.rex.model.requests.MinimizedTask;
import org.jboss.pnc.spi.BuildOptions;
import org.jboss.pnc.spi.coordinator.BuildMeta;
import org.jboss.pnc.spi.coordinator.BuildSetTask;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.coordinator.BuildTaskRef;
import org.jboss.pnc.spi.coordinator.DefaultBuildTaskRef;
import org.jboss.pnc.spi.coordinator.RemoteBuildTask;

@ApplicationScoped
public class BuildTaskMappersImpl
implements BuildTaskMappers {
    @Inject
    private UserFetcher userFetcher;
    @Inject
    private IDToReferenceMapper iDToReferenceMapper;

    @Override
    public DefaultBuildTaskRef toBuildTaskRef(TaskDTO task, BuildMeta meta) {
        if (task == null && meta == null) {
            return null;
        }
        DefaultBuildTaskRef.Builder defaultBuildTaskRef = DefaultBuildTaskRef.builder();
        this.fillStartAndEndTime(task, defaultBuildTaskRef);
        if (task != null) {
            Set set1;
            Set set;
            defaultBuildTaskRef.id(task.getName());
            defaultBuildTaskRef.idRev(BuildTaskMappers.fromConstraint(task.getConstraint()));
            if (task.getCorrelationID() != null) {
                defaultBuildTaskRef.buildConfigSetRecordId(Long.valueOf(Long.parseLong(task.getCorrelationID())));
            }
            if ((set = task.getDependants()) != null) {
                defaultBuildTaskRef.taskDependants(new LinkedHashSet(set));
            }
            if ((set1 = task.getDependencies()) != null) {
                defaultBuildTaskRef.taskDependencies(new LinkedHashSet(set1));
            }
        }
        if (meta != null) {
            List list1;
            if (meta.getProductMilestoneId() != null) {
                defaultBuildTaskRef.productMilestone(this.iDToReferenceMapper.toProductMilestoneReference(String.valueOf(meta.getProductMilestoneId())));
            }
            if (meta.getSubmitTime() != null) {
                defaultBuildTaskRef.submitTime(meta.getSubmitTime().toInstant());
            }
            defaultBuildTaskRef.user(this.userFetcher.toUserReference(meta.getUsername()));
            defaultBuildTaskRef.noRebuildCause(this.iDToReferenceMapper.toBuildRecordReference(meta.getNoRebuildCauseId()));
            List list = meta.getDependants();
            if (list != null) {
                defaultBuildTaskRef.dependants(new LinkedHashSet(list));
            }
            if ((list1 = meta.getDependencies()) != null) {
                defaultBuildTaskRef.dependencies(new LinkedHashSet(list1));
            }
            defaultBuildTaskRef.contentId(meta.getContentId());
            defaultBuildTaskRef.temporaryBuild(meta.isTemporaryBuild());
            defaultBuildTaskRef.alignmentPreference(meta.getAlignmentPreference());
        }
        defaultBuildTaskRef.status(BuildTaskMappers.toBuildStatus(task.getState(), task.getStopFlag()));
        return defaultBuildTaskRef.build();
    }

    @Override
    public DefaultBuildTaskRef toBuildTaskRef(MinimizedTask task, BuildMeta meta) {
        if (task == null && meta == null) {
            return null;
        }
        DefaultBuildTaskRef.Builder defaultBuildTaskRef = DefaultBuildTaskRef.builder();
        this.fillStartAndEndTime(task, defaultBuildTaskRef);
        if (task != null) {
            Set set1;
            Set set;
            defaultBuildTaskRef.id(task.getName());
            defaultBuildTaskRef.idRev(BuildTaskMappers.fromConstraint(task.getConstraint()));
            if (task.getCorrelationID() != null) {
                defaultBuildTaskRef.buildConfigSetRecordId(Long.valueOf(Long.parseLong(task.getCorrelationID())));
            }
            if ((set = task.getDependants()) != null) {
                defaultBuildTaskRef.taskDependants(new LinkedHashSet(set));
            }
            if ((set1 = task.getDependencies()) != null) {
                defaultBuildTaskRef.taskDependencies(new LinkedHashSet(set1));
            }
        }
        if (meta != null) {
            List list1;
            if (meta.getProductMilestoneId() != null) {
                defaultBuildTaskRef.productMilestone(this.iDToReferenceMapper.toProductMilestoneReference(String.valueOf(meta.getProductMilestoneId())));
            }
            if (meta.getSubmitTime() != null) {
                defaultBuildTaskRef.submitTime(meta.getSubmitTime().toInstant());
            }
            defaultBuildTaskRef.user(this.userFetcher.toUserReference(meta.getUsername()));
            defaultBuildTaskRef.noRebuildCause(this.iDToReferenceMapper.toBuildRecordReference(meta.getNoRebuildCauseId()));
            List list = meta.getDependants();
            if (list != null) {
                defaultBuildTaskRef.dependants(new LinkedHashSet(list));
            }
            if ((list1 = meta.getDependencies()) != null) {
                defaultBuildTaskRef.dependencies(new LinkedHashSet(list1));
            }
            defaultBuildTaskRef.contentId(meta.getContentId());
            defaultBuildTaskRef.temporaryBuild(meta.isTemporaryBuild());
            defaultBuildTaskRef.alignmentPreference(meta.getAlignmentPreference());
        }
        defaultBuildTaskRef.status(BuildTaskMappers.toBuildStatus(task.getState(), task.getStopFlag()));
        return defaultBuildTaskRef.build();
    }

    @Override
    public BuildTask toBuildTask(BuildTaskRef remoteTaskRef) {
        Set<BuildTask> set1;
        Set<BuildTask> set;
        if (remoteTaskRef == null) {
            return null;
        }
        BuildOptions buildOptions = null;
        BuildConfigurationAudited buildConfigurationAudited = null;
        Long buildConfigSetRecordId = null;
        User user = null;
        Date submitTime = null;
        String id = null;
        ProductMilestone productMilestone = null;
        String contentId = null;
        buildOptions = this.buildTaskRefToBuildOptions(remoteTaskRef);
        buildConfigurationAudited = this.iDToReferenceMapper.toBCAReference(remoteTaskRef.getIdRev());
        buildConfigSetRecordId = remoteTaskRef.getBuildConfigSetRecordId();
        user = remoteTaskRef.getUser();
        if (remoteTaskRef.getSubmitTime() != null) {
            submitTime = Date.from(remoteTaskRef.getSubmitTime());
        }
        id = remoteTaskRef.getId();
        productMilestone = remoteTaskRef.getProductMilestone();
        contentId = remoteTaskRef.getContentId();
        BuildSetTask buildSetTask = null;
        String requestContext = null;
        BuildTask buildTask = new BuildTask(buildConfigurationAudited, buildOptions, user, submitTime, buildSetTask, id, buildConfigSetRecordId, productMilestone, contentId, requestContext);
        if (remoteTaskRef.getStartTime() != null) {
            buildTask.setStartTime(Date.from(remoteTaskRef.getStartTime()));
        }
        if (remoteTaskRef.getEndTime() != null) {
            buildTask.setEndTime(Date.from(remoteTaskRef.getEndTime()));
        }
        buildTask.setStatus(remoteTaskRef.getStatus());
        buildTask.setNoRebuildCause(remoteTaskRef.getNoRebuildCause());
        if (buildTask.getDependants() != null && (set = this.stringSetToBuildTaskSet(remoteTaskRef.getDependants())) != null) {
            buildTask.getDependants().addAll(set);
        }
        if (buildTask.getDependencies() != null && (set1 = this.stringSetToBuildTaskSet(remoteTaskRef.getDependencies())) != null) {
            buildTask.getDependencies().addAll(set1);
        }
        return buildTask;
    }

    @Override
    public DefaultBuildTaskRef toNRRBuildTaskRef(RemoteBuildTask request, Long setRecordId) {
        if (request == null && setRecordId == null) {
            return null;
        }
        DefaultBuildTaskRef.Builder defaultBuildTaskRef = DefaultBuildTaskRef.builder();
        if (request != null) {
            List list1;
            defaultBuildTaskRef.id(request.getId());
            defaultBuildTaskRef.temporaryBuild(this.requestBuildOptionsTemporaryBuild(request));
            defaultBuildTaskRef.alignmentPreference(this.requestBuildOptionsAlignmentPreference(request));
            Integer id = this.requestCurrentProductMilestoneId(request);
            if (id != null) {
                defaultBuildTaskRef.productMilestone(this.iDToReferenceMapper.toProductMilestoneReference(String.valueOf(id)));
            }
            defaultBuildTaskRef.user(this.userFetcher.toUserReference(request.getUsername()));
            List list = request.getDependants();
            if (list != null) {
                defaultBuildTaskRef.dependants(new LinkedHashSet(list));
            }
            if ((list1 = request.getDependencies()) != null) {
                defaultBuildTaskRef.dependencies(new LinkedHashSet(list1));
            }
            defaultBuildTaskRef.submitTime(request.getSubmitTime());
            defaultBuildTaskRef.noRebuildCause((BuildRecord)BuildTaskMappers.unwrap(request.getNoRebuildCause()));
        }
        defaultBuildTaskRef.buildConfigSetRecordId(setRecordId);
        defaultBuildTaskRef.idRev(new IdRev(Integer.valueOf(request.getBuildConfigurationAudited().getId()), request.getBuildConfigurationAudited().getRev()));
        defaultBuildTaskRef.status(BuildCoordinationStatus.REJECTED_ALREADY_BUILT);
        defaultBuildTaskRef.contentId(ContentIdentityManager.getBuildContentId((String)request.getId()));
        return defaultBuildTaskRef.build();
    }

    @Override
    public BuildMeta toBuildMeta(RemoteBuildTask request) {
        List list1;
        if (request == null) {
            return null;
        }
        BuildMeta.BuildMetaBuilder buildMeta = BuildMeta.builder();
        buildMeta.temporaryBuild(this.requestBuildOptionsTemporaryBuild(request));
        buildMeta.alignmentPreference(this.requestBuildOptionsAlignmentPreference(request));
        buildMeta.productMilestoneId(this.requestCurrentProductMilestoneId(request));
        buildMeta.id(request.getId());
        if (request.getSubmitTime() != null) {
            buildMeta.submitTime(Date.from(request.getSubmitTime()));
        }
        buildMeta.username(request.getUsername());
        List list = request.getDependants();
        if (list != null) {
            buildMeta.dependants(new ArrayList(list));
        }
        if ((list1 = request.getDependencies()) != null) {
            buildMeta.dependencies(new ArrayList(list1));
        }
        buildMeta.idRev(new IdRev(Integer.valueOf(request.getBuildConfigurationAudited().getId()), request.getBuildConfigurationAudited().getRev()));
        buildMeta.contentId(ContentIdentityManager.getBuildContentId((String)request.getId()));
        buildMeta.noRebuildCauseId((String)request.getNoRebuildCause().map(r -> r.getId().getId()).orElse(null));
        return buildMeta.build();
    }

    protected BuildOptions buildTaskRefToBuildOptions(BuildTaskRef buildTaskRef) {
        if (buildTaskRef == null) {
            return null;
        }
        BuildOptions buildOptions = new BuildOptions();
        buildOptions.setTemporaryBuild(buildTaskRef.isTemporaryBuild());
        buildOptions.setAlignmentPreference(buildTaskRef.getAlignmentPreference());
        return buildOptions;
    }

    protected Set<BuildTask> stringSetToBuildTaskSet(Set<String> set) {
        if (set == null) {
            return null;
        }
        LinkedHashSet<BuildTask> set1 = new LinkedHashSet<BuildTask>(Math.max((int)((float)set.size() / 0.75f) + 1, 16));
        for (String string : set) {
            set1.add(BuildTaskMappers.fromStringId(string));
        }
        return set1;
    }

    private boolean requestBuildOptionsTemporaryBuild(RemoteBuildTask remoteBuildTask) {
        if (remoteBuildTask == null) {
            return false;
        }
        BuildOptions buildOptions = remoteBuildTask.getBuildOptions();
        if (buildOptions == null) {
            return false;
        }
        boolean temporaryBuild = buildOptions.isTemporaryBuild();
        return temporaryBuild;
    }

    private AlignmentPreference requestBuildOptionsAlignmentPreference(RemoteBuildTask remoteBuildTask) {
        if (remoteBuildTask == null) {
            return null;
        }
        BuildOptions buildOptions = remoteBuildTask.getBuildOptions();
        if (buildOptions == null) {
            return null;
        }
        AlignmentPreference alignmentPreference = buildOptions.getAlignmentPreference();
        if (alignmentPreference == null) {
            return null;
        }
        return alignmentPreference;
    }

    private Integer requestCurrentProductMilestoneId(RemoteBuildTask remoteBuildTask) {
        if (remoteBuildTask == null) {
            return null;
        }
        ProductMilestone currentProductMilestone = remoteBuildTask.getCurrentProductMilestone();
        if (currentProductMilestone == null) {
            return null;
        }
        Integer id = currentProductMilestone.getId();
        if (id == null) {
            return null;
        }
        return id;
    }
}

