/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.DeliverableAnalyzerOperation;
import org.jboss.pnc.dto.OperationRef;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerOperationMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.UserMapper;

@ApplicationScoped
public class DeliverableAnalyzerOperationMapperImpl
implements DeliverableAnalyzerOperationMapper {
    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private UserMapper userMapper;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;

    @Override
    public DeliverableAnalyzerOperation toDTO(org.jboss.pnc.model.DeliverableAnalyzerOperation dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        DeliverableAnalyzerOperation.DeliverableAnalyzerOperationBuilder deliverableAnalyzerOperation = DeliverableAnalyzerOperation.delAnalyzerBuilder();
        deliverableAnalyzerOperation.productMilestone(this.productMilestoneMapper.toRef(dbEntity.getProductMilestone()));
        deliverableAnalyzerOperation.user(this.userMapper.toRef(dbEntity.getUser()));
        Map map = dbEntity.getOperationParameters();
        if (map != null) {
            deliverableAnalyzerOperation.parameters(new LinkedHashMap(map));
        }
        if (dbEntity.getSubmitTime() != null) {
            deliverableAnalyzerOperation.submitTime(dbEntity.getSubmitTime().toInstant());
        }
        if (dbEntity.getStartTime() != null) {
            deliverableAnalyzerOperation.startTime(dbEntity.getStartTime().toInstant());
        }
        if (dbEntity.getEndTime() != null) {
            deliverableAnalyzerOperation.endTime(dbEntity.getEndTime().toInstant());
        }
        deliverableAnalyzerOperation.progressStatus(dbEntity.getProgressStatus());
        deliverableAnalyzerOperation.result(dbEntity.getResult());
        deliverableAnalyzerOperation.id(this.getIdMapper().toDto(dbEntity.getId()));
        return deliverableAnalyzerOperation.build();
    }

    @Override
    public OperationRef toRef(org.jboss.pnc.model.DeliverableAnalyzerOperation dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        OperationRef.OperationRefBuilder operationRef = OperationRef.refBuilder();
        if (dbEntity.getSubmitTime() != null) {
            operationRef.submitTime(dbEntity.getSubmitTime().toInstant());
        }
        if (dbEntity.getStartTime() != null) {
            operationRef.startTime(dbEntity.getStartTime().toInstant());
        }
        if (dbEntity.getEndTime() != null) {
            operationRef.endTime(dbEntity.getEndTime().toInstant());
        }
        operationRef.progressStatus(dbEntity.getProgressStatus());
        operationRef.result(dbEntity.getResult());
        operationRef.id(this.getIdMapper().toDto(dbEntity.getId()));
        return operationRef.build();
    }

    @Override
    public org.jboss.pnc.model.DeliverableAnalyzerOperation toEntity(DeliverableAnalyzerOperation dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        org.jboss.pnc.model.DeliverableAnalyzerOperation deliverableAnalyzerOperation = new org.jboss.pnc.model.DeliverableAnalyzerOperation();
        deliverableAnalyzerOperation.setUser(this.refToReferenceMapper.toEntityReference(dtoEntity.getUser()));
        Map map = dtoEntity.getParameters();
        if (map != null) {
            deliverableAnalyzerOperation.setOperationParameters(new LinkedHashMap(map));
        }
        if (dtoEntity.getSubmitTime() != null) {
            deliverableAnalyzerOperation.setSubmitTime(Date.from(dtoEntity.getSubmitTime()));
        }
        if (dtoEntity.getStartTime() != null) {
            deliverableAnalyzerOperation.setStartTime(Date.from(dtoEntity.getStartTime()));
        }
        if (dtoEntity.getEndTime() != null) {
            deliverableAnalyzerOperation.setEndTime(Date.from(dtoEntity.getEndTime()));
        }
        deliverableAnalyzerOperation.setProgressStatus(dtoEntity.getProgressStatus());
        deliverableAnalyzerOperation.setResult(dtoEntity.getResult());
        deliverableAnalyzerOperation.setId(this.getIdMapper().toEntity(dtoEntity.getId()));
        return deliverableAnalyzerOperation;
    }

    @Override
    public void updateEntity(DeliverableAnalyzerOperation dtoEntity, org.jboss.pnc.model.DeliverableAnalyzerOperation target) {
        if (dtoEntity == null) {
            return;
        }
        if (dtoEntity.getSubmitTime() != null) {
            target.setSubmitTime(Date.from(dtoEntity.getSubmitTime()));
        } else {
            target.setSubmitTime(null);
        }
        if (dtoEntity.getEndTime() != null) {
            target.setEndTime(Date.from(dtoEntity.getEndTime()));
        } else {
            target.setEndTime(null);
        }
        target.setProgressStatus(dtoEntity.getProgressStatus());
        target.setResult(dtoEntity.getResult());
    }
}

