/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import java.util.EnumSet;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.DeliverableAnalyzerReport;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.mapper.UrlsListAndOperationParametersConverter;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerReportMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.DeliverableAnalyzerOperation;
import org.jboss.pnc.model.DeliverableAnalyzerReport;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.User;

@ApplicationScoped
public class DeliverableAnalyzerReportMapperImpl
implements DeliverableAnalyzerReportMapper {
    @Inject
    private UserMapper userMapper;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;

    @Override
    public DeliverableAnalyzerReport toEntity(org.jboss.pnc.dto.DeliverableAnalyzerReport dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        DeliverableAnalyzerReport.Builder deliverableAnalyzerReport = DeliverableAnalyzerReport.builder();
        deliverableAnalyzerReport.operation(this.deliverableAnalyzerReportToDeliverableAnalyzerOperation(dtoEntity));
        EnumSet enumSet = dtoEntity.getLabels();
        if (enumSet != null) {
            deliverableAnalyzerReport.labels(EnumSet.copyOf(enumSet));
        }
        deliverableAnalyzerReport.id(this.getIdMapper().toEntity(dtoEntity.getId()));
        return deliverableAnalyzerReport.build();
    }

    @Override
    public org.jboss.pnc.dto.DeliverableAnalyzerReport toDTO(DeliverableAnalyzerReport dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        DeliverableAnalyzerReport.DeliverableAnalyzerReportBuilder deliverableAnalyzerReport = org.jboss.pnc.dto.DeliverableAnalyzerReport.builder();
        deliverableAnalyzerReport.submitTime(this.dbEntityOperationSubmitTime(dbEntity));
        deliverableAnalyzerReport.startTime(this.dbEntityOperationStartTime(dbEntity));
        deliverableAnalyzerReport.endTime(this.dbEntityOperationEndTime(dbEntity));
        deliverableAnalyzerReport.user(this.userMapper.toDTO(this.dbEntityOperationUser(dbEntity)));
        deliverableAnalyzerReport.productMilestone(this.productMilestoneMapper.toRef(this.dbEntityOperationProductMilestone(dbEntity)));
        EnumSet enumSet = dbEntity.getLabels();
        if (enumSet != null) {
            deliverableAnalyzerReport.labels(EnumSet.copyOf(enumSet));
        }
        deliverableAnalyzerReport.id(this.getIdMapper().toDto(dbEntity.getId()));
        deliverableAnalyzerReport.urls(UrlsListAndOperationParametersConverter.urlSetFromOperationParameters(dbEntity.getOperation().getOperationParameters()));
        return deliverableAnalyzerReport.build();
    }

    protected ProductMilestone productMilestoneRefToProductMilestone(ProductMilestoneRef productMilestoneRef) {
        if (productMilestoneRef == null) {
            return null;
        }
        ProductMilestone productMilestone = new ProductMilestone();
        if (productMilestoneRef.getId() != null) {
            productMilestone.setId(Integer.valueOf(Integer.parseInt(productMilestoneRef.getId())));
        }
        productMilestone.setVersion(productMilestoneRef.getVersion());
        if (productMilestoneRef.getStartingDate() != null) {
            productMilestone.setStartingDate(Date.from(productMilestoneRef.getStartingDate()));
        }
        if (productMilestoneRef.getPlannedEndDate() != null) {
            productMilestone.setPlannedEndDate(Date.from(productMilestoneRef.getPlannedEndDate()));
        }
        if (productMilestoneRef.getEndDate() != null) {
            productMilestone.setEndDate(Date.from(productMilestoneRef.getEndDate()));
        }
        return productMilestone;
    }

    protected DeliverableAnalyzerOperation deliverableAnalyzerReportToDeliverableAnalyzerOperation(org.jboss.pnc.dto.DeliverableAnalyzerReport deliverableAnalyzerReport) {
        if (deliverableAnalyzerReport == null) {
            return null;
        }
        DeliverableAnalyzerOperation deliverableAnalyzerOperation = new DeliverableAnalyzerOperation();
        deliverableAnalyzerOperation.setProductMilestone(this.productMilestoneRefToProductMilestone(deliverableAnalyzerReport.getProductMilestone()));
        deliverableAnalyzerOperation.setSubmitTime(deliverableAnalyzerReport.getSubmitTime());
        deliverableAnalyzerOperation.setStartTime(deliverableAnalyzerReport.getStartTime());
        deliverableAnalyzerOperation.setEndTime(deliverableAnalyzerReport.getEndTime());
        deliverableAnalyzerOperation.setUser(this.userMapper.toEntity(deliverableAnalyzerReport.getUser()));
        deliverableAnalyzerOperation.setOperationParameters(UrlsListAndOperationParametersConverter.operationParametersFromUrlSet(deliverableAnalyzerReport.getUrls()));
        return deliverableAnalyzerOperation;
    }

    private Date dbEntityOperationSubmitTime(DeliverableAnalyzerReport deliverableAnalyzerReport) {
        if (deliverableAnalyzerReport == null) {
            return null;
        }
        DeliverableAnalyzerOperation operation = deliverableAnalyzerReport.getOperation();
        if (operation == null) {
            return null;
        }
        Date submitTime = operation.getSubmitTime();
        if (submitTime == null) {
            return null;
        }
        return submitTime;
    }

    private Date dbEntityOperationStartTime(DeliverableAnalyzerReport deliverableAnalyzerReport) {
        if (deliverableAnalyzerReport == null) {
            return null;
        }
        DeliverableAnalyzerOperation operation = deliverableAnalyzerReport.getOperation();
        if (operation == null) {
            return null;
        }
        Date startTime = operation.getStartTime();
        if (startTime == null) {
            return null;
        }
        return startTime;
    }

    private Date dbEntityOperationEndTime(DeliverableAnalyzerReport deliverableAnalyzerReport) {
        if (deliverableAnalyzerReport == null) {
            return null;
        }
        DeliverableAnalyzerOperation operation = deliverableAnalyzerReport.getOperation();
        if (operation == null) {
            return null;
        }
        Date endTime = operation.getEndTime();
        if (endTime == null) {
            return null;
        }
        return endTime;
    }

    private User dbEntityOperationUser(DeliverableAnalyzerReport deliverableAnalyzerReport) {
        if (deliverableAnalyzerReport == null) {
            return null;
        }
        DeliverableAnalyzerOperation operation = deliverableAnalyzerReport.getOperation();
        if (operation == null) {
            return null;
        }
        User user = operation.getUser();
        if (user == null) {
            return null;
        }
        return user;
    }

    private ProductMilestone dbEntityOperationProductMilestone(DeliverableAnalyzerReport deliverableAnalyzerReport) {
        if (deliverableAnalyzerReport == null) {
            return null;
        }
        DeliverableAnalyzerOperation operation = deliverableAnalyzerReport.getOperation();
        if (operation == null) {
            return null;
        }
        ProductMilestone productMilestone = operation.getProductMilestone();
        if (productMilestone == null) {
            return null;
        }
        return productMilestone;
    }
}

