/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.GroupBuildRef;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.mapper.api.GroupConfigurationMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.BuildConfigSetRecord;

@ApplicationScoped
public class GroupBuildMapperImpl
implements GroupBuildMapper {
    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductVersionMapper productVersionMapper;
    @Inject
    private GroupConfigurationMapper groupConfigurationMapper;
    @Inject
    private UserMapper userMapper;

    @Override
    public BuildConfigSetRecord toEntity(GroupBuild dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        BuildConfigSetRecord buildConfigSetRecord = new BuildConfigSetRecord();
        buildConfigSetRecord.setBuildConfigurationSet(this.refToReferenceMapper.toEntityReference(dtoEntity.getGroupConfig()));
        buildConfigSetRecord.setUser(this.refToReferenceMapper.toEntityReference(dtoEntity.getUser()));
        if (dtoEntity.getId() != null) {
            buildConfigSetRecord.setId(Long.valueOf(Long.parseLong(dtoEntity.getId())));
        }
        if (dtoEntity.getStartTime() != null) {
            buildConfigSetRecord.setStartTime(Date.from(dtoEntity.getStartTime()));
        }
        if (dtoEntity.getEndTime() != null) {
            buildConfigSetRecord.setEndTime(Date.from(dtoEntity.getEndTime()));
        }
        buildConfigSetRecord.setStatus(dtoEntity.getStatus());
        buildConfigSetRecord.setProductVersion(this.refToReferenceMapper.toEntityReference(dtoEntity.getProductVersion()));
        if (dtoEntity.getTemporaryBuild() != null) {
            buildConfigSetRecord.setTemporaryBuild(dtoEntity.getTemporaryBuild().booleanValue());
        }
        buildConfigSetRecord.setAlignmentPreference(dtoEntity.getAlignmentPreference());
        return buildConfigSetRecord;
    }

    @Override
    public GroupBuild toDTO(BuildConfigSetRecord dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        GroupBuild.Builder groupBuild = GroupBuild.builder();
        groupBuild.groupConfig(this.groupConfigurationMapper.toRef(dbEntity.getBuildConfigurationSet()));
        groupBuild.user(this.userMapper.toRef(dbEntity.getUser()));
        groupBuild.productVersion(this.productVersionMapper.toRef(dbEntity.getProductVersion()));
        if (dbEntity.getId() != null) {
            groupBuild.id(String.valueOf(dbEntity.getId()));
        }
        if (dbEntity.getStartTime() != null) {
            groupBuild.startTime(dbEntity.getStartTime().toInstant());
        }
        if (dbEntity.getEndTime() != null) {
            groupBuild.endTime(dbEntity.getEndTime().toInstant());
        }
        groupBuild.status(dbEntity.getStatus());
        groupBuild.temporaryBuild(Boolean.valueOf(dbEntity.isTemporaryBuild()));
        groupBuild.alignmentPreference(dbEntity.getAlignmentPreference());
        return groupBuild.build();
    }

    @Override
    public GroupBuildRef toRef(BuildConfigSetRecord dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        GroupBuildRef.Builder groupBuildRef = GroupBuildRef.refBuilder();
        if (dbEntity.getId() != null) {
            groupBuildRef.id(String.valueOf(dbEntity.getId()));
        }
        if (dbEntity.getStartTime() != null) {
            groupBuildRef.startTime(dbEntity.getStartTime().toInstant());
        }
        if (dbEntity.getEndTime() != null) {
            groupBuildRef.endTime(dbEntity.getEndTime().toInstant());
        }
        groupBuildRef.status(dbEntity.getStatus());
        groupBuildRef.temporaryBuild(Boolean.valueOf(dbEntity.isTemporaryBuild()));
        groupBuildRef.alignmentPreference(dbEntity.getAlignmentPreference());
        return groupBuildRef.build();
    }
}

