/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.mapper.api.IdMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.spi.datastore.Datastore;

@ApplicationScoped
@Transactional
public class IDToReferenceMapper {
    @Inject
    private EntityManager em;
    @Inject
    private BuildMapper buildMapper;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;
    @Inject
    private GroupBuildMapper groupBuildMapper;
    @Inject
    private Datastore datastore;

    public <ID extends Serializable, DB extends GenericEntity<ID>, DTOID> DB map(DTOID id, IdMapper<ID, DTOID> idMapper, Class<DB> type) {
        if (id == null) {
            return null;
        }
        return (DB)((GenericEntity)this.em.getReference(type, idMapper.toEntity(id)));
    }

    public ProductMilestone toProductMilestoneReference(String id) {
        return this.map(id, this.productMilestoneMapper.getIdMapper(), ProductMilestone.class);
    }

    public BuildConfigurationAudited toBCAReference(IdRev id) {
        return this.datastore.getBuildConfigurationAudited(id);
    }

    public BuildRecord toBuildRecordReference(String id) {
        return this.map(id, this.buildMapper.getIdMapper(), BuildRecord.class);
    }

    public BuildConfigSetRecord toBCSRReference(String id) {
        return this.map(id, this.groupBuildMapper.getIdMapper(), BuildConfigSetRecord.class);
    }
}

