/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.ProductVersion;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.mapper.MapSetMapper;
import org.jboss.pnc.mapper.RefToReferenceMapper;
import org.jboss.pnc.mapper.abstracts.AbstractProductVersionMapper;
import org.jboss.pnc.mapper.api.ProductMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.ProductVersion;

@ApplicationScoped
public class ProductVersionMapperImpl
extends AbstractProductVersionMapper {
    @Inject
    private RefToReferenceMapper refToReferenceMapper;
    @Inject
    private ProductMilestoneMapper productMilestoneMapper;
    @Inject
    private ProductMapper productMapper;
    @Inject
    private MapSetMapper mapSetMapper;

    @Override
    public ProductVersion toEntity(org.jboss.pnc.dto.ProductVersion dtoEntity) {
        if (dtoEntity == null) {
            return null;
        }
        ProductVersion productVersion = new ProductVersion();
        productVersion.setBuildConfigurationSets(this.mapSetMapper.mapGC(dtoEntity.getGroupConfigs()));
        productVersion.setBuildConfigurations(this.mapSetMapper.mapBC(dtoEntity.getBuildConfigs()));
        if (dtoEntity.getId() != null) {
            productVersion.setId(Integer.valueOf(Integer.parseInt(dtoEntity.getId())));
        }
        productVersion.setVersion(dtoEntity.getVersion());
        productVersion.setProduct(this.refToReferenceMapper.toEntityReference(dtoEntity.getProduct()));
        productVersion.setProductMilestones(this.mapSetMapper.mapPM(dtoEntity.getProductMilestones()));
        productVersion.setCurrentProductMilestone(this.refToReferenceMapper.toEntityReference(dtoEntity.getCurrentProductMilestone()));
        Map map = dtoEntity.getAttributes();
        if (map != null) {
            productVersion.setAttributes(new LinkedHashMap(map));
        }
        return productVersion;
    }

    @Override
    public void updateEntity(org.jboss.pnc.dto.ProductVersion dtoEntity, ProductVersion target) {
        if (dtoEntity == null) {
            return;
        }
        target.setVersion(dtoEntity.getVersion());
        target.setCurrentProductMilestone(this.refToReferenceMapper.toEntityReference(dtoEntity.getCurrentProductMilestone()));
        if (target.getAttributes() != null) {
            Map map = dtoEntity.getAttributes();
            if (map != null) {
                target.getAttributes().clear();
                target.getAttributes().putAll(map);
            } else {
                target.setAttributes(null);
            }
        } else {
            Map map = dtoEntity.getAttributes();
            if (map != null) {
                target.setAttributes(new LinkedHashMap(map));
            }
        }
        target.setBuildConfigurationSets(this.cm.updateGroupConfigs(dtoEntity, target));
        target.setBuildConfigurations(this.cm.updateBuildConfigs(dtoEntity, target));
    }

    @Override
    public ProductVersionRef toRef(ProductVersion dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductVersionRef.Builder productVersionRef = ProductVersionRef.refBuilder();
        if (dbEntity.getId() != null) {
            productVersionRef.id(String.valueOf(dbEntity.getId()));
        }
        productVersionRef.version(dbEntity.getVersion());
        Map map = dbEntity.getAttributes();
        if (map != null) {
            productVersionRef.attributes(new LinkedHashMap(map));
        }
        return productVersionRef.build();
    }

    @Override
    public org.jboss.pnc.dto.ProductVersion toDTO(ProductVersion dbEntity) {
        if (dbEntity == null) {
            return null;
        }
        ProductVersion.Builder productVersion = org.jboss.pnc.dto.ProductVersion.builder();
        productVersion.groupConfigs(this.mapSetMapper.mapGC(dbEntity.getBuildConfigurationSets()));
        productVersion.product(this.productMapper.toRef(dbEntity.getProduct()));
        productVersion.currentProductMilestone(this.productMilestoneMapper.toRef(dbEntity.getCurrentProductMilestone()));
        productVersion.buildConfigs(this.mapSetMapper.mapBC(dbEntity.getBuildConfigurations()));
        productVersion.productMilestones(this.mapSetMapper.mapPM(dbEntity.getProductMilestones()));
        productVersion.productReleases(this.mapSetMapper.mapPR(dbEntity.getProductReleases()));
        if (dbEntity.getId() != null) {
            productVersion.id(String.valueOf(dbEntity.getId()));
        }
        productVersion.version(dbEntity.getVersion());
        Map map4 = dbEntity.getAttributes();
        if (map4 != null) {
            productVersion.attributes(new LinkedHashMap(map4));
        }
        return productVersion.build();
    }
}

