/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.mapper.api;

import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jboss.pnc.enums.BuildCoordinationStatus;
import org.jboss.pnc.mapper.Base32LongIdMapper;
import org.jboss.pnc.mapper.IDToReferenceMapper;
import org.jboss.pnc.mapper.UserFetcher;
import org.jboss.pnc.mapper.api.ByUsername;
import org.jboss.pnc.mapper.api.MapperCentralConfig;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.utils.ContentIdentityManager;
import org.jboss.pnc.rex.common.enums.State;
import org.jboss.pnc.rex.common.enums.StopFlag;
import org.jboss.pnc.rex.common.enums.Transition;
import org.jboss.pnc.rex.dto.TaskDTO;
import org.jboss.pnc.rex.dto.TransitionTimeDTO;
import org.jboss.pnc.rex.model.TransitionTime;
import org.jboss.pnc.rex.model.requests.MinimizedTask;
import org.jboss.pnc.spi.coordinator.BuildMeta;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.coordinator.BuildTaskRef;
import org.jboss.pnc.spi.coordinator.DefaultBuildTaskRef;
import org.jboss.pnc.spi.coordinator.RemoteBuildTask;
import org.mapstruct.BeanMapping;
import org.mapstruct.BeforeMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.ReportingPolicy;

@Mapper(config=MapperCentralConfig.class, unmappedSourcePolicy=ReportingPolicy.ERROR, uses={UserFetcher.class, IDToReferenceMapper.class, Base32LongIdMapper.class}, imports={ContentIdentityManager.class, IdRev.class})
public interface BuildTaskMappers {
    @Mappings(value={@Mapping(target="id", source="task.name"), @Mapping(target="idRev", source="task.constraint"), @Mapping(target="buildConfigSetRecordId", source="task.correlationID"), @Mapping(target="productMilestone", source="meta.productMilestoneId"), @Mapping(target="submitTime", source="meta.submitTime"), @Mapping(target="startTime", ignore=true), @Mapping(target="endTime", ignore=true), @Mapping(target="user", source="meta.username", qualifiedBy={ByUsername.class}), @Mapping(target="noRebuildCause", source="meta.noRebuildCauseId"), @Mapping(target="status", expression="java(BuildTaskMappers.toBuildStatus(task.getState(), task.getStopFlag()))"), @Mapping(target="dependants", source="meta.dependants"), @Mapping(target="dependencies", source="meta.dependencies"), @Mapping(target="taskDependants", source="task.dependants"), @Mapping(target="taskDependencies", source="task.dependencies")})
    @BeanMapping(ignoreUnmappedSourceProperties={"remoteStart", "remoteCancel", "callerNotifications", "state", "stopFlag", "serverResponses", "id", "idRev", "configuration", "timestamps"})
    public DefaultBuildTaskRef toBuildTaskRef(TaskDTO var1, BuildMeta var2);

    @Mappings(value={@Mapping(target="id", source="task.name"), @Mapping(target="idRev", source="task.constraint"), @Mapping(target="buildConfigSetRecordId", source="task.correlationID"), @Mapping(target="productMilestone", source="meta.productMilestoneId"), @Mapping(target="submitTime", source="meta.submitTime"), @Mapping(target="startTime", ignore=true), @Mapping(target="endTime", ignore=true), @Mapping(target="status", expression="java(BuildTaskMappers.toBuildStatus(task.getState(), task.getStopFlag()))"), @Mapping(target="user", source="meta.username", qualifiedBy={ByUsername.class}), @Mapping(target="noRebuildCause", source="meta.noRebuildCauseId"), @Mapping(target="dependants", source="meta.dependants"), @Mapping(target="dependencies", source="meta.dependencies"), @Mapping(target="taskDependants", source="task.dependants"), @Mapping(target="taskDependencies", source="task.dependencies")})
    @BeanMapping(ignoreUnmappedSourceProperties={"remoteStart", "remoteCancel", "callerNotifications", "state", "stopFlag", "serverResponses", "id", "idRev", "configuration", "timestamps"})
    public DefaultBuildTaskRef toBuildTaskRef(MinimizedTask var1, BuildMeta var2);

    @BeforeMapping
    default public void fillStartAndEndTime(TaskDTO source, @MappingTarget DefaultBuildTaskRef.Builder builder) {
        if (source.getTimestamps() == null) {
            return;
        }
        Optional<Instant> startTime = BuildTaskMappers.getStartTimeDTO(source.getTimestamps());
        Optional<Instant> endTime = BuildTaskMappers.getEndTimeDTO(source.getTimestamps());
        startTime.ifPresent(arg_0 -> ((DefaultBuildTaskRef.Builder)builder).startTime(arg_0));
        endTime.ifPresent(arg_0 -> ((DefaultBuildTaskRef.Builder)builder).endTime(arg_0));
    }

    @BeforeMapping
    default public void fillStartAndEndTime(MinimizedTask source, @MappingTarget DefaultBuildTaskRef.Builder builder) {
        if (source.getTimestamps() == null) {
            return;
        }
        Optional<Instant> startTime = BuildTaskMappers.getStartTime(source.getTimestamps());
        Optional<Instant> endTime = BuildTaskMappers.getEndTime(source.getTimestamps());
        startTime.ifPresent(arg_0 -> ((DefaultBuildTaskRef.Builder)builder).startTime(arg_0));
        endTime.ifPresent(arg_0 -> ((DefaultBuildTaskRef.Builder)builder).endTime(arg_0));
    }

    public static Optional<Instant> getStartTime(List<TransitionTime> transitionTimes) {
        return BuildTaskMappers.getTimestamp(transitionTimes, TransitionTime::getTransition, TransitionTime::getTime, BuildTaskMappers::identifyStart, true);
    }

    public static Optional<Instant> getStartTimeDTO(List<TransitionTimeDTO> transitionTimes) {
        return BuildTaskMappers.getTimestamp(transitionTimes, TransitionTimeDTO::getTransition, TransitionTimeDTO::getTime, BuildTaskMappers::identifyStart, true);
    }

    public static Optional<Instant> getEndTime(List<TransitionTime> transitionTimes) {
        return BuildTaskMappers.getTimestamp(transitionTimes, TransitionTime::getTransition, TransitionTime::getTime, BuildTaskMappers::identifyEnd, false);
    }

    public static Optional<Instant> getEndTimeDTO(List<TransitionTimeDTO> transitionTimes) {
        return BuildTaskMappers.getTimestamp(transitionTimes, TransitionTimeDTO::getTransition, TransitionTimeDTO::getTime, BuildTaskMappers::identifyEnd, false);
    }

    private static Boolean identifyStart(Transition transition) {
        return transition.getBefore() == State.ENQUEUED;
    }

    private static Boolean identifyEnd(Transition transition) {
        return transition.getAfter().isFinal();
    }

    public static <T> Optional<Instant> getTimestamp(List<T> collection, Function<T, Transition> extractTransition, Function<T, Instant> extractTime, Predicate<Transition> transitionPredicate, boolean earliest) {
        return collection.stream().filter(transitionTime -> transitionPredicate.test((Transition)extractTransition.apply(transitionTime))).map(extractTime).min(earliest ? Comparator.naturalOrder() : Comparator.reverseOrder());
    }

    @Mappings(value={@Mapping(target="buildConfigurationAudited", source="idRev"), @Mapping(target="statusDescription", ignore=true), @Mapping(target="buildSetTask", ignore=true), @Mapping(target="buildConfigSetRecordId", source="buildConfigSetRecordId"), @Mapping(target="buildOptions.temporaryBuild", source="temporaryBuild"), @Mapping(target="buildOptions.alignmentPreference", source="alignmentPreference"), @Mapping(target="requestContext", ignore=true)})
    @BeanMapping(ignoreUnmappedSourceProperties={"taskDependants", "taskDependencies"})
    public BuildTask toBuildTask(BuildTaskRef var1);

    @Mappings(value={@Mapping(target="id", source="request.id"), @Mapping(target="idRev", expression="java( new IdRev( Integer.valueOf(request.getBuildConfigurationAudited().getId()), request.getBuildConfigurationAudited().getRev() ) )"), @Mapping(target="temporaryBuild", source="request.buildOptions.temporaryBuild"), @Mapping(target="status", constant="REJECTED_ALREADY_BUILT"), @Mapping(target="alignmentPreference", source="request.buildOptions.alignmentPreference"), @Mapping(target="productMilestone", source="request.currentProductMilestone.id"), @Mapping(target="buildConfigSetRecordId", source="setRecordId"), @Mapping(target="user", source="request.username", qualifiedBy={ByUsername.class}), @Mapping(target="startTime", ignore=true), @Mapping(target="endTime", ignore=true), @Mapping(target="contentId", expression="java(ContentIdentityManager.getBuildContentId(request.getId()))"), @Mapping(target="dependants", source="request.dependants"), @Mapping(target="dependencies", source="request.dependencies"), @Mapping(target="taskDependencies", ignore=true), @Mapping(target="taskDependants", ignore=true)})
    @BeanMapping(ignoreUnmappedSourceProperties={"alreadyRunning", "buildConfigurationAudited"})
    public DefaultBuildTaskRef toNRRBuildTaskRef(RemoteBuildTask var1, Long var2);

    @Mappings(value={@Mapping(target="idRev", expression="java( new IdRev( Integer.valueOf(request.getBuildConfigurationAudited().getId()), request.getBuildConfigurationAudited().getRev() ) )"), @Mapping(target="contentId", expression="java(ContentIdentityManager.getBuildContentId(request.getId()))"), @Mapping(target="temporaryBuild", source="buildOptions.temporaryBuild"), @Mapping(target="alignmentPreference", source="buildOptions.alignmentPreference"), @Mapping(target="productMilestoneId", source="currentProductMilestone.id"), @Mapping(target="noRebuildCauseId", expression="java( request.getNoRebuildCause().map(r -> r.getId().getId()).orElse(null) )")})
    @BeanMapping(ignoreUnmappedSourceProperties={"buildConfigurationAudited", "alreadyRunning", "noRebuildCause"})
    public BuildMeta toBuildMeta(RemoteBuildTask var1);

    public static BuildTask fromStringId(String depId) {
        return new BuildTask(null, null, null, null, null, depId, null, null, null, null);
    }

    public static BuildCoordinationStatus toBuildStatus(State state, StopFlag flag) {
        switch (state) {
            case NEW: {
                return BuildCoordinationStatus.NEW;
            }
            case WAITING: {
                return BuildCoordinationStatus.WAITING_FOR_DEPENDENCIES;
            }
            case ENQUEUED: {
                return BuildCoordinationStatus.ENQUEUED;
            }
            case STOP_REQUESTED: 
            case STARTING: 
            case STOPPING: 
            case UP: {
                return BuildCoordinationStatus.BUILDING;
            }
            case STOP_FAILED: 
            case START_FAILED: {
                return BuildCoordinationStatus.SYSTEM_ERROR;
            }
            case FAILED: {
                return BuildCoordinationStatus.DONE_WITH_ERRORS;
            }
            case SUCCESSFUL: {
                return BuildCoordinationStatus.DONE;
            }
            case STOPPED: {
                switch (flag) {
                    case NONE: 
                    case UNSUCCESSFUL: {
                        return BuildCoordinationStatus.SYSTEM_ERROR;
                    }
                    case CANCELLED: {
                        return BuildCoordinationStatus.CANCELLED;
                    }
                    case DEPENDENCY_FAILED: {
                        return BuildCoordinationStatus.REJECTED_FAILED_DEPENDENCIES;
                    }
                }
                throw new IllegalArgumentException("Unknown stopFlag " + flag);
            }
        }
        throw new IllegalArgumentException("Unknown Rex state " + state);
    }

    public static String toConstraint(IdRev idRev) {
        return idRev.getId() + "-" + idRev.getRev();
    }

    public static IdRev fromConstraint(String constraint) {
        String[] split = constraint.split("-");
        return new IdRev(Integer.valueOf(Integer.parseInt(split[0])), Integer.valueOf(Integer.parseInt(split[1])));
    }

    public static <T> T unwrap(Optional<T> optional) {
        return optional != null && optional.isPresent() ? (T)optional.get() : null;
    }
}

