/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import org.jboss.pnc.metrics.exceptions.NoPropertyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Startup
public class MetricsConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MetricsConfiguration.class);
    private static final String METRIC_JVM_MEMORY = "jvm.memory";
    private static final String METRIC_JVM_GARBAGE = "jvm.garbage";
    private static final String METRIC_JVM_THREADS = "jvm.threads";
    private static final String METRIC_JVM_CLASSLOADING = "jvm.classloading";
    private static final String GRAPHITE_SERVER_KEY = "metrics_graphite_server";
    private static final String GRAPHITE_PORT_KEY = "metrics_graphite_port";
    private static final String GRAPHITE_PREFIX_KEY = "metrics_graphite_prefix";
    private static final String GRAPHITE_INTERVAL_KEY = "metrics_graphite_interval";
    private static final int DEFAULT_GRAPHITE_INTERVAL = 60;
    private MetricRegistry metricRegistry;

    @PostConstruct
    public void init() {
        this.metricRegistry = new MetricRegistry();
        this.monitorJvmMetrics();
        this.setupGraphiteReporter();
    }

    private String getValueFromProperty(String propertyName, String description) throws NoPropertyException {
        String value;
        String valueSys = System.getProperty(propertyName);
        String valueEnv = System.getenv(propertyName);
        if (valueSys != null) {
            value = valueSys;
        } else if (valueEnv != null) {
            value = valueEnv;
        } else {
            throw new NoPropertyException("Property '" + propertyName + "' not specified");
        }
        logger.info("Updated " + description + " to: " + value);
        return value;
    }

    private void monitorJvmMetrics() {
        logger.info("Registering JVM metrics");
        this.metricRegistry.register(METRIC_JVM_GARBAGE, (Metric)new GarbageCollectorMetricSet());
        this.metricRegistry.register(METRIC_JVM_MEMORY, (Metric)new MemoryUsageGaugeSet());
        this.metricRegistry.register(METRIC_JVM_THREADS, (Metric)new ThreadStatesGaugeSet());
        this.metricRegistry.register(METRIC_JVM_CLASSLOADING, (Metric)new ClassLoadingGaugeSet());
    }

    private void setupGraphiteReporter() {
        int graphiteInterval = 60;
        try {
            graphiteInterval = Integer.parseInt(this.getValueFromProperty(GRAPHITE_INTERVAL_KEY, "Graphite Interval reporting"));
        }
        catch (NumberFormatException e) {
            logger.warn("Could not parse Graphite interval! Using default value of {} seconds instead", (Object)60);
        }
        catch (NoPropertyException e) {
            // empty catch block
        }
        try {
            String graphiteServer = this.getValueFromProperty(GRAPHITE_SERVER_KEY, "Graphite Server URL");
            int graphitePort = Integer.parseInt(this.getValueFromProperty(GRAPHITE_PORT_KEY, "Graphite Port"));
            String graphitePrefix = this.getValueFromProperty(GRAPHITE_PREFIX_KEY, "Graphite Prefix");
            this.startGraphiteReporter(graphiteServer, graphitePort, graphitePrefix, graphiteInterval);
        }
        catch (NumberFormatException e) {
            logger.warn("Could not parse Graphite port! Aborting reporting data to Graphite", (Throwable)e);
        }
        catch (NoPropertyException e) {
            logger.warn("Could not find property required to setup Graphite reporting! Reason: {}", (Object)e.getMessage());
        }
    }

    private void startGraphiteReporter(String host, int port, String prefix, int interval) {
        logger.info("Setting up Graphite reporter");
        Graphite graphite = new Graphite(new InetSocketAddress(host, port));
        GraphiteReporter reporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith(prefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
        reporter.start((long)interval, TimeUnit.SECONDS);
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }
}

