/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.json.moduleconfig;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.jboss.pnc.common.json.AbstractModuleConfig;
import org.jboss.pnc.common.json.moduleconfig.KeycloakClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfig
extends AbstractModuleConfig {
    private static final Logger log = LoggerFactory.getLogger(SystemConfig.class);
    private String buildDriverId;
    private String buildSchedulerId;
    private final String authenticationProviderId;
    private String executorThreadPoolSize;
    private String builderThreadPoolSize;
    private int coordinatorThreadPoolSize;
    private String brewTagPattern;
    private int coordinatorMaxConcurrentBuilds;
    private KeycloakClientConfig keycloakServiceAccountConfig;
    private int temporaryBuildsLifeSpan;

    public SystemConfig(@JsonProperty(value="buildDriverId") String buildDriverId, @JsonProperty(value="buildSchedulerId") String buildSchedulerId, @JsonProperty(value="authenticationProviderId") String authenticationProviderId, @JsonProperty(value="executorThreadPoolSize") String executorThreadPoolSize, @JsonProperty(value="builderThreadPoolSize") String builderThreadPoolSize, @JsonProperty(value="coordinatorThreadPoolSize") String coordinatorThreadPoolSize, @JsonProperty(value="brewTagPattern") String brewTagPattern, @JsonProperty(value="coordinatorMaxConcurrentBuilds") String coordinatorMaxConcurrentBuilds, @JsonProperty(value="keycloakServiceAccountConfig") KeycloakClientConfig keycloakServiceAccountConfig, @JsonProperty(value="temporaryBuildsLifeSpan") String temporaryBuildsLifeSpan) {
        this.buildDriverId = buildDriverId;
        this.buildSchedulerId = buildSchedulerId;
        this.authenticationProviderId = authenticationProviderId;
        this.executorThreadPoolSize = executorThreadPoolSize;
        this.builderThreadPoolSize = builderThreadPoolSize;
        this.coordinatorThreadPoolSize = this.toIntWithDefault("coordinatorThreadPoolSize", coordinatorThreadPoolSize, 1);
        this.coordinatorMaxConcurrentBuilds = this.toIntWithDefault("coordinatorMaxConcurrentBuilds", coordinatorMaxConcurrentBuilds, 10);
        this.brewTagPattern = brewTagPattern;
        this.keycloakServiceAccountConfig = keycloakServiceAccountConfig;
        this.temporaryBuildsLifeSpan = this.toIntWithDefault("temporaryBuildsLifeSpan", temporaryBuildsLifeSpan, 14);
    }

    public String getBuildDriverId() {
        return this.buildDriverId;
    }

    public String getBuildSchedulerId() {
        return this.buildSchedulerId;
    }

    public String getExecutorThreadPoolSize() {
        return this.executorThreadPoolSize;
    }

    public String getBuilderThreadPoolSize() {
        return this.builderThreadPoolSize;
    }

    public void setBuilderThreadPoolSize(String builderThreadPoolSize) {
        this.builderThreadPoolSize = builderThreadPoolSize;
    }

    public int getCoordinatorThreadPoolSize() {
        return this.coordinatorThreadPoolSize;
    }

    public int getCoordinatorMaxConcurrentBuilds() {
        return this.coordinatorMaxConcurrentBuilds;
    }

    public String getBrewTagPattern() {
        return this.brewTagPattern;
    }

    public int getTemporaryBuildsLifeSpan() {
        return this.temporaryBuildsLifeSpan;
    }

    @JsonIgnore
    public Date getTemporalBuildExpireDate() {
        return Date.from(Instant.now().plus((long)this.temporaryBuildsLifeSpan, ChronoUnit.DAYS));
    }

    public KeycloakClientConfig getKeycloakServiceAccountConfig() {
        return this.keycloakServiceAccountConfig;
    }

    private int toIntWithDefault(String fieldName, String numberAsString, int defaultValue) {
        int result = defaultValue;
        if (numberAsString == null) {
            log.warn("Value in field: " + fieldName + " not set. Will use default value: {}", (Object)defaultValue);
        } else {
            try {
                result = Integer.parseInt(numberAsString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Invalid value in field: " + fieldName + ". Expected an integer, got: {}. Will use default value: {}", new Object[]{numberAsString, defaultValue, nfe});
            }
        }
        return result;
    }

    public String toString() {
        return "SystemConfig [" + (this.buildDriverId != null ? "buildDriverId=" + this.buildDriverId + ", " : "") + (this.buildSchedulerId != null ? "buildSchedulerId=" + this.buildSchedulerId + ", " : "") + (this.authenticationProviderId != null ? "authenticationProviderId=" + this.authenticationProviderId + ", " : "") + (this.executorThreadPoolSize != null ? "executorThreadPoolSize=" + this.executorThreadPoolSize + ", " : "") + (this.builderThreadPoolSize != null ? "builderThreadPoolSize=" + this.builderThreadPoolSize : "") + "]";
    }

    public String getAuthenticationProviderId() {
        return this.authenticationProviderId;
    }
}

