/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.json.moduleconfig;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import org.jboss.pnc.common.json.AbstractModuleConfig;
import org.jboss.pnc.common.json.moduleconfig.KeycloakConfig;
import org.jboss.pnc.common.util.StringUtils;

@JsonIgnoreProperties(value={"@module-config"})
public class UIModuleConfig
extends AbstractModuleConfig {
    public static final String MODULE_NAME = "ui";
    private final String pncUrl;
    private final String pncNotificationsUrl;
    private final String daUrl;
    private final String userGuideUrl;
    private final Integer ssoTokenLifespan;
    private final KeycloakConfig keycloak;
    private final Map<String, String> grafana;
    private final String kafkaStoreUrl;

    public UIModuleConfig(@JsonProperty(value="pncUrl") String pncUrl, @JsonProperty(value="pncNotificationsUrl") String pncNotificationsUrl, @JsonProperty(value="daUrl") String daUrl, @JsonProperty(value="userGuideUrl") String userGuideUrl, @JsonProperty(value="ssoTokenLifespan") String ssoTokenLifespan, @JsonProperty(value="keycloak") KeycloakConfig keycloak, @JsonProperty(value="grafana") @DefaultValue(value="{}") Map<String, String> grafana, @JsonProperty(value="kafkaStoreUrl") String kafkaStoreUrl) {
        this.pncUrl = pncUrl;
        this.pncNotificationsUrl = pncNotificationsUrl;
        this.daUrl = daUrl;
        this.userGuideUrl = userGuideUrl;
        this.ssoTokenLifespan = StringUtils.parseInt((String)ssoTokenLifespan, (int)86400000);
        this.keycloak = keycloak;
        this.grafana = grafana;
        this.kafkaStoreUrl = kafkaStoreUrl;
    }

    @JsonProperty(value="pncUrl")
    public String getPncUrl() {
        return this.pncUrl;
    }

    @JsonProperty(value="pncNotificationsUrl")
    public String getPncNotificationsUrl() {
        return this.pncNotificationsUrl;
    }

    @JsonProperty(value="daUrl")
    public String getDaUrl() {
        return this.daUrl;
    }

    public String getUserGuideUrl() {
        return this.userGuideUrl;
    }

    public Integer getSsoTokenLifespan() {
        return this.ssoTokenLifespan;
    }

    @JsonProperty(value="keycloak")
    public KeycloakConfig getKeycloak() {
        return this.keycloak;
    }

    @JsonProperty(value="grafana")
    public Map<String, String> getGrafana() {
        return this.grafana;
    }

    public String getKafkaStoreUrl() {
        return this.kafkaStoreUrl;
    }

    public String toString() {
        return "UIModuleConfig{pncUrl='" + this.pncUrl + '\'' + ", pncNotificationsUrl='" + this.pncNotificationsUrl + '\'' + ", daUrl='" + this.daUrl + '\'' + ", userGuideUrl='" + this.userGuideUrl + '\'' + ", ssoTokenLifespan=" + this.ssoTokenLifespan + ", keycloak=" + this.keycloak + ", grafana=" + this.grafana + ", kafkaStoreUrl=" + this.kafkaStoreUrl + '}';
    }
}

