/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.json.moduleconfig;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.pnc.common.json.AbstractModuleConfig;

public class IndyRepoDriverModuleConfig
extends AbstractModuleConfig {
    public static final String MODULE_NAME = "indy-repo-driver";
    @JsonProperty(value="ignored-repo-patterns")
    private List<String> ignoredRepoPatterns;
    @JsonProperty(value="ignored-path-patterns")
    private IgnoredPathPatterns ignoredPathPatterns;
    @JsonProperty(required=false)
    private Integer defaultRequestTimeout = 600;
    @JsonProperty(required=false)
    private Boolean buildRepositoryAllowSnapshots = false;
    @JsonProperty(required=false)
    private String buildPromotionTarget = "pnc-builds";
    @JsonProperty(required=false)
    private String tempBuildPromotionTarget = "temporary-builds";

    public List<String> getIgnoredRepoPatterns() {
        return this.ignoredRepoPatterns;
    }

    public void setIgnoredRepoPatterns(List<String> internalRepoPatterns) {
        this.ignoredRepoPatterns = internalRepoPatterns;
    }

    public IgnoredPathPatterns getIgnoredPathPatterns() {
        return this.ignoredPathPatterns;
    }

    public void setIgnoredPathPatterns(IgnoredPathPatterns ignoredPathPatterns) {
        this.ignoredPathPatterns = ignoredPathPatterns;
    }

    public String toString() {
        return "IndyRepoDriverModuleConfig(ignoredRepoPatterns=" + this.getIgnoredRepoPatterns() + ", ignoredPathPatterns=" + this.getIgnoredPathPatterns() + ", defaultRequestTimeout=" + this.getDefaultRequestTimeout() + ", buildRepositoryAllowSnapshots=" + this.getBuildRepositoryAllowSnapshots() + ", buildPromotionTarget=" + this.getBuildPromotionTarget() + ", tempBuildPromotionTarget=" + this.getTempBuildPromotionTarget() + ")";
    }

    public Integer getDefaultRequestTimeout() {
        return this.defaultRequestTimeout;
    }

    @JsonProperty(required=false)
    public void setDefaultRequestTimeout(Integer defaultRequestTimeout) {
        this.defaultRequestTimeout = defaultRequestTimeout;
    }

    public Boolean getBuildRepositoryAllowSnapshots() {
        return this.buildRepositoryAllowSnapshots;
    }

    @JsonProperty(required=false)
    public void setBuildRepositoryAllowSnapshots(Boolean buildRepositoryAllowSnapshots) {
        this.buildRepositoryAllowSnapshots = buildRepositoryAllowSnapshots;
    }

    public String getBuildPromotionTarget() {
        return this.buildPromotionTarget;
    }

    @JsonProperty(required=false)
    public void setBuildPromotionTarget(String buildPromotionTarget) {
        this.buildPromotionTarget = buildPromotionTarget;
    }

    public String getTempBuildPromotionTarget() {
        return this.tempBuildPromotionTarget;
    }

    @JsonProperty(required=false)
    public void setTempBuildPromotionTarget(String tempBuildPromotionTarget) {
        this.tempBuildPromotionTarget = tempBuildPromotionTarget;
    }

    public static class IgnoredPathPatterns {
        private IgnoredPatterns promotion;
        private IgnoredPatterns data;

        public IgnoredPatterns getPromotion() {
            return this.promotion == null ? new IgnoredPatterns() : this.promotion;
        }

        public IgnoredPatterns getData() {
            return this.data == null ? new IgnoredPatterns() : this.data;
        }

        public String toString() {
            return "IndyRepoDriverModuleConfig.IgnoredPathPatterns(promotion=" + this.getPromotion() + ", data=" + this.getData() + ")";
        }

        public void setPromotion(IgnoredPatterns promotion) {
            this.promotion = promotion;
        }

        public void setData(IgnoredPatterns data) {
            this.data = data;
        }
    }

    public static class IgnoredPatterns {
        @JsonIgnore
        private PatternsList generic;
        @JsonIgnore
        private PatternsList maven;
        @JsonIgnore
        private PatternsList npm;

        @JsonProperty(value="generic")
        public void setGeneric(List<String> strPatterns) {
            this.generic = new PatternsList(strPatterns);
        }

        @JsonProperty(value="maven")
        public void setMaven(List<String> strPatterns) {
            this.maven = new PatternsList(strPatterns);
        }

        @JsonProperty(value="npm")
        public void setNpm(List<String> strPatterns) {
            this.npm = new PatternsList(strPatterns);
        }

        @JsonIgnore
        public PatternsList getGeneric() {
            return this.getPatternsList(this.generic);
        }

        @JsonIgnore
        public PatternsList getMaven() {
            return this.getPatternsList(this.maven);
        }

        @JsonIgnore
        public PatternsList getNpm() {
            return this.getPatternsList(this.npm);
        }

        private List<String> genStringList(PatternsList patternsList) {
            if (patternsList != null && patternsList.patterns != null) {
                return patternsList.patterns.stream().map(Pattern::pattern).collect(Collectors.toList());
            }
            return Collections.emptyList();
        }

        @JsonProperty(value="generic")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<String> getGenericStrings() {
            return this.genStringList(this.generic);
        }

        @JsonProperty(value="maven")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<String> getMavenStrings() {
            return this.genStringList(this.maven);
        }

        @JsonProperty(value="npm")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public List<String> getNpmStrings() {
            return this.genStringList(this.npm);
        }

        @JsonIgnore
        private PatternsList getPatternsList(PatternsList list) {
            return list == null ? new PatternsList(Collections.emptyList()) : list;
        }

        public String toString() {
            return "IndyRepoDriverModuleConfig.IgnoredPatterns(generic=" + this.getGeneric() + ", maven=" + this.getMaven() + ", npm=" + this.getNpm() + ")";
        }
    }

    public static class PatternsList {
        @JsonIgnore
        private List<Pattern> patterns;

        public List<Pattern> getPatterns() {
            return this.patterns == null ? Collections.emptyList() : this.patterns;
        }

        public PatternsList(List<String> strings) {
            if (strings != null) {
                this.patterns = new ArrayList<Pattern>(strings.size());
                for (String string : strings) {
                    this.patterns.add(Pattern.compile(string));
                }
            }
        }
    }
}

