/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.json.moduleconfig;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.jboss.pnc.common.json.moduleconfig.EnvironmentDriverModuleConfigBase;
import org.jboss.pnc.common.json.moduleconfig.helper.HttpDestinationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenshiftEnvironmentDriverModuleConfig
extends EnvironmentDriverModuleConfigBase {
    private static final Logger log = LoggerFactory.getLogger(OpenshiftEnvironmentDriverModuleConfig.class);
    public static final String MODULE_NAME = "openshift-environment-driver";
    private static final int DEFAULT_BUILDER_POD_MEMORY = 4;
    private static final int DEFAULT_CREATION_POD_RETRY = 1;
    private String restEndpointUrl;
    private String buildAgentHost;
    private String buildAgentBindPath;
    private String executorThreadPoolSize;
    private String podNamespace;
    private String restAuthToken;
    private String containerPort;
    private boolean keepBuildAgentInstance;
    private boolean exposeBuildAgentOnPublicUrl;
    private final int builderPodMemory;
    private int creationPodRetry;
    private int pollingMonitorTimeout;
    private int pollingMonitorCheckInterval;

    public OpenshiftEnvironmentDriverModuleConfig(@JsonProperty(value="restEndpointUrl") String restEndpointUrl, @JsonProperty(value="buildAgentHost") String buildAgentHost, @JsonProperty(value="imageId") String imageId, @JsonProperty(value="firewallAllowedDestinations") String firewallAllowedDestinations, @JsonProperty(value="allowedHttpOutgoingDestinations") List<HttpDestinationConfig> allowedHttpOutgoingDestinations, @JsonProperty(value="proxyServer") String proxyServer, @JsonProperty(value="proxyPort") String proxyPort, @JsonProperty(value="nonProxyHosts") String nonProxyHosts, @JsonProperty(value="podNamespace") String podNamespace, @JsonProperty(value="buildAgentBindPath") String buildAgentBindPath, @JsonProperty(value="executorThreadPoolSize") String executorThreadPoolSize, @JsonProperty(value="restAuthToken") String restAuthToken, @JsonProperty(value="containerPort") String containerPort, @JsonProperty(value="workingDirectory") String workingDirectory, @JsonProperty(value="disabled") Boolean disabled, @JsonProperty(value="keepBuildAgentInstance") Boolean keepBuildAgentInstance, @JsonProperty(value="exposeBuildAgentOnPublicUrl") Boolean exposeBuildAgentOnPublicUrl, @JsonProperty(value="creationPodRetry") String creationPodRetry, @JsonProperty(value="builderPodMemory") Integer builderPodMemory, @JsonProperty(value="pollingMonitorTimeout") String pollingMonitorTimeout, @JsonProperty(value="pollingMonitorCheckInterval") String pollingMonitorCheckInterval) {
        super(imageId, firewallAllowedDestinations, allowedHttpOutgoingDestinations, proxyServer, proxyPort, nonProxyHosts, workingDirectory, disabled);
        this.restEndpointUrl = restEndpointUrl;
        this.buildAgentHost = buildAgentHost;
        this.buildAgentBindPath = buildAgentBindPath;
        this.executorThreadPoolSize = executorThreadPoolSize;
        this.podNamespace = podNamespace;
        this.restAuthToken = restAuthToken;
        this.containerPort = containerPort;
        this.keepBuildAgentInstance = keepBuildAgentInstance != null ? keepBuildAgentInstance : false;
        this.exposeBuildAgentOnPublicUrl = exposeBuildAgentOnPublicUrl != null ? exposeBuildAgentOnPublicUrl : false;
        this.builderPodMemory = builderPodMemory == null ? 4 : builderPodMemory;
        this.creationPodRetry = 1;
        if (creationPodRetry != null) {
            try {
                this.creationPodRetry = Integer.parseInt(creationPodRetry);
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse the value of creation pod retry from the configuration. Using default ({} retries)", (Object)1);
            }
        }
        this.pollingMonitorTimeout = 300;
        if (pollingMonitorTimeout != null) {
            try {
                this.pollingMonitorTimeout = Integer.parseInt(pollingMonitorTimeout);
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse the value of polling monitor timeout. Using default ({} seconds)", (Object)300);
            }
        }
        this.pollingMonitorCheckInterval = 1;
        if (pollingMonitorCheckInterval != null) {
            try {
                this.pollingMonitorCheckInterval = Integer.parseInt(pollingMonitorCheckInterval);
            }
            catch (NumberFormatException e) {
                log.error("Couldn't parse the value of polling monitor check interval. Using default ({} seconds)", (Object)1);
            }
        }
        log.debug("Created new instance {}", (Object)this.toString());
    }

    public String getRestEndpointUrl() {
        return this.restEndpointUrl;
    }

    public String getBuildAgentHost() {
        return this.buildAgentHost;
    }

    public String getPncNamespace() {
        return this.podNamespace;
    }

    public String getRestAuthToken() {
        return this.restAuthToken;
    }

    public String getContainerPort() {
        return this.containerPort;
    }

    public String getBuildAgentBindPath() {
        return this.buildAgentBindPath;
    }

    public String getExecutorThreadPoolSize() {
        return this.executorThreadPoolSize;
    }

    public boolean getKeepBuildAgentInstance() {
        return this.keepBuildAgentInstance;
    }

    public boolean getExposeBuildAgentOnPublicUrl() {
        return this.exposeBuildAgentOnPublicUrl;
    }

    public int getCreationPodRetry() {
        return this.creationPodRetry;
    }

    public int getPollingMonitorTimeout() {
        return this.pollingMonitorTimeout;
    }

    public int getPollingMonitorCheckInterval() {
        return this.pollingMonitorCheckInterval;
    }

    public String toString() {
        return "OpenshiftEnvironmentDriverModuleConfig{restEndpointUrl='" + this.restEndpointUrl + '\'' + ", imageId='" + this.imageId + '\'' + ", firewallAllowedDestinations='" + this.firewallAllowedDestinations + '\'' + ", allowedHttpOutgoingDestinations='" + this.allowedHttpOutgoingDestinations + '\'' + ", proxyServer='" + this.proxyServer + '\'' + ", proxyPort='" + this.proxyPort + '\'' + ", nonProxyHosts='" + this.nonProxyHosts + '\'' + ", podNamespace='" + this.podNamespace + '\'' + ", buildAgentHost='" + this.buildAgentHost + '\'' + ", buildAgentBindPath='" + this.buildAgentBindPath + '\'' + ", executorThreadPoolSize='" + this.executorThreadPoolSize + '\'' + ", restAuthToken= HIDDEN , containerPort='" + this.containerPort + '\'' + ", disabled='" + this.disabled + '\'' + ", keepBuildAgentInstance='" + this.keepBuildAgentInstance + '\'' + ", exposeBuildAgentOnPublicUrl='" + this.exposeBuildAgentOnPublicUrl + '\'' + ", creationPodRetry=" + this.creationPodRetry + ", pollingMonitorTimeout=" + this.pollingMonitorTimeout + ", pollingMonitorCheckInterval=" + this.pollingMonitorCheckInterval + '}';
    }

    public String getPodNamespace() {
        return this.podNamespace;
    }

    public int getBuilderPodMemory() {
        return this.builderPodMemory;
    }
}

