/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.json.moduleconfig;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Properties;
import org.jboss.pnc.common.json.AbstractModuleConfig;
import org.jboss.pnc.common.json.moduleconfig.KeycloakClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfig
extends AbstractModuleConfig {
    public static final String MODULE_NAME = "system-config";
    private static final Logger log = LoggerFactory.getLogger(SystemConfig.class);
    private final String authenticationProviderId;
    private int coordinatorThreadPoolSize;
    private String brewTagPattern;
    private int coordinatorMaxConcurrentBuilds;
    private KeycloakClientConfig keycloakServiceAccountConfig;
    private long serviceTokenRefreshIfExpiresInSeconds;
    private int temporaryBuildsLifeSpan;
    private String messageSenderId;
    private int messagingInternalQueueSize;
    private String distributedEventType;
    private String kafkaBootstrapServers;
    private String kafkaTopic;
    private int kafkaNumOfConsumers;
    private int kafkaNumOfRetries;
    private int kafkaRetryBackoffMillis;
    private String kafkaAcks;
    private String kafkaSecurityProtocol;
    private String kafkaSecuritySaslMechanism;
    private String kafkaSecuritySaslJaasConf;
    private String kafkaSecurityUser;
    private String kafkaSecurityPassword;
    private String kafkaProperties;
    private String infinispanClusterName;
    private String infinispanTransportProperties;

    public SystemConfig(@JsonProperty(value="authenticationProviderId") String authenticationProviderId, @JsonProperty(value="coordinatorThreadPoolSize") String coordinatorThreadPoolSize, @JsonProperty(value="brewTagPattern") String brewTagPattern, @JsonProperty(value="coordinatorMaxConcurrentBuilds") String coordinatorMaxConcurrentBuilds, @JsonProperty(value="keycloakServiceAccountConfig") KeycloakClientConfig keycloakServiceAccountConfig, @JsonProperty(value="serviceTokenRefreshIfExpiresInSeconds") String serviceTokenRefreshIfExpiresInSeconds, @JsonProperty(value="temporaryBuildsLifeSpan") String temporaryBuildsLifeSpan, @JsonProperty(value="messageSenderId") String messageSenderId, @JsonProperty(value="messagingInternalQueueSize") String messagingInternalQueueSize, @JsonProperty(value="distributedEventType") String distributedEventType, @JsonProperty(value="kafkaBootstrapServers") String kafkaBootstrapServers, @JsonProperty(value="kafkaTopic") String kafkaTopic, @JsonProperty(value="kafkaNumOfConsumers") String kafkaNumOfConsumers, @JsonProperty(value="kafkaNumOfRetries") String kafkaNumOfRetries, @JsonProperty(value="kafkaRetryBackoffMillis") String kafkaRetryBackoffMillis, @JsonProperty(value="kafkaAcks") String kafkaAcks, @JsonProperty(value="kafkaSecurityProtocol") String kafkaSecurityProtocol, @JsonProperty(value="kafkaSecuritySaslMechanism") String kafkaSecuritySaslMechanism, @JsonProperty(value="kafkaSecuritySaslJaasConf") String kafkaSecuritySaslJaasConf, @JsonProperty(value="kafkaSecurityUser") String kafkaSecurityUser, @JsonProperty(value="kafkaSecurityPassword") String kafkaSecurityPassword, @JsonProperty(value="kafkaProperties") String kafkaProperties, @JsonProperty(value="infinispanClusterName") String infinispanClusterName, @JsonProperty(value="infinispanTransportProperties") String infinispanTransportProperties) {
        this.authenticationProviderId = authenticationProviderId;
        this.coordinatorThreadPoolSize = this.toIntWithDefault("coordinatorThreadPoolSize", coordinatorThreadPoolSize, 1);
        this.coordinatorMaxConcurrentBuilds = this.toIntWithDefault("coordinatorMaxConcurrentBuilds", coordinatorMaxConcurrentBuilds, 10);
        this.brewTagPattern = brewTagPattern;
        this.keycloakServiceAccountConfig = keycloakServiceAccountConfig;
        this.serviceTokenRefreshIfExpiresInSeconds = this.toIntWithDefault("serviceTokenRefreshIfExpiresInSeconds", serviceTokenRefreshIfExpiresInSeconds, 86400);
        this.temporaryBuildsLifeSpan = this.toIntWithDefault("temporaryBuildsLifeSpan", temporaryBuildsLifeSpan, 14);
        this.messageSenderId = messageSenderId;
        this.messagingInternalQueueSize = this.toIntWithDefault("messagingInternalQueueSize", messagingInternalQueueSize, 1000);
        this.distributedEventType = distributedEventType;
        this.kafkaBootstrapServers = kafkaBootstrapServers;
        this.kafkaTopic = kafkaTopic;
        this.kafkaNumOfConsumers = this.toIntWithDefault("kafkaNumOfConsumers", kafkaNumOfConsumers, 1);
        this.kafkaNumOfRetries = this.toIntWithDefault("kafkaNumOfRetries", kafkaNumOfRetries, 0);
        this.kafkaRetryBackoffMillis = this.toIntWithDefault("kafkaRetryBackoffMillis", kafkaRetryBackoffMillis, 0);
        this.kafkaAcks = kafkaAcks;
        this.kafkaSecurityProtocol = kafkaSecurityProtocol;
        this.kafkaSecuritySaslMechanism = kafkaSecuritySaslMechanism;
        this.kafkaSecuritySaslJaasConf = kafkaSecuritySaslJaasConf;
        this.kafkaSecurityUser = kafkaSecurityUser;
        this.kafkaSecurityPassword = kafkaSecurityPassword;
        this.kafkaProperties = kafkaProperties;
        this.infinispanClusterName = infinispanClusterName;
        this.infinispanTransportProperties = infinispanTransportProperties;
    }

    public static Properties readProperties(String file) {
        try {
            Properties properties = new Properties();
            try (FileInputStream stream = new FileInputStream(file);){
                properties.load(stream);
            }
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int getCoordinatorThreadPoolSize() {
        return this.coordinatorThreadPoolSize;
    }

    public int getCoordinatorMaxConcurrentBuilds() {
        return this.coordinatorMaxConcurrentBuilds;
    }

    public String getBrewTagPattern() {
        return this.brewTagPattern;
    }

    public int getTemporaryBuildsLifeSpan() {
        return this.temporaryBuildsLifeSpan;
    }

    public KeycloakClientConfig getKeycloakServiceAccountConfig() {
        return this.keycloakServiceAccountConfig;
    }

    public long getServiceTokenRefreshIfExpiresInSeconds() {
        return this.serviceTokenRefreshIfExpiresInSeconds;
    }

    public String getMessageSenderId() {
        return this.messageSenderId;
    }

    public String getAuthenticationProviderId() {
        return this.authenticationProviderId;
    }

    public int getMessagingInternalQueueSize() {
        return this.messagingInternalQueueSize;
    }

    public String getDistributedEventType() {
        return this.distributedEventType;
    }

    public String getKafkaBootstrapServers() {
        return this.kafkaBootstrapServers;
    }

    public String getKafkaTopic() {
        return this.kafkaTopic;
    }

    public int getKafkaNumOfConsumers() {
        return this.kafkaNumOfConsumers;
    }

    public int getKafkaNumOfRetries() {
        return this.kafkaNumOfRetries;
    }

    public int getKafkaRetryBackoffMillis() {
        return this.kafkaRetryBackoffMillis;
    }

    public String getKafkaAcks() {
        return this.kafkaAcks;
    }

    public String getKafkaSecurityProtocol() {
        return this.kafkaSecurityProtocol;
    }

    public String getKafkaSecuritySaslMechanism() {
        return this.kafkaSecuritySaslMechanism;
    }

    public String getKafkaSecuritySaslJaasConf() {
        return this.kafkaSecuritySaslJaasConf;
    }

    public String getKafkaSecurityUser() {
        return this.kafkaSecurityUser;
    }

    public String getKafkaSecurityPassword() {
        return this.kafkaSecurityPassword;
    }

    public String getKafkaProperties() {
        return this.kafkaProperties;
    }

    public String getInfinispanClusterName() {
        return this.infinispanClusterName;
    }

    public String getInfinispanTransportProperties() {
        return this.infinispanTransportProperties;
    }

    private int toIntWithDefault(String fieldName, String numberAsString, int defaultValue) {
        int result = defaultValue;
        if (numberAsString == null) {
            log.warn("Value in field: " + fieldName + " not set. Will use default value: {}", (Object)defaultValue);
        } else {
            try {
                result = Integer.parseInt(numberAsString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Invalid value in field: " + fieldName + ". Expected an integer, got: {}. Will use default value: {}", new Object[]{numberAsString, defaultValue, nfe});
            }
        }
        return result;
    }

    public String toString() {
        return "SystemConfig{authenticationProviderId='" + this.authenticationProviderId + "', coordinatorThreadPoolSize=" + this.coordinatorThreadPoolSize + ", brewTagPattern='" + this.brewTagPattern + "', coordinatorMaxConcurrentBuilds=" + this.coordinatorMaxConcurrentBuilds + ", keycloakServiceAccountConfig=" + this.keycloakServiceAccountConfig + ", serviceTokenRefreshIfExpiresInSeconds=" + this.serviceTokenRefreshIfExpiresInSeconds + ", temporaryBuildsLifeSpan=" + this.temporaryBuildsLifeSpan + ", messageSenderId='" + this.messageSenderId + "', messagingInternalQueueSize=" + this.messagingInternalQueueSize + ", distributedEventType='" + this.distributedEventType + "', kafkaBootstrapServers='" + this.kafkaBootstrapServers + "', kafkaTopic='" + this.kafkaTopic + "', kafkaNumOfConsumers=" + this.kafkaNumOfConsumers + ", kafkaNumOfRetries=" + this.kafkaNumOfRetries + ", kafkaRetryBackoffMillis=" + this.kafkaRetryBackoffMillis + ", kafkaSecurityProtocol='" + this.kafkaSecurityProtocol + "', kafkaSecuritySaslMechanism='" + this.kafkaSecuritySaslMechanism + "', kafkaSecuritySaslJaasConf='" + this.kafkaSecuritySaslJaasConf + "', kafkaSecurityUser='" + this.kafkaSecurityUser + "', kafkaSecurityPassword='" + this.kafkaSecurityPassword + "', kafkaProperties='" + this.kafkaProperties + "', infinispanClusterName='" + this.infinispanClusterName + "', infinispanTransportProperties='" + this.infinispanTransportProperties + "'}";
    }
}

