/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.json.moduleprovider;

import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.json.moduleconfig.AlignmentConfig;
import org.jboss.pnc.common.json.moduleconfig.BpmModuleConfig;
import org.jboss.pnc.common.json.moduleconfig.DemoDataConfig;
import org.jboss.pnc.common.json.moduleconfig.IndyRepoDriverModuleConfig;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class ModuleConfigFactory {
    private final Logger logger = LoggerFactory.getLogger(ModuleConfigFactory.class);
    private Configuration configuration;

    @Inject
    public ModuleConfigFactory(Configuration configuration) {
        this.configuration = configuration;
    }

    @Produces
    @Dependent
    public SystemConfig createSystemConfig() throws ConfigurationParseException {
        return (SystemConfig)this.configuration.getModuleConfig(new PncConfigProvider<SystemConfig>(SystemConfig.class));
    }

    @Produces
    @Dependent
    public AlignmentConfig createAlignmentConfig() throws ConfigurationParseException {
        return (AlignmentConfig)this.configuration.getModuleConfig(new PncConfigProvider<AlignmentConfig>(AlignmentConfig.class));
    }

    @Produces
    @Dependent
    public DemoDataConfig createDemoDataConfig() throws ConfigurationParseException {
        return (DemoDataConfig)this.configuration.getModuleConfig(new PncConfigProvider<DemoDataConfig>(DemoDataConfig.class));
    }

    @Produces
    @Dependent
    public BpmModuleConfig createBpmModuleConfig() throws ConfigurationParseException {
        return (BpmModuleConfig)this.configuration.getModuleConfig(new PncConfigProvider<BpmModuleConfig>(BpmModuleConfig.class));
    }

    @Produces
    @Dependent
    IndyRepoDriverModuleConfig createMavenRepoDriverModuleConfig() throws ConfigurationParseException {
        return (IndyRepoDriverModuleConfig)this.configuration.getModuleConfig(new PncConfigProvider<IndyRepoDriverModuleConfig>(IndyRepoDriverModuleConfig.class));
    }

    @Produces
    @Dependent
    GlobalModuleGroup createGlobalModuleGroup() {
        try {
            return this.configuration.getGlobalConfig();
        }
        catch (ConfigurationParseException e) {
            this.logger.warn("GlobalModuleGroup is not provided or is broken.");
            return null;
        }
    }
}

