/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.common.json.moduleconfig;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Properties;
import org.jboss.pnc.common.json.AbstractModuleConfig;
import org.jboss.pnc.common.json.moduleconfig.KeycloakClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemConfig
extends AbstractModuleConfig {
    public static final String MODULE_NAME = "system-config";
    private static final Logger log = LoggerFactory.getLogger(SystemConfig.class);
    private final String authenticationProviderId;
    private final int coordinatorThreadPoolSize;
    private final String brewTagPattern;
    private final int coordinatorMaxConcurrentBuilds;
    private final KeycloakClientConfig keycloakServiceAccountConfig;
    private final long serviceTokenRefreshIfExpiresInSeconds;
    private final int temporaryBuildsLifeSpan;
    private final String messageSenderId;
    private final int messagingInternalQueueSize;
    private final String distributedEventType;
    private final String kafkaBootstrapServers;
    private final String kafkaTopic;
    private final int kafkaNumOfConsumers;
    private final int kafkaNumOfRetries;
    private final int kafkaRetryBackoffMillis;
    private final String kafkaAcks;
    private final String kafkaSecurityProtocol;
    private final String kafkaSecuritySaslMechanism;
    private final String kafkaSecuritySaslJaasConf;
    private final String kafkaSecurityUser;
    private final String kafkaSecurityPassword;
    private final String kafkaProperties;
    private final String infinispanClusterName;
    private final String infinispanTransportProperties;
    private final boolean legacyBuildCoordinator;
    private final long recordUpdateJobMillisDelay;
    private final boolean recordUpdateJobEnabled;
    private final int bifrostLogUploadMaxRetries;
    private final int bifrostLogUploadRetryDelay;

    public SystemConfig(@JsonProperty(value="authenticationProviderId") String authenticationProviderId, @JsonProperty(value="coordinatorThreadPoolSize") String coordinatorThreadPoolSize, @JsonProperty(value="brewTagPattern") String brewTagPattern, @JsonProperty(value="coordinatorMaxConcurrentBuilds") String coordinatorMaxConcurrentBuilds, @JsonProperty(value="keycloakServiceAccountConfig") KeycloakClientConfig keycloakServiceAccountConfig, @JsonProperty(value="serviceTokenRefreshIfExpiresInSeconds") String serviceTokenRefreshIfExpiresInSeconds, @JsonProperty(value="temporaryBuildsLifeSpan") String temporaryBuildsLifeSpan, @JsonProperty(value="messageSenderId") String messageSenderId, @JsonProperty(value="messagingInternalQueueSize") String messagingInternalQueueSize, @JsonProperty(value="distributedEventType") String distributedEventType, @JsonProperty(value="kafkaBootstrapServers") String kafkaBootstrapServers, @JsonProperty(value="kafkaTopic") String kafkaTopic, @JsonProperty(value="kafkaNumOfConsumers") String kafkaNumOfConsumers, @JsonProperty(value="kafkaNumOfRetries") String kafkaNumOfRetries, @JsonProperty(value="kafkaRetryBackoffMillis") String kafkaRetryBackoffMillis, @JsonProperty(value="kafkaAcks") String kafkaAcks, @JsonProperty(value="kafkaSecurityProtocol") String kafkaSecurityProtocol, @JsonProperty(value="kafkaSecuritySaslMechanism") String kafkaSecuritySaslMechanism, @JsonProperty(value="kafkaSecuritySaslJaasConf") String kafkaSecuritySaslJaasConf, @JsonProperty(value="kafkaSecurityUser") String kafkaSecurityUser, @JsonProperty(value="kafkaSecurityPassword") String kafkaSecurityPassword, @JsonProperty(value="kafkaProperties") String kafkaProperties, @JsonProperty(value="infinispanClusterName") String infinispanClusterName, @JsonProperty(value="infinispanTransportProperties") String infinispanTransportProperties, @JsonProperty(value="legacyBuildCoordinator") String legacyBuildCoordinator, @JsonProperty(value="recordUpdateJobMillisDelay") String recordUpdateJobMillisDelay, @JsonProperty(value="recordUpdateJobEnabled") String recordUpdateJobEnabled, @JsonProperty(value="bifrostLogUploadMaxRetries") String bifrostLogUploadMaxRetries, @JsonProperty(value="bifrostLogUploadRetryDelay") String bifrostLogUploadRetryDelay) {
        this.authenticationProviderId = authenticationProviderId;
        this.coordinatorThreadPoolSize = this.toIntWithDefault("coordinatorThreadPoolSize", coordinatorThreadPoolSize, 1);
        this.coordinatorMaxConcurrentBuilds = this.toIntWithDefault("coordinatorMaxConcurrentBuilds", coordinatorMaxConcurrentBuilds, 10);
        this.brewTagPattern = brewTagPattern;
        this.keycloakServiceAccountConfig = keycloakServiceAccountConfig;
        this.serviceTokenRefreshIfExpiresInSeconds = this.toIntWithDefault("serviceTokenRefreshIfExpiresInSeconds", serviceTokenRefreshIfExpiresInSeconds, 86400);
        this.temporaryBuildsLifeSpan = this.toIntWithDefault("temporaryBuildsLifeSpan", temporaryBuildsLifeSpan, 14);
        this.messageSenderId = messageSenderId;
        this.messagingInternalQueueSize = this.toIntWithDefault("messagingInternalQueueSize", messagingInternalQueueSize, 1000);
        this.distributedEventType = distributedEventType;
        this.kafkaBootstrapServers = kafkaBootstrapServers;
        this.kafkaTopic = kafkaTopic;
        this.kafkaNumOfConsumers = this.toIntWithDefault("kafkaNumOfConsumers", kafkaNumOfConsumers, 1);
        this.kafkaNumOfRetries = this.toIntWithDefault("kafkaNumOfRetries", kafkaNumOfRetries, 0);
        this.kafkaRetryBackoffMillis = this.toIntWithDefault("kafkaRetryBackoffMillis", kafkaRetryBackoffMillis, 0);
        this.kafkaAcks = kafkaAcks;
        this.kafkaSecurityProtocol = kafkaSecurityProtocol;
        this.kafkaSecuritySaslMechanism = kafkaSecuritySaslMechanism;
        this.kafkaSecuritySaslJaasConf = kafkaSecuritySaslJaasConf;
        this.kafkaSecurityUser = kafkaSecurityUser;
        this.kafkaSecurityPassword = kafkaSecurityPassword;
        this.kafkaProperties = kafkaProperties;
        this.infinispanClusterName = infinispanClusterName;
        this.infinispanTransportProperties = infinispanTransportProperties;
        this.legacyBuildCoordinator = Boolean.valueOf(legacyBuildCoordinator);
        this.recordUpdateJobMillisDelay = this.toLongWithDefault("recordUpdateJobMillisDelay", recordUpdateJobMillisDelay, 30000L);
        this.recordUpdateJobEnabled = Boolean.parseBoolean(recordUpdateJobEnabled);
        this.bifrostLogUploadMaxRetries = this.toIntWithDefault("bifrostLogUploadMaxRetries", bifrostLogUploadMaxRetries, 3);
        this.bifrostLogUploadRetryDelay = this.toIntWithDefault("bifrostLogUploadRetryDelay", bifrostLogUploadRetryDelay, 2);
    }

    public static Properties readProperties(String file) {
        try {
            Properties properties = new Properties();
            try (FileInputStream stream = new FileInputStream(file);){
                properties.load(stream);
            }
            return properties;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int getCoordinatorThreadPoolSize() {
        return this.coordinatorThreadPoolSize;
    }

    public int getCoordinatorMaxConcurrentBuilds() {
        return this.coordinatorMaxConcurrentBuilds;
    }

    public String getBrewTagPattern() {
        return this.brewTagPattern;
    }

    public int getTemporaryBuildsLifeSpan() {
        return this.temporaryBuildsLifeSpan;
    }

    public KeycloakClientConfig getKeycloakServiceAccountConfig() {
        return this.keycloakServiceAccountConfig;
    }

    public long getServiceTokenRefreshIfExpiresInSeconds() {
        return this.serviceTokenRefreshIfExpiresInSeconds;
    }

    public String getMessageSenderId() {
        return this.messageSenderId;
    }

    public String getAuthenticationProviderId() {
        return this.authenticationProviderId;
    }

    public int getMessagingInternalQueueSize() {
        return this.messagingInternalQueueSize;
    }

    public String getDistributedEventType() {
        return this.distributedEventType;
    }

    public String getKafkaBootstrapServers() {
        return this.kafkaBootstrapServers;
    }

    public String getKafkaTopic() {
        return this.kafkaTopic;
    }

    public int getKafkaNumOfConsumers() {
        return this.kafkaNumOfConsumers;
    }

    public int getKafkaNumOfRetries() {
        return this.kafkaNumOfRetries;
    }

    public int getKafkaRetryBackoffMillis() {
        return this.kafkaRetryBackoffMillis;
    }

    public String getKafkaAcks() {
        return this.kafkaAcks;
    }

    public String getKafkaSecurityProtocol() {
        return this.kafkaSecurityProtocol;
    }

    public String getKafkaSecuritySaslMechanism() {
        return this.kafkaSecuritySaslMechanism;
    }

    public String getKafkaSecuritySaslJaasConf() {
        return this.kafkaSecuritySaslJaasConf;
    }

    public String getKafkaSecurityUser() {
        return this.kafkaSecurityUser;
    }

    public String getKafkaSecurityPassword() {
        return this.kafkaSecurityPassword;
    }

    public String getKafkaProperties() {
        return this.kafkaProperties;
    }

    public String getInfinispanClusterName() {
        return this.infinispanClusterName;
    }

    public String getInfinispanTransportProperties() {
        return this.infinispanTransportProperties;
    }

    public boolean isLegacyBuildCoordinator() {
        return this.legacyBuildCoordinator;
    }

    public long getRecordUpdateJobMillisDelay() {
        return this.recordUpdateJobMillisDelay;
    }

    public int getBifrostLogUploadMaxRetries() {
        return this.bifrostLogUploadMaxRetries;
    }

    public int getBifrostLogUploadRetryDelay() {
        return this.bifrostLogUploadRetryDelay;
    }

    private int toIntWithDefault(String fieldName, String numberAsString, int defaultValue) {
        int result = defaultValue;
        if (numberAsString == null) {
            log.warn("Value in field: " + fieldName + " not set. Will use default value: {}", (Object)defaultValue);
        } else {
            try {
                result = Integer.parseInt(numberAsString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Invalid value in field: " + fieldName + ". Expected an integer, got: {}. Will use default value: {}", new Object[]{numberAsString, defaultValue, nfe});
            }
        }
        return result;
    }

    private long toLongWithDefault(String fieldName, String numberAsString, long defaultValue) {
        long result = defaultValue;
        if (numberAsString == null) {
            log.warn("Value in field: " + fieldName + " not set. Will use default value: {}", (Object)defaultValue);
        } else {
            try {
                result = Long.parseLong(numberAsString);
            }
            catch (NumberFormatException nfe) {
                log.warn("Invalid value in field: " + fieldName + ". Expected an long, got: {}. Will use default value: {}", new Object[]{numberAsString, defaultValue, nfe});
            }
        }
        return result;
    }

    public String toString() {
        return "SystemConfig{authenticationProviderId='" + this.authenticationProviderId + "', coordinatorThreadPoolSize=" + this.coordinatorThreadPoolSize + ", brewTagPattern='" + this.brewTagPattern + "', coordinatorMaxConcurrentBuilds=" + this.coordinatorMaxConcurrentBuilds + ", keycloakServiceAccountConfig=" + this.keycloakServiceAccountConfig + ", serviceTokenRefreshIfExpiresInSeconds=" + this.serviceTokenRefreshIfExpiresInSeconds + ", temporaryBuildsLifeSpan=" + this.temporaryBuildsLifeSpan + ", messageSenderId='" + this.messageSenderId + "', messagingInternalQueueSize=" + this.messagingInternalQueueSize + ", distributedEventType='" + this.distributedEventType + "', kafkaBootstrapServers='" + this.kafkaBootstrapServers + "', kafkaTopic='" + this.kafkaTopic + "', kafkaNumOfConsumers=" + this.kafkaNumOfConsumers + ", kafkaNumOfRetries=" + this.kafkaNumOfRetries + ", kafkaRetryBackoffMillis=" + this.kafkaRetryBackoffMillis + ", kafkaAcks='" + this.kafkaAcks + "', kafkaSecurityProtocol='" + this.kafkaSecurityProtocol + "', kafkaSecuritySaslMechanism='" + this.kafkaSecuritySaslMechanism + "', kafkaSecuritySaslJaasConf='" + this.kafkaSecuritySaslJaasConf + "', kafkaSecurityUser='" + this.kafkaSecurityUser + "', kafkaSecurityPassword='" + this.kafkaSecurityPassword + "', kafkaProperties='" + this.kafkaProperties + "', infinispanClusterName='" + this.infinispanClusterName + "', infinispanTransportProperties='" + this.infinispanTransportProperties + "', legacyBuildCoordinator=" + this.legacyBuildCoordinator + ", recordUpdateJobMillisDelay=" + this.recordUpdateJobMillisDelay + ", recordUpdateJobEnabled=" + this.recordUpdateJobEnabled + ", bifrostLogUploadMaxRetries=" + this.bifrostLogUploadMaxRetries + ", bifrostLogUploadRetryDelay=" + this.bifrostLogUploadRetryDelay + "}";
    }

    public boolean isRecordUpdateJobEnabled() {
        return this.recordUpdateJobEnabled;
    }
}

